/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Shape;
import java.awt.font.LayoutPath;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Formatter;

public abstract class LayoutPathImpl
extends LayoutPath {
    private static final boolean LOGMAP = false;
    private static final Formatter LOG = new Formatter(System.out);

    public Point2D pointToPath(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.pointToPath(double_, double_);
        return double_;
    }

    public Point2D pathToPoint(double d, double d2, boolean bl) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.pathToPoint(double_, bl, double_);
        return double_;
    }

    public void pointToPath(double d, double d2, Point2D point2D) {
        point2D.setLocation(d, d2);
        this.pointToPath(point2D, point2D);
    }

    public void pathToPoint(double d, double d2, boolean bl, Point2D point2D) {
        point2D.setLocation(d, d2);
        this.pathToPoint(point2D, bl, point2D);
    }

    public abstract double start();

    public abstract double end();

    public abstract double length();

    public abstract Shape mapShape(Shape var1);

    public static LayoutPathImpl getPath(EndType endType, double ... dArray) {
        if ((dArray.length & 1) != 0) {
            throw new IllegalArgumentException("odd number of points not allowed");
        }
        return SegmentPath.get(endType, dArray);
    }

    public static class EmptyPath
    extends LayoutPathImpl {
        private AffineTransform tx;

        public EmptyPath(AffineTransform affineTransform) {
            this.tx = affineTransform;
        }

        @Override
        public void pathToPoint(Point2D point2D, boolean bl, Point2D point2D2) {
            if (this.tx != null) {
                this.tx.transform(point2D, point2D2);
            } else {
                point2D2.setLocation(point2D);
            }
        }

        @Override
        public boolean pointToPath(Point2D point2D, Point2D point2D2) {
            point2D2.setLocation(point2D);
            if (this.tx != null) {
                try {
                    this.tx.inverseTransform(point2D, point2D2);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            return point2D2.getX() > 0.0;
        }

        @Override
        public double start() {
            return 0.0;
        }

        @Override
        public double end() {
            return 0.0;
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public Shape mapShape(Shape shape) {
            if (this.tx != null) {
                return this.tx.createTransformedShape(shape);
            }
            return shape;
        }
    }

    public static final class SegmentPath
    extends LayoutPathImpl {
        private double[] data;
        EndType etype;

        public static SegmentPath get(EndType endType, double ... dArray) {
            return new SegmentPathBuilder().build(endType, dArray);
        }

        SegmentPath(double[] dArray, EndType endType) {
            this.data = dArray;
            this.etype = endType;
        }

        @Override
        public void pathToPoint(Point2D point2D, boolean bl, Point2D point2D2) {
            this.locateAndGetIndex(point2D, bl, point2D2);
        }

        @Override
        public boolean pointToPath(Point2D point2D, Point2D point2D2) {
            boolean bl;
            int n;
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = this.data[0];
            double d4 = this.data[1];
            double d5 = this.data[2];
            double d6 = Double.MAX_VALUE;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            int n2 = 0;
            for (n = 3; n < this.data.length; n += 3) {
                double d10;
                double d11;
                double d12;
                block13: {
                    double d13;
                    double d14;
                    int n3;
                    double d15;
                    double d16;
                    double d17;
                    block11: {
                        block12: {
                            double d18;
                            double d19;
                            double d20;
                            double d21;
                            block10: {
                                d12 = this.data[n];
                                d11 = this.data[n + 1];
                                d10 = this.data[n + 2];
                                d21 = d12 - d3;
                                d20 = d11 - d4;
                                d19 = d10 - d5;
                                double d22 = d - d3;
                                double d23 = d2 - d4;
                                d18 = d21 * d22 + d20 * d23;
                                if (d19 != 0.0 && (!(d18 < 0.0) || this.etype.isExtended() && n == 3)) break block10;
                                d17 = d3;
                                d16 = d4;
                                d15 = d5;
                                n3 = n;
                                break block11;
                            }
                            d14 = d19 * d19;
                            if (!(d18 <= d14) && (!this.etype.isExtended() || n != this.data.length - 3)) break block12;
                            d13 = d18 / d14;
                            d17 = d3 + d13 * d21;
                            d16 = d4 + d13 * d20;
                            d15 = d5 + d13 * d19;
                            n3 = n;
                            break block11;
                        }
                        if (n != this.data.length - 3) break block13;
                        d17 = d12;
                        d16 = d11;
                        d15 = d10;
                        n3 = this.data.length;
                    }
                    d14 = d - d17;
                    d13 = d2 - d16;
                    double d24 = d14 * d14 + d13 * d13;
                    if (d24 <= d6) {
                        d6 = d24;
                        d7 = d17;
                        d8 = d16;
                        d9 = d15;
                        n2 = n3;
                    }
                }
                d3 = d12;
                d4 = d11;
                d5 = d10;
            }
            d3 = this.data[n2 - 3];
            d4 = this.data[n2 - 2];
            if (d7 != d3 || d8 != d4) {
                double d25 = this.data[n2];
                double d26 = this.data[n2 + 1];
                double d27 = Math.sqrt(d6);
                if ((d - d7) * (d26 - d4) > (d2 - d8) * (d25 - d3)) {
                    d27 = -d27;
                }
                point2D2.setLocation(d9, d27);
                return false;
            }
            n = n2 != 3 && this.data[n2 - 1] != this.data[n2 - 4] ? 1 : 0;
            boolean bl2 = n2 != this.data.length && this.data[n2 - 1] != this.data[n2 + 2];
            boolean bl3 = bl = this.etype.isExtended() && (n2 == 3 || n2 == this.data.length);
            if (n != 0 && bl2) {
                Point2D.Double double_ = new Point2D.Double(d, d2);
                this.calcoffset(n2 - 3, bl, double_);
                Point2D.Double double_2 = new Point2D.Double(d, d2);
                this.calcoffset(n2, bl, double_2);
                if (Math.abs(double_.y) > Math.abs(double_2.y)) {
                    point2D2.setLocation(double_);
                    return true;
                }
                point2D2.setLocation(double_2);
                return false;
            }
            if (n != 0) {
                point2D2.setLocation(d, d2);
                this.calcoffset(n2 - 3, bl, point2D2);
                return true;
            }
            point2D2.setLocation(d, d2);
            this.calcoffset(n2, bl, point2D2);
            return false;
        }

        private void calcoffset(int n, boolean bl, Point2D point2D) {
            double d = this.data[n - 3];
            double d2 = this.data[n - 2];
            double d3 = point2D.getX() - d;
            double d4 = point2D.getY() - d2;
            double d5 = this.data[n] - d;
            double d6 = this.data[n + 1] - d2;
            double d7 = this.data[n + 2] - this.data[n - 1];
            double d8 = (d3 * d5 + d4 * d6) / d7;
            double d9 = (d3 * -d6 + d4 * d5) / d7;
            if (!bl) {
                if (d8 < 0.0) {
                    d8 = 0.0;
                } else if (d8 > d7) {
                    d8 = d7;
                }
            }
            point2D.setLocation(d8 += this.data[n - 1], d9);
        }

        @Override
        public Shape mapShape(Shape shape) {
            return new Mapper().mapShape(shape);
        }

        @Override
        public double start() {
            return this.data[2];
        }

        @Override
        public double end() {
            return this.data[this.data.length - 1];
        }

        @Override
        public double length() {
            return this.data[this.data.length - 1] - this.data[2];
        }

        private double getClosedAdvance(double d, boolean bl) {
            if (this.etype.isClosed()) {
                int n;
                d -= this.data[2];
                if ((d -= (double)(n = (int)(d / this.length())) * this.length()) < 0.0 || d == 0.0 && bl) {
                    d += this.length();
                }
                d += this.data[2];
            }
            return d;
        }

        private int getSegmentIndexForAdvance(double d, boolean bl) {
            double d2;
            int n;
            d = this.getClosedAdvance(d, bl);
            int n2 = this.data.length - 1;
            for (n = 5; !(n >= n2 || d < (d2 = this.data[n]) || d == d2 && bl); n += 3) {
            }
            return n - 2;
        }

        private void map(int n, double d, double d2, Point2D point2D) {
            double d3 = this.data[n] - this.data[n - 3];
            double d4 = this.data[n + 1] - this.data[n - 2];
            double d5 = this.data[n + 2] - this.data[n - 1];
            double d6 = d3 / d5;
            double d7 = d4 / d5;
            point2D.setLocation(this.data[n - 3] + (d -= this.data[n - 1]) * d6 - d2 * d7, this.data[n - 2] + d * d7 + d2 * d6);
        }

        private int locateAndGetIndex(Point2D point2D, boolean bl, Point2D point2D2) {
            double d = point2D.getX();
            double d2 = point2D.getY();
            int n = this.getSegmentIndexForAdvance(d, bl);
            this.map(n, d, d2, point2D2);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append(this.etype.toString());
            stringBuilder.append(" ");
            for (int i = 0; i < this.data.length; i += 3) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                float f = (float)((int)(this.data[i] * 100.0)) / 100.0f;
                float f2 = (float)((int)(this.data[i + 1] * 100.0)) / 100.0f;
                float f3 = (float)((int)(this.data[i + 2] * 10.0)) / 10.0f;
                stringBuilder.append("{");
                stringBuilder.append(f);
                stringBuilder.append(",");
                stringBuilder.append(f2);
                stringBuilder.append(",");
                stringBuilder.append(f3);
                stringBuilder.append("}");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        class Mapper {
            final LineInfo li;
            final ArrayList<Segment> segments;
            final Point2D.Double mpt;
            final Point2D.Double cpt;
            boolean haveMT;

            Mapper() {
                this.li = new LineInfo();
                this.segments = new ArrayList();
                for (int i = 3; i < SegmentPath.this.data.length; i += 3) {
                    if (SegmentPath.this.data[i + 2] == SegmentPath.this.data[i - 1]) continue;
                    this.segments.add(new Segment(i));
                }
                this.mpt = new Point2D.Double();
                this.cpt = new Point2D.Double();
            }

            void init() {
                this.haveMT = false;
                for (Segment segment : this.segments) {
                    segment.init();
                }
            }

            void moveTo(double d, double d2) {
                this.mpt.x = d;
                this.mpt.y = d2;
                this.haveMT = true;
            }

            void lineTo(double d, double d2) {
                if (this.haveMT) {
                    this.cpt.x = this.mpt.x;
                    this.cpt.y = this.mpt.y;
                }
                if (d == this.cpt.x && d2 == this.cpt.y) {
                    return;
                }
                if (this.haveMT) {
                    this.haveMT = false;
                    for (Segment segment : this.segments) {
                        segment.move();
                    }
                }
                this.li.set(this.cpt.x, this.cpt.y, d, d2);
                for (Segment segment : this.segments) {
                    segment.line(this.li);
                }
                this.cpt.x = d;
                this.cpt.y = d2;
            }

            void close() {
                this.lineTo(this.mpt.x, this.mpt.y);
                for (Segment segment : this.segments) {
                    segment.close();
                }
            }

            public Shape mapShape(Shape shape) {
                PathIterator pathIterator = shape.getPathIterator(null, 1.0);
                this.init();
                double[] dArray = new double[2];
                while (!pathIterator.isDone()) {
                    switch (pathIterator.currentSegment(dArray)) {
                        case 4: {
                            this.close();
                            break;
                        }
                        case 0: {
                            this.moveTo(dArray[0], dArray[1]);
                            break;
                        }
                        case 1: {
                            this.lineTo(dArray[0], dArray[1]);
                            break;
                        }
                    }
                    pathIterator.next();
                }
                GeneralPath generalPath = new GeneralPath();
                for (Segment segment : this.segments) {
                    generalPath.append(segment.gp, false);
                }
                return generalPath;
            }
        }

        class Segment {
            final int ix;
            final double ux;
            final double uy;
            final LineInfo temp;
            boolean broken;
            double cx;
            double cy;
            GeneralPath gp;

            Segment(int n) {
                this.ix = n;
                double d = SegmentPath.this.data[n + 2] - SegmentPath.this.data[n - 1];
                this.ux = (SegmentPath.this.data[n] - SegmentPath.this.data[n - 3]) / d;
                this.uy = (SegmentPath.this.data[n + 1] - SegmentPath.this.data[n - 2]) / d;
                this.temp = new LineInfo();
            }

            void init() {
                this.broken = true;
                this.cy = Double.MIN_VALUE;
                this.cx = Double.MIN_VALUE;
                this.gp = new GeneralPath();
            }

            void move() {
                this.broken = true;
            }

            void close() {
                if (!this.broken) {
                    this.gp.closePath();
                }
            }

            void line(LineInfo lineInfo) {
                if (lineInfo.pin(this.ix, this.temp)) {
                    this.temp.sx -= SegmentPath.this.data[this.ix - 1];
                    double d = SegmentPath.this.data[this.ix - 3] + this.temp.sx * this.ux - this.temp.sy * this.uy;
                    double d2 = SegmentPath.this.data[this.ix - 2] + this.temp.sx * this.uy + this.temp.sy * this.ux;
                    this.temp.lx -= SegmentPath.this.data[this.ix - 1];
                    double d3 = SegmentPath.this.data[this.ix - 3] + this.temp.lx * this.ux - this.temp.ly * this.uy;
                    double d4 = SegmentPath.this.data[this.ix - 2] + this.temp.lx * this.uy + this.temp.ly * this.ux;
                    if (d != this.cx || d2 != this.cy) {
                        if (this.broken) {
                            this.gp.moveTo((float)d, (float)d2);
                        } else {
                            this.gp.lineTo((float)d, (float)d2);
                        }
                    }
                    this.gp.lineTo((float)d3, (float)d4);
                    this.broken = false;
                    this.cx = d3;
                    this.cy = d4;
                }
            }
        }

        class LineInfo {
            double sx;
            double sy;
            double lx;
            double ly;
            double m;

            LineInfo() {
            }

            void set(double d, double d2, double d3, double d4) {
                this.sx = d;
                this.sy = d2;
                this.lx = d3;
                this.ly = d4;
                double d5 = d3 - d;
                if (d5 == 0.0) {
                    this.m = 0.0;
                } else {
                    double d6 = d4 - d2;
                    this.m = d6 / d5;
                }
            }

            void set(LineInfo lineInfo) {
                this.sx = lineInfo.sx;
                this.sy = lineInfo.sy;
                this.lx = lineInfo.lx;
                this.ly = lineInfo.ly;
                this.m = lineInfo.m;
            }

            boolean pin(double d, double d2, LineInfo lineInfo) {
                lineInfo.set(this);
                if (this.lx >= this.sx) {
                    if (this.sx < d2 && this.lx >= d) {
                        if (this.sx < d) {
                            if (this.m != 0.0) {
                                lineInfo.sy = this.sy + this.m * (d - this.sx);
                            }
                            lineInfo.sx = d;
                        }
                        if (this.lx > d2) {
                            if (this.m != 0.0) {
                                lineInfo.ly = this.ly + this.m * (d2 - this.lx);
                            }
                            lineInfo.lx = d2;
                        }
                        return true;
                    }
                } else if (this.lx < d2 && this.sx >= d) {
                    if (this.lx < d) {
                        if (this.m != 0.0) {
                            lineInfo.ly = this.ly + this.m * (d - this.lx);
                        }
                        lineInfo.lx = d;
                    }
                    if (this.sx > d2) {
                        if (this.m != 0.0) {
                            lineInfo.sy = this.sy + this.m * (d2 - this.sx);
                        }
                        lineInfo.sx = d2;
                    }
                    return true;
                }
                return false;
            }

            boolean pin(int n, LineInfo lineInfo) {
                double d = SegmentPath.this.data[n - 1];
                double d2 = SegmentPath.this.data[n + 2];
                switch (SegmentPath.this.etype) {
                    case PINNED: {
                        break;
                    }
                    case EXTENDED: {
                        if (n == 3) {
                            d = Double.NEGATIVE_INFINITY;
                        }
                        if (n != SegmentPath.this.data.length - 3) break;
                        d2 = Double.POSITIVE_INFINITY;
                        break;
                    }
                }
                return this.pin(d, d2, lineInfo);
            }
        }
    }

    public static final class SegmentPathBuilder {
        private double[] data;
        private int w;
        private double px;
        private double py;
        private double a;
        private boolean pconnect;

        public void reset(int n) {
            if (this.data == null || n > this.data.length) {
                this.data = new double[n];
            } else if (n == 0) {
                this.data = null;
            }
            this.w = 0;
            this.py = 0.0;
            this.px = 0.0;
            this.pconnect = false;
        }

        public SegmentPath build(EndType endType, double ... dArray) {
            assert (dArray.length % 2 == 0);
            this.reset(dArray.length / 2 * 3);
            for (int i = 0; i < dArray.length; i += 2) {
                this.nextPoint(dArray[i], dArray[i + 1], i != 0);
            }
            return this.complete(endType);
        }

        public void moveTo(double d, double d2) {
            this.nextPoint(d, d2, false);
        }

        public void lineTo(double d, double d2) {
            this.nextPoint(d, d2, true);
        }

        private void nextPoint(double d, double d2, boolean bl) {
            if (d == this.px && d2 == this.py) {
                return;
            }
            if (this.w == 0) {
                if (this.data == null) {
                    this.data = new double[6];
                }
                if (bl) {
                    this.w = 3;
                }
            }
            if (this.w != 0 && !bl && !this.pconnect) {
                this.data[this.w - 3] = this.px = d;
                this.data[this.w - 2] = this.py = d2;
                return;
            }
            if (this.w == this.data.length) {
                double[] dArray = new double[this.w * 2];
                System.arraycopy((Object)this.data, 0, (Object)dArray, 0, this.w);
                this.data = dArray;
            }
            if (bl) {
                double d3 = d - this.px;
                double d4 = d2 - this.py;
                this.a += Math.sqrt(d3 * d3 + d4 * d4);
            }
            this.data[this.w++] = d;
            this.data[this.w++] = d2;
            this.data[this.w++] = this.a;
            this.px = d;
            this.py = d2;
            this.pconnect = bl;
        }

        public SegmentPath complete() {
            return this.complete(EndType.EXTENDED);
        }

        public SegmentPath complete(EndType endType) {
            SegmentPath segmentPath;
            if (this.data == null || this.w < 6) {
                return null;
            }
            if (this.w == this.data.length) {
                segmentPath = new SegmentPath(this.data, endType);
                this.reset(0);
            } else {
                double[] dArray = new double[this.w];
                System.arraycopy((Object)this.data, 0, (Object)dArray, 0, this.w);
                segmentPath = new SegmentPath(dArray, endType);
                this.reset(2);
            }
            return segmentPath;
        }
    }

    public static enum EndType {
        PINNED,
        EXTENDED,
        CLOSED;


        public boolean isPinned() {
            return this == PINNED;
        }

        public boolean isExtended() {
            return this == EXTENDED;
        }

        public boolean isClosed() {
            return this == CLOSED;
        }
    }
}

