/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StateInvariantError;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer;
    private transient Vector<Style> listeningStyles = new Vector();
    private transient ChangeListener styleChangeListener;
    private transient ChangeListener styleContextChangeListener;
    private transient ChangeUpdateRunnable updateRunnable;

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        this.buffer = new ElementBuffer(this.createDefaultRoot());
        Style style = styleContext.getStyle("default");
        this.setLogicalStyle(0, style);
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new GapContent(4096), styleContext);
    }

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    @Override
    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    protected void create(ElementSpec[] elementSpecArray) {
        try {
            if (this.getLength() != 0) {
                this.remove(0, this.getLength());
            }
            this.writeLock();
            AbstractDocument.Content content = this.getContent();
            int n = elementSpecArray.length;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                ElementSpec elementSpec = elementSpecArray[i];
                if (elementSpec.getLength() <= 0) continue;
                stringBuilder.append(elementSpec.getArray(), elementSpec.getOffset(), elementSpec.getLength());
            }
            UndoableEdit undoableEdit = content.insertString(0, stringBuilder.toString());
            int n2 = stringBuilder.length();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(0, n2, DocumentEvent.EventType.INSERT);
            defaultDocumentEvent.addEdit(undoableEdit);
            this.buffer.create(n2, elementSpecArray, defaultDocumentEvent);
            super.insertUpdate(defaultDocumentEvent, null);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("problem initializing");
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(int n, ElementSpec[] elementSpecArray) throws BadLocationException {
        if (elementSpecArray == null || elementSpecArray.length == 0) {
            return;
        }
        try {
            this.writeLock();
            AbstractDocument.Content content = this.getContent();
            int n2 = elementSpecArray.length;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                ElementSpec elementSpec = elementSpecArray[i];
                if (elementSpec.getLength() <= 0) continue;
                stringBuilder.append(elementSpec.getArray(), elementSpec.getOffset(), elementSpec.getLength());
            }
            if (stringBuilder.length() == 0) {
                return;
            }
            UndoableEdit undoableEdit = content.insertString(n, stringBuilder.toString());
            int n3 = stringBuilder.length();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n3, DocumentEvent.EventType.INSERT);
            defaultDocumentEvent.addEdit(undoableEdit);
            this.buffer.insert(n, n3, elementSpecArray, defaultDocumentEvent);
            super.insertUpdate(defaultDocumentEvent, null);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeElement(Element element) {
        try {
            this.writeLock();
            this.removeElementImpl(element);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeElementImpl(Element element) {
        int n;
        int n2;
        if (element.getDocument() != this) {
            throw new IllegalArgumentException("element doesn't belong to document");
        }
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
        if (branchElement == null) {
            throw new IllegalArgumentException("can't remove the root element");
        }
        int n3 = n2 = element.getStartOffset();
        int n4 = n = element.getEndOffset();
        int n5 = this.getLength() + 1;
        AbstractDocument.Content content = this.getContent();
        boolean bl = false;
        boolean bl2 = Utilities.isComposedTextElement(element);
        if (n >= n5) {
            if (n2 <= 0) {
                throw new IllegalArgumentException("can't remove the whole content");
            }
            n4 = n5 - 1;
            try {
                if (content.getString(n2 - 1, 1).charAt(0) == '\n') {
                    --n3;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
            bl = true;
        }
        int n6 = n4 - n3;
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n3, n6, DocumentEvent.EventType.REMOVE);
        UndoableEdit undoableEdit = null;
        while (branchElement.getElementCount() == 1) {
            element = branchElement;
            if ((branchElement = (AbstractDocument.BranchElement)branchElement.getParentElement()) != null) continue;
            throw new IllegalStateException("invalid element structure");
        }
        Element[] elementArray = new Element[]{element};
        Element[] elementArray2 = new Element[]{};
        int n7 = branchElement.getElementIndex(n2);
        branchElement.replace(n7, 1, elementArray2);
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement, n7, elementArray, elementArray2));
        if (n6 > 0) {
            try {
                undoableEdit = content.remove(n3, n6);
                if (undoableEdit != null) {
                    defaultDocumentEvent.addEdit(undoableEdit);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
            n5 -= n6;
        }
        if (bl) {
            Element element2;
            for (element2 = branchElement.getElement(branchElement.getElementCount() - 1); element2 != null && !element2.isLeaf(); element2 = element2.getElement(element2.getElementCount() - 1)) {
            }
            if (element2 == null) {
                throw new IllegalStateException("invalid element structure");
            }
            int n8 = element2.getStartOffset();
            AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)element2.getParentElement();
            int n9 = branchElement2.getElementIndex(n8);
            Element element3 = this.createLeafElement(branchElement2, element2.getAttributes(), n8, n5);
            Element[] elementArray3 = new Element[]{element2};
            Element[] elementArray4 = new Element[]{element3};
            branchElement2.replace(n9, 1, elementArray4);
            defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement2, n9, elementArray3, elementArray4));
        }
        this.postRemoveUpdate(defaultDocumentEvent);
        defaultDocumentEvent.end();
        this.fireRemoveUpdate(defaultDocumentEvent);
        if (!bl2 || undoableEdit == null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
    }

    @Override
    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.addStyle(string, style);
    }

    @Override
    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    @Override
    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    public Enumeration<?> getStyleNames() {
        return ((StyleContext)this.getAttributeContext()).getStyleNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogicalStyle(int n, Style style) {
        Element element = this.getParagraphElement(n);
        if (element != null && element instanceof AbstractDocument.AbstractElement) {
            try {
                this.writeLock();
                StyleChangeUndoableEdit styleChangeUndoableEdit = new StyleChangeUndoableEdit((AbstractDocument.AbstractElement)element, style);
                ((AbstractDocument.AbstractElement)element).setResolveParent(style);
                int n2 = element.getStartOffset();
                int n3 = element.getEndOffset();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE);
                defaultDocumentEvent.addEdit(styleChangeUndoableEdit);
                defaultDocumentEvent.end();
                this.fireChangedUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public Style getLogicalStyle(int n) {
        AttributeSet attributeSet;
        AttributeSet attributeSet2;
        Style style = null;
        Element element = this.getParagraphElement(n);
        if (element != null && (attributeSet2 = (attributeSet = element.getAttributes()).getResolveParent()) instanceof Style) {
            style = (Style)attributeSet2;
        }
        return style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (n2 == 0) {
            return;
        }
        try {
            Element element;
            int n3;
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            this.buffer.change(n, n2, defaultDocumentEvent);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n4 = n;
            while (n4 < n + n2 && n4 != (n3 = (element = this.getCharacterElement(n4)).getEndOffset())) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n4 = n3;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n + (n2 > 0 ? n2 - 1 : 0));
            boolean bl2 = Boolean.TRUE.equals(this.getProperty("i18n"));
            boolean bl3 = false;
            for (int i = n3; i <= n4; ++i) {
                Element element2 = element.getElement(i);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element2, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                if (!bl2 || bl3) continue;
                bl3 = mutableAttributeSet.getAttribute(TextAttribute.RUN_DIRECTION) != null;
            }
            if (bl3) {
                this.updateBidi(defaultDocumentEvent);
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        if (element != null) {
            return element.getParentElement();
        }
        return element;
    }

    @Override
    public Element getCharacterElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        return element;
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        }
        Element element = this.getParagraphElement(n + n2);
        AttributeSet attributeSet2 = element.getAttributes();
        Element element2 = this.getParagraphElement(n);
        Element element3 = element2.getElement(element2.getElementIndex(n));
        int n3 = n + n2;
        boolean bl = element3.getEndOffset() == n3;
        AttributeSet attributeSet3 = element3.getAttributes();
        try {
            Object object;
            int n4;
            Segment segment = new Segment();
            Vector<ElementSpec> vector = new Vector<ElementSpec>();
            ElementSpec elementSpec = null;
            boolean bl2 = false;
            short s = 6;
            if (n > 0) {
                this.getText(n - 1, 1, segment);
                if (segment.array[segment.offset] == '\n') {
                    bl2 = true;
                    s = this.createSpecsForInsertAfterNewline(element, element2, attributeSet2, vector, n, n3);
                    for (int i = vector.size() - 1; i >= 0; --i) {
                        ElementSpec elementSpec2 = vector.elementAt(i);
                        if (elementSpec2.getType() != 1) continue;
                        elementSpec = elementSpec2;
                        break;
                    }
                }
            }
            if (!bl2) {
                attributeSet2 = element2.getAttributes();
            }
            this.getText(n, n2, segment);
            char[] cArray = segment.array;
            int n5 = segment.offset + segment.count;
            int n6 = segment.offset;
            for (int i = segment.offset; i < n5; ++i) {
                if (cArray[i] != '\n') continue;
                n4 = i + 1;
                vector.addElement(new ElementSpec(attributeSet, 3, n4 - n6));
                vector.addElement(new ElementSpec(null, 2));
                elementSpec = new ElementSpec(attributeSet2, 1);
                vector.addElement(elementSpec);
                n6 = n4;
            }
            if (n6 < n5) {
                vector.addElement(new ElementSpec(attributeSet, 3, n5 - n6));
            }
            ElementSpec elementSpec3 = vector.firstElement();
            n4 = this.getLength();
            if (elementSpec3.getType() == 3 && attributeSet3.isEqual(attributeSet)) {
                elementSpec3.setDirection((short)4);
            }
            if (elementSpec != null) {
                if (bl2) {
                    elementSpec.setDirection(s);
                } else if (element2.getEndOffset() != n3) {
                    elementSpec.setDirection((short)7);
                } else {
                    object = element2.getParentElement();
                    int n7 = object.getElementIndex(n);
                    if (n7 + 1 < object.getElementCount() && !object.getElement(n7 + 1).isLeaf()) {
                        elementSpec.setDirection((short)5);
                    }
                }
            }
            if (bl && n3 < n4) {
                Element element4;
                object = vector.lastElement();
                if (((ElementSpec)object).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && (elementSpec == null && (element == element2 || bl2) || elementSpec != null && elementSpec.getDirection() != 6) && (element4 = element.getElement(element.getElementIndex(n3))).isLeaf() && attributeSet.isEqual(element4.getAttributes())) {
                    ((ElementSpec)object).setDirection((short)5);
                }
            } else if (!bl && elementSpec != null && elementSpec.getDirection() == 7 && ((ElementSpec)(object = vector.lastElement())).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && attributeSet.isEqual(attributeSet3)) {
                ((ElementSpec)object).setDirection((short)5);
            }
            if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
                object = (MutableAttributeSet)attributeSet;
                object.addAttributes(attributeSet3);
                object.addAttribute("$ename", "content");
                object.addAttribute(StyleConstants.NameAttribute, "content");
                if (object.isDefined("CR")) {
                    object.removeAttribute("CR");
                }
            }
            object = new ElementSpec[vector.size()];
            vector.copyInto((Object[])object);
            this.buffer.insert(n, n2, (ElementSpec[])object, defaultDocumentEvent);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    short createSpecsForInsertAfterNewline(Element element, Element element2, AttributeSet attributeSet, Vector<ElementSpec> vector, int n, int n2) {
        if (element.getParentElement() == element2.getParentElement()) {
            ElementSpec elementSpec = new ElementSpec(attributeSet, 2);
            vector.addElement(elementSpec);
            elementSpec = new ElementSpec(attributeSet, 1);
            vector.addElement(elementSpec);
            if (element2.getEndOffset() != n2) {
                return 7;
            }
            Element element3 = element2.getParentElement();
            if (element3.getElementIndex(n) + 1 < element3.getElementCount()) {
                return 5;
            }
        } else {
            Element element4;
            Vector<Element> vector2 = new Vector<Element>();
            Vector<Element> vector3 = new Vector<Element>();
            for (element4 = element2; element4 != null; element4 = element4.getParentElement()) {
                vector2.addElement(element4);
            }
            int n3 = -1;
            for (element4 = element; element4 != null && (n3 = vector2.indexOf(element4)) == -1; element4 = element4.getParentElement()) {
                vector3.addElement(element4);
            }
            if (element4 != null) {
                for (int i = 0; i < n3; ++i) {
                    vector.addElement(new ElementSpec(null, 2));
                }
                for (int i = vector3.size() - 1; i >= 0; --i) {
                    ElementSpec elementSpec = new ElementSpec(((Element)vector3.elementAt(i)).getAttributes(), 1);
                    if (i > 0) {
                        elementSpec.setDirection((short)5);
                    }
                    vector.addElement(elementSpec);
                }
                if (vector3.size() > 0) {
                    return 5;
                }
                return 7;
            }
        }
        return 6;
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        this.buffer.remove(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), defaultDocumentEvent);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SectionElement sectionElement = new SectionElement();
        AbstractDocument.BranchElement branchElement = new AbstractDocument.BranchElement(sectionElement, null);
        AbstractDocument.LeafElement leafElement = new AbstractDocument.LeafElement(branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        elementArray[0] = branchElement;
        sectionElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return sectionElement;
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getForeground(attributeSet);
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getBackground(attributeSet);
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void styleChanged(Style style) {
        if (this.getLength() != 0) {
            if (this.updateRunnable == null) {
                this.updateRunnable = new ChangeUpdateRunnable();
            }
            ChangeUpdateRunnable changeUpdateRunnable = this.updateRunnable;
            synchronized (changeUpdateRunnable) {
                if (!this.updateRunnable.isPending) {
                    SwingUtilities.invokeLater(this.updateRunnable);
                    this.updateRunnable.isPending = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        Vector<Style> vector = this.listeningStyles;
        synchronized (vector) {
            int n = this.listenerList.getListenerCount(DocumentListener.class);
            super.addDocumentListener(documentListener);
            if (n == 0) {
                if (this.styleContextChangeListener == null) {
                    this.styleContextChangeListener = this.createStyleContextChangeListener();
                }
                if (this.styleContextChangeListener != null) {
                    StyleContext styleContext = (StyleContext)this.getAttributeContext();
                    List<ChangeListener> list = AbstractChangeHandler.getStaleListeners(this.styleContextChangeListener);
                    for (ChangeListener changeListener : list) {
                        styleContext.removeChangeListener(changeListener);
                    }
                    styleContext.addChangeListener(this.styleContextChangeListener);
                }
                this.updateStylesListeningTo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        Vector<Style> vector = this.listeningStyles;
        synchronized (vector) {
            super.removeDocumentListener(documentListener);
            if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
                for (int i = this.listeningStyles.size() - 1; i >= 0; --i) {
                    this.listeningStyles.elementAt(i).removeChangeListener(this.styleChangeListener);
                }
                this.listeningStyles.removeAllElements();
                if (this.styleContextChangeListener != null) {
                    StyleContext styleContext = (StyleContext)this.getAttributeContext();
                    styleContext.removeChangeListener(this.styleContextChangeListener);
                }
            }
        }
    }

    ChangeListener createStyleChangeListener() {
        return new StyleChangeHandler(this);
    }

    ChangeListener createStyleContextChangeListener() {
        return new StyleContextChangeHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStylesListeningTo() {
        Vector<Style> vector = this.listeningStyles;
        synchronized (vector) {
            StyleContext styleContext = (StyleContext)this.getAttributeContext();
            if (this.styleChangeListener == null) {
                this.styleChangeListener = this.createStyleChangeListener();
            }
            if (this.styleChangeListener != null && styleContext != null) {
                Style style;
                Enumeration<?> enumeration = styleContext.getStyleNames();
                Vector vector2 = (Vector)this.listeningStyles.clone();
                this.listeningStyles.removeAllElements();
                List<ChangeListener> list = AbstractChangeHandler.getStaleListeners(this.styleChangeListener);
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    style = styleContext.getStyle(string);
                    int n = vector2.indexOf(style);
                    this.listeningStyles.addElement(style);
                    if (n == -1) {
                        for (ChangeListener changeListener : list) {
                            style.removeChangeListener(changeListener);
                        }
                        style.addChangeListener(this.styleChangeListener);
                        continue;
                    }
                    vector2.removeElementAt(n);
                }
                for (int i = vector2.size() - 1; i >= 0; --i) {
                    style = (Style)vector2.elementAt(i);
                    style.removeChangeListener(this.styleChangeListener);
                }
                if (this.listeningStyles.size() == 0) {
                    this.styleChangeListener = null;
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.listeningStyles = new Vector();
        objectInputStream.defaultReadObject();
        if (this.styleContextChangeListener == null && this.listenerList.getListenerCount(DocumentListener.class) > 0) {
            this.styleContextChangeListener = this.createStyleContextChangeListener();
            if (this.styleContextChangeListener != null) {
                StyleContext styleContext = (StyleContext)this.getAttributeContext();
                styleContext.addChangeListener(this.styleContextChangeListener);
            }
            this.updateStylesListeningTo();
        }
    }

    class ChangeUpdateRunnable
    implements Runnable {
        boolean isPending = false;

        ChangeUpdateRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this;
            synchronized (object) {
                this.isPending = false;
            }
            try {
                DefaultStyledDocument.this.writeLock();
                object = new AbstractDocument.DefaultDocumentEvent(0, DefaultStyledDocument.this.getLength(), DocumentEvent.EventType.CHANGE);
                ((CompoundEdit)object).end();
                DefaultStyledDocument.this.fireChangedUpdate((DocumentEvent)object);
            }
            finally {
                DefaultStyledDocument.this.writeUnlock();
            }
        }
    }

    static class StyleContextChangeHandler
    extends AbstractChangeHandler {
        StyleContextChangeHandler(DefaultStyledDocument defaultStyledDocument) {
            super(defaultStyledDocument);
        }

        @Override
        void fireStateChanged(DefaultStyledDocument defaultStyledDocument, ChangeEvent changeEvent) {
            defaultStyledDocument.updateStylesListeningTo();
        }
    }

    static class StyleChangeHandler
    extends AbstractChangeHandler {
        StyleChangeHandler(DefaultStyledDocument defaultStyledDocument) {
            super(defaultStyledDocument);
        }

        @Override
        void fireStateChanged(DefaultStyledDocument defaultStyledDocument, ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof Style) {
                defaultStyledDocument.styleChanged((Style)object);
            } else {
                defaultStyledDocument.styleChanged(null);
            }
        }
    }

    static abstract class AbstractChangeHandler
    implements ChangeListener {
        private static final Map<Class, ReferenceQueue<DefaultStyledDocument>> queueMap = new HashMap<Class, ReferenceQueue<DefaultStyledDocument>>();
        private DocReference doc;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractChangeHandler(DefaultStyledDocument defaultStyledDocument) {
            ReferenceQueue<DefaultStyledDocument> referenceQueue;
            Class<? extends Object> clazz = this.getClass();
            Map<Class, ReferenceQueue<DefaultStyledDocument>> map = queueMap;
            synchronized (map) {
                referenceQueue = queueMap.get(clazz);
                if (referenceQueue == null) {
                    referenceQueue = new ReferenceQueue();
                    queueMap.put(clazz, referenceQueue);
                }
            }
            this.doc = new DocReference(defaultStyledDocument, referenceQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static List<ChangeListener> getStaleListeners(ChangeListener changeListener) {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            ReferenceQueue<DefaultStyledDocument> referenceQueue = queueMap.get(changeListener.getClass());
            if (referenceQueue != null) {
                ReferenceQueue<DefaultStyledDocument> referenceQueue2 = referenceQueue;
                synchronized (referenceQueue2) {
                    DocReference docReference;
                    while ((docReference = (DocReference)referenceQueue.poll()) != null) {
                        arrayList.add(docReference.getListener());
                    }
                }
            }
            return arrayList;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)this.doc.get();
            if (defaultStyledDocument != null) {
                this.fireStateChanged(defaultStyledDocument, changeEvent);
            }
        }

        abstract void fireStateChanged(DefaultStyledDocument var1, ChangeEvent var2);

        private class DocReference
        extends WeakReference<DefaultStyledDocument> {
            DocReference(DefaultStyledDocument defaultStyledDocument, ReferenceQueue<DefaultStyledDocument> referenceQueue) {
                super(defaultStyledDocument, referenceQueue);
            }

            ChangeListener getListener() {
                return AbstractChangeHandler.this;
            }
        }
    }

    static class StyleChangeUndoableEdit
    extends AbstractUndoableEdit {
        protected AbstractDocument.AbstractElement element;
        protected Style newStyle;
        protected AttributeSet oldStyle;

        public StyleChangeUndoableEdit(AbstractDocument.AbstractElement abstractElement, Style style) {
            this.element = abstractElement;
            this.newStyle = style;
            this.oldStyle = abstractElement.getResolveParent();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.element.setResolveParent(this.newStyle);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.element.setResolveParent(this.oldStyle);
        }
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet newAttributes;
        protected AttributeSet copy;
        protected boolean isReplacing;
        protected Element element;

        public AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl;
            this.copy = element.getAttributes().copyAttributes();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            if (this.isReplacing) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(this.newAttributes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
            mutableAttributeSet.addAttributes(this.copy);
        }
    }

    public class ElementBuffer
    implements Serializable {
        Element root;
        transient int pos;
        transient int offset;
        transient int length;
        transient int endOffset;
        transient Vector<ElemChanges> changes;
        transient Stack<ElemChanges> path;
        transient boolean insertOp;
        transient boolean recreateLeafs;
        transient ElemChanges[] insertPath;
        transient boolean createdFracture;
        transient Element fracturedParent;
        transient Element fracturedChild;
        transient boolean offsetLastIndex;
        transient boolean offsetLastIndexOnReplace;

        public ElementBuffer(Element element) {
            this.root = element;
            this.changes = new Vector();
            this.path = new Stack();
        }

        public Element getRootElement() {
            return this.root;
        }

        public void insert(int n, int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            if (n2 == 0) {
                return;
            }
            this.insertOp = true;
            this.beginEdits(n, n2);
            this.insertUpdate(elementSpecArray);
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        void create(int n, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            Object object;
            this.insertOp = true;
            this.beginEdits(this.offset, n);
            Object object2 = this.root;
            int n2 = object2.getElementIndex(0);
            while (!object2.isLeaf()) {
                object = object2.getElement(n2);
                this.push((Element)object2, n2);
                object2 = object;
                n2 = object2.getElementIndex(0);
            }
            object = this.path.peek();
            Element element = ((ElemChanges)object).parent.getElement(((ElemChanges)object).index);
            ((ElemChanges)object).added.addElement(DefaultStyledDocument.this.createLeafElement(((ElemChanges)object).parent, element.getAttributes(), DefaultStyledDocument.this.getLength(), element.getEndOffset()));
            ((ElemChanges)object).removed.addElement(element);
            while (this.path.size() > 1) {
                this.pop();
            }
            int n3 = elementSpecArray.length;
            AttributeSet attributeSet = null;
            if (n3 > 0 && elementSpecArray[0].getType() == 1) {
                attributeSet = elementSpecArray[0].getAttributes();
            }
            if (attributeSet == null) {
                attributeSet = SimpleAttributeSet.EMPTY;
            }
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.root.getAttributes();
            defaultDocumentEvent.addEdit(new AttributeUndoableEdit(this.root, attributeSet, true));
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
            mutableAttributeSet.addAttributes(attributeSet);
            for (int i = 1; i < n3; ++i) {
                this.insertElement(elementSpecArray[i]);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        public void remove(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n, n2);
            this.removeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        public void change(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n, n2);
            this.changeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            ElemChanges elemChanges;
            int n;
            int n2;
            Element element = this.root;
            int n3 = element.getElementIndex(this.offset);
            while (!element.isLeaf()) {
                Element element2 = element.getElement(n3);
                this.push(element, element2.isLeaf() ? n3 : n3 + 1);
                element = element2;
                n3 = element.getElementIndex(this.offset);
            }
            this.insertPath = new ElemChanges[this.path.size()];
            this.path.copyInto(this.insertPath);
            this.createdFracture = false;
            this.recreateLeafs = false;
            if (elementSpecArray[0].getType() == 3) {
                this.insertFirstContent(elementSpecArray);
                this.pos += elementSpecArray[0].getLength();
                n2 = 1;
            } else {
                this.fractureDeepestLeaf(elementSpecArray);
                n2 = 0;
            }
            int n4 = elementSpecArray.length;
            while (n2 < n4) {
                this.insertElement(elementSpecArray[n2]);
                ++n2;
            }
            if (!this.createdFracture) {
                this.fracture(-1);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            if (this.offsetLastIndex && this.offsetLastIndexOnReplace) {
                ++this.insertPath[this.insertPath.length - 1].index;
            }
            for (n = this.insertPath.length - 1; n >= 0; --n) {
                elemChanges = this.insertPath[n];
                if (elemChanges.parent == this.fracturedParent) {
                    elemChanges.added.addElement(this.fracturedChild);
                }
                if (elemChanges.added.size() <= 0 && elemChanges.removed.size() <= 0 || this.changes.contains(elemChanges)) continue;
                this.changes.addElement(elemChanges);
            }
            if (this.offset == 0 && this.fracturedParent != null && elementSpecArray[0].getType() == 2) {
                for (n = 0; n < elementSpecArray.length && elementSpecArray[n].getType() == 2; ++n) {
                }
                elemChanges = this.insertPath[this.insertPath.length - n - 1];
                elemChanges.removed.insertElementAt(elemChanges.parent.getElement(--elemChanges.index), 0);
            }
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.offset + this.length);
        }

        protected void changeUpdate() {
            boolean bl = this.split(this.offset, this.length);
            if (!bl) {
                while (this.path.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
        }

        boolean split(int n, int n2) {
            boolean bl = false;
            Element element = this.root;
            int n3 = element.getElementIndex(n);
            while (!element.isLeaf()) {
                this.push(element, n3);
                element = element.getElement(n3);
                n3 = element.getElementIndex(n);
            }
            ElemChanges elemChanges = this.path.peek();
            Element element2 = elemChanges.parent.getElement(elemChanges.index);
            if (element2.getStartOffset() < n && n < element2.getEndOffset()) {
                int n4;
                int n5 = n4 = elemChanges.index;
                if (n + n2 < elemChanges.parent.getEndOffset() && n2 != 0) {
                    n5 = elemChanges.parent.getElementIndex(n + n2);
                    if (n5 == n4) {
                        elemChanges.removed.addElement(element2);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), n);
                        elemChanges.added.addElement(element);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), n, n + n2);
                        elemChanges.added.addElement(element);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), n + n2, element2.getEndOffset());
                        elemChanges.added.addElement(element);
                        return true;
                    }
                    element2 = elemChanges.parent.getElement(n5);
                    if (n + n2 == element2.getStartOffset()) {
                        n5 = n4;
                    }
                    bl = true;
                }
                this.pos = n;
                element2 = elemChanges.parent.getElement(n4);
                elemChanges.removed.addElement(element2);
                element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                elemChanges.added.addElement(element);
                element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                elemChanges.added.addElement(element);
                for (int i = n4 + 1; i < n5; ++i) {
                    element2 = elemChanges.parent.getElement(i);
                    elemChanges.removed.addElement(element2);
                    elemChanges.added.addElement(element2);
                }
                if (n5 != n4) {
                    element2 = elemChanges.parent.getElement(n5);
                    this.pos = n + n2;
                    elemChanges.removed.addElement(element2);
                    element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                    elemChanges.added.addElement(element);
                    element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                    elemChanges.added.addElement(element);
                }
            }
            return bl;
        }

        void endEdits(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            int n = this.changes.size();
            for (int i = 0; i < n; ++i) {
                ElemChanges elemChanges = this.changes.elementAt(i);
                Object[] objectArray = new Element[elemChanges.removed.size()];
                elemChanges.removed.copyInto(objectArray);
                Object[] objectArray2 = new Element[elemChanges.added.size()];
                elemChanges.added.copyInto(objectArray2);
                int n2 = elemChanges.index;
                ((AbstractDocument.BranchElement)elemChanges.parent).replace(n2, objectArray.length, (Element[])objectArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(elemChanges.parent, n2, (Element[])objectArray, (Element[])objectArray2);
                defaultDocumentEvent.addEdit(elementEdit);
            }
            this.changes.removeAllElements();
            this.path.removeAllElements();
        }

        void beginEdits(int n, int n2) {
            this.offset = n;
            this.length = n2;
            this.endOffset = n + n2;
            this.pos = n;
            if (this.changes == null) {
                this.changes = new Vector();
            } else {
                this.changes.removeAllElements();
            }
            if (this.path == null) {
                this.path = new Stack();
            } else {
                this.path.removeAllElements();
            }
            this.fracturedParent = null;
            this.fracturedChild = null;
            this.offsetLastIndexOnReplace = false;
            this.offsetLastIndex = false;
        }

        void push(Element element, int n, boolean bl) {
            ElemChanges elemChanges = new ElemChanges(element, n, bl);
            this.path.push(elemChanges);
        }

        void push(Element element, int n) {
            this.push(element, n, false);
        }

        void pop() {
            Element element;
            ElemChanges elemChanges = this.path.peek();
            this.path.pop();
            if (elemChanges.added.size() > 0 || elemChanges.removed.size() > 0) {
                this.changes.addElement(elemChanges);
            } else if (!this.path.isEmpty() && (element = elemChanges.parent).getElementCount() == 0) {
                elemChanges = this.path.peek();
                elemChanges.added.removeElement(element);
            }
        }

        void advance(int n) {
            this.pos += n;
        }

        void insertElement(ElementSpec elementSpec) {
            ElemChanges elemChanges = this.path.peek();
            block0 : switch (elementSpec.getType()) {
                case 1: {
                    switch (elementSpec.getDirection()) {
                        case 5: {
                            Element element = elemChanges.parent.getElement(elemChanges.index);
                            if (element.isLeaf()) {
                                if (elemChanges.index + 1 < elemChanges.parent.getElementCount()) {
                                    element = elemChanges.parent.getElement(elemChanges.index + 1);
                                } else {
                                    throw new StateInvariantError("Join next to leaf");
                                }
                            }
                            this.push(element, 0, true);
                            break block0;
                        }
                        case 7: {
                            if (!this.createdFracture) {
                                this.fracture(this.path.size() - 1);
                            }
                            if (!elemChanges.isFracture) {
                                this.push(this.fracturedChild, 0, true);
                                break block0;
                            }
                            this.push(elemChanges.parent.getElement(0), 0, true);
                            break block0;
                        }
                    }
                    Element element = DefaultStyledDocument.this.createBranchElement(elemChanges.parent, elementSpec.getAttributes());
                    elemChanges.added.addElement(element);
                    this.push(element, 0);
                    break;
                }
                case 2: {
                    this.pop();
                    break;
                }
                case 3: {
                    int n = elementSpec.getLength();
                    if (elementSpec.getDirection() != 5) {
                        Element element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.pos, this.pos + n);
                        elemChanges.added.addElement(element);
                    } else if (!elemChanges.isFracture) {
                        Element element = null;
                        if (this.insertPath != null) {
                            for (int i = this.insertPath.length - 1; i >= 0; --i) {
                                if (this.insertPath[i] != elemChanges) continue;
                                if (i == this.insertPath.length - 1) break;
                                element = elemChanges.parent.getElement(elemChanges.index);
                                break;
                            }
                        }
                        if (element == null) {
                            element = elemChanges.parent.getElement(elemChanges.index + 1);
                        }
                        Element element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), this.pos, element.getEndOffset());
                        elemChanges.added.addElement(element2);
                        elemChanges.removed.addElement(element);
                    } else {
                        Element element = elemChanges.parent.getElement(0);
                        Element element3 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), this.pos, element.getEndOffset());
                        elemChanges.added.addElement(element3);
                        elemChanges.removed.addElement(element);
                    }
                    this.pos += n;
                }
            }
        }

        boolean removeElements(Element element, int n, int n2) {
            if (!element.isLeaf()) {
                int n3 = element.getElementIndex(n);
                int n4 = element.getElementIndex(n2);
                this.push(element, n3);
                ElemChanges elemChanges = this.path.peek();
                if (n3 == n4) {
                    Element element2 = element.getElement(n3);
                    if (n <= element2.getStartOffset() && n2 >= element2.getEndOffset()) {
                        elemChanges.removed.addElement(element2);
                    } else if (this.removeElements(element2, n, n2)) {
                        elemChanges.removed.addElement(element2);
                    }
                } else {
                    boolean bl;
                    Element element3 = element.getElement(n3);
                    Element element4 = element.getElement(n4);
                    boolean bl2 = bl = n2 < element.getEndOffset();
                    if (bl && this.canJoin(element3, element4)) {
                        for (int i = n3; i <= n4; ++i) {
                            elemChanges.removed.addElement(element.getElement(i));
                        }
                        Element element5 = this.join(element, element3, element4, n, n2);
                        elemChanges.added.addElement(element5);
                    } else {
                        int n5 = n3 + 1;
                        int n6 = n4 - 1;
                        if (element3.getStartOffset() == n || n3 == 0 && element3.getStartOffset() > n && element3.getEndOffset() <= n2) {
                            element3 = null;
                            n5 = n3;
                        }
                        if (!bl) {
                            element4 = null;
                            ++n6;
                        } else if (element4.getStartOffset() == n2) {
                            element4 = null;
                        }
                        if (n5 <= n6) {
                            elemChanges.index = n5;
                        }
                        for (int i = n5; i <= n6; ++i) {
                            elemChanges.removed.addElement(element.getElement(i));
                        }
                        if (element3 != null && this.removeElements(element3, n, n2)) {
                            elemChanges.removed.insertElementAt(element3, 0);
                            elemChanges.index = n3;
                        }
                        if (element4 != null && this.removeElements(element4, n, n2)) {
                            elemChanges.removed.addElement(element4);
                        }
                    }
                }
                this.pop();
                if (element.getElementCount() == elemChanges.removed.size() - elemChanges.added.size()) {
                    return true;
                }
            }
            return false;
        }

        boolean canJoin(Element element, Element element2) {
            boolean bl;
            if (element == null || element2 == null) {
                return false;
            }
            boolean bl2 = element.isLeaf();
            if (bl2 != (bl = element2.isLeaf())) {
                return false;
            }
            if (bl2) {
                return element.getAttributes().isEqual(element2.getAttributes());
            }
            String string = element.getName();
            String string2 = element2.getName();
            if (string != null) {
                return string.equals(string2);
            }
            if (string2 != null) {
                return string2.equals(string);
            }
            return true;
        }

        Element join(Element element, Element element2, Element element3, int n, int n2) {
            if (element2.isLeaf() && element3.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element3.getEndOffset());
            }
            if (!element2.isLeaf() && !element3.isLeaf()) {
                int n3;
                Element element4;
                Element element5 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
                int n4 = element2.getElementIndex(n);
                int n5 = element3.getElementIndex(n2);
                Element element6 = element2.getElement(n4);
                if (element6.getStartOffset() >= n) {
                    element6 = null;
                }
                if ((element4 = element3.getElement(n5)).getStartOffset() == n2) {
                    element4 = null;
                }
                Vector<Element> vector = new Vector<Element>();
                for (int i = 0; i < n4; ++i) {
                    vector.addElement(this.clone(element5, element2.getElement(i)));
                }
                if (this.canJoin(element6, element4)) {
                    Element element7 = this.join(element5, element6, element4, n, n2);
                    vector.addElement(element7);
                } else {
                    if (element6 != null) {
                        vector.addElement(this.cloneAsNecessary(element5, element6, n, n2));
                    }
                    if (element4 != null) {
                        vector.addElement(this.cloneAsNecessary(element5, element4, n, n2));
                    }
                }
                int n6 = element3.getElementCount();
                int n7 = n3 = element4 == null ? n5 : n5 + 1;
                while (n3 < n6) {
                    vector.addElement(this.clone(element5, element3.getElement(n3)));
                    ++n3;
                }
                Object[] objectArray = new Element[vector.size()];
                vector.copyInto(objectArray);
                ((AbstractDocument.BranchElement)element5).replace(0, 0, (Element[])objectArray);
                return element5;
            }
            throw new StateInvariantError("No support to join leaf element with non-leaf element");
        }

        public Element clone(Element element, Element element2) {
            if (element2.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            Element element3 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
            int n = element2.getElementCount();
            Element[] elementArray = new Element[n];
            for (int i = 0; i < n; ++i) {
                elementArray[i] = this.clone(element3, element2.getElement(i));
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        Element cloneAsNecessary(Element element, Element element2, int n, int n2) {
            if (element2.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            Element element3 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
            int n3 = element2.getElementCount();
            ArrayList<Element> arrayList = new ArrayList<Element>(n3);
            for (int i = 0; i < n3; ++i) {
                Element element4 = element2.getElement(i);
                if (element4.getStartOffset() >= n && element4.getEndOffset() <= n2) continue;
                arrayList.add(this.cloneAsNecessary(element3, element4, n, n2));
            }
            Element[] elementArray = new Element[arrayList.size()];
            elementArray = arrayList.toArray(elementArray);
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        void fracture(int n) {
            int n2 = this.insertPath.length;
            int n3 = -1;
            boolean bl = this.recreateLeafs;
            ElemChanges elemChanges = this.insertPath[n2 - 1];
            boolean bl2 = elemChanges.index + 1 < elemChanges.parent.getElementCount();
            int n4 = bl ? n2 : -1;
            int n5 = n2 - 1;
            this.createdFracture = true;
            for (int i = n2 - 2; i >= 0; --i) {
                ElemChanges elemChanges2 = this.insertPath[i];
                if (elemChanges2.added.size() > 0 || i == n) {
                    n3 = i;
                    if (!bl && bl2) {
                        bl = true;
                        if (n4 == -1) {
                            n4 = n5 + 1;
                        }
                    }
                }
                if (bl2 || elemChanges2.index >= elemChanges2.parent.getElementCount()) continue;
                bl2 = true;
                n5 = i;
            }
            if (bl) {
                if (n3 == -1) {
                    n3 = n2 - 1;
                }
                this.fractureFrom(this.insertPath, n3, n4);
            }
        }

        void fractureFrom(ElemChanges[] elemChangesArray, int n, int n2) {
            ElemChanges elemChanges = elemChangesArray[n];
            int n3 = elemChangesArray.length;
            Object object = n + 1 == n3 ? elemChanges.parent.getElement(elemChanges.index) : elemChanges.parent.getElement(elemChanges.index - 1);
            Element element = object.isLeaf() ? DefaultStyledDocument.this.createLeafElement(elemChanges.parent, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(elemChanges.parent, object.getAttributes());
            this.fracturedParent = elemChanges.parent;
            this.fracturedChild = element;
            Element element2 = element;
            while (++n < n2) {
                Element[] elementArray;
                int n4;
                boolean bl = n + 1 == n2;
                boolean bl2 = n + 1 == n3;
                elemChanges = elemChangesArray[n];
                object = bl ? (this.offsetLastIndex || !bl2 ? null : elemChanges.parent.getElement(elemChanges.index)) : elemChanges.parent.getElement(elemChanges.index - 1);
                element = object != null ? (object.isLeaf() ? DefaultStyledDocument.this.createLeafElement(element2, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(element2, object.getAttributes())) : null;
                int n5 = elemChanges.parent.getElementCount() - elemChanges.index;
                int n6 = 1;
                if (element == null) {
                    if (bl2) {
                        --n5;
                        n4 = elemChanges.index + 1;
                    } else {
                        n4 = elemChanges.index;
                    }
                    n6 = 0;
                    elementArray = new Element[n5];
                } else {
                    if (!bl) {
                        ++n5;
                        n4 = elemChanges.index;
                    } else {
                        n4 = elemChanges.index + 1;
                    }
                    elementArray = new Element[n5];
                    elementArray[0] = element;
                }
                for (int i = n6; i < n5; ++i) {
                    Element element3 = elemChanges.parent.getElement(n4++);
                    elementArray[i] = this.recreateFracturedElement(element2, element3);
                    elemChanges.removed.addElement(element3);
                }
                ((AbstractDocument.BranchElement)element2).replace(0, 0, elementArray);
                element2 = element;
            }
        }

        Element recreateFracturedElement(Element element, Element element2) {
            if (element2.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), Math.max(element2.getStartOffset(), this.endOffset), element2.getEndOffset());
            }
            Element element3 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
            int n = element2.getElementCount();
            Element[] elementArray = new Element[n];
            for (int i = 0; i < n; ++i) {
                elementArray[i] = this.recreateFracturedElement(element3, element2.getElement(i));
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        void fractureDeepestLeaf(ElementSpec[] elementSpecArray) {
            ElemChanges elemChanges = this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            if (this.offset != 0) {
                Element element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                elemChanges.added.addElement(element2);
            }
            elemChanges.removed.addElement(element);
            if (element.getEndOffset() != this.endOffset) {
                this.recreateLeafs = true;
            } else {
                this.offsetLastIndex = true;
            }
        }

        void insertFirstContent(ElementSpec[] elementSpecArray) {
            ElementSpec elementSpec = elementSpecArray[0];
            ElemChanges elemChanges = this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            int n = this.offset + elementSpec.getLength();
            boolean bl = elementSpecArray.length == 1;
            switch (elementSpec.getDirection()) {
                case 4: {
                    if (element.getEndOffset() != n && !bl) {
                        Element element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), n);
                        elemChanges.added.addElement(element2);
                        elemChanges.removed.addElement(element);
                        if (element.getEndOffset() != this.endOffset) {
                            this.recreateLeafs = true;
                            break;
                        }
                        this.offsetLastIndex = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                    this.offsetLastIndexOnReplace = true;
                    break;
                }
                case 5: {
                    if (this.offset == 0) break;
                    Element element3 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                    elemChanges.added.addElement(element3);
                    Element element4 = elemChanges.parent.getElement(elemChanges.index + 1);
                    element3 = bl ? DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element4.getAttributes(), this.offset, element4.getEndOffset()) : DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element4.getAttributes(), this.offset, n);
                    elemChanges.added.addElement(element3);
                    elemChanges.removed.addElement(element);
                    elemChanges.removed.addElement(element4);
                    break;
                }
                default: {
                    Element element5;
                    if (element.getStartOffset() != this.offset) {
                        element5 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                        elemChanges.added.addElement(element5);
                    }
                    elemChanges.removed.addElement(element);
                    element5 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.offset, n);
                    elemChanges.added.addElement(element5);
                    if (element.getEndOffset() != this.endOffset) {
                        this.recreateLeafs = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                }
            }
        }

        class ElemChanges {
            Element parent;
            int index;
            Vector<Element> added;
            Vector<Element> removed;
            boolean isFracture;

            ElemChanges(Element element, int n, boolean bl) {
                this.parent = element;
                this.index = n;
                this.isFracture = bl;
                this.added = new Vector();
                this.removed = new Vector();
            }

            public String toString() {
                return "added: " + this.added + "\nremoved: " + this.removed + "\n";
            }
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        private AttributeSet attr;
        private int len;
        private short type;
        private short direction;
        private int offs;
        private char[] data;

        public ElementSpec(AttributeSet attributeSet, short s) {
            this(attributeSet, s, null, 0, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s, int n) {
            this(attributeSet, s, null, 0, n);
        }

        public ElementSpec(AttributeSet attributeSet, short s, char[] cArray, int n, int n2) {
            this.attr = attributeSet;
            this.type = s;
            this.data = cArray;
            this.offs = n;
            this.len = n2;
            this.direction = (short)6;
        }

        public void setType(short s) {
            this.type = s;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short s) {
            this.direction = s;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        public char[] getArray() {
            return this.data;
        }

        public int getOffset() {
            return this.offs;
        }

        public int getLength() {
            return this.len;
        }

        public String toString() {
            String string = "??";
            String string2 = "??";
            switch (this.type) {
                case 1: {
                    string = "StartTag";
                    break;
                }
                case 3: {
                    string = "Content";
                    break;
                }
                case 2: {
                    string = "EndTag";
                }
            }
            switch (this.direction) {
                case 4: {
                    string2 = "JoinPrevious";
                    break;
                }
                case 5: {
                    string2 = "JoinNext";
                    break;
                }
                case 6: {
                    string2 = "Originate";
                    break;
                }
                case 7: {
                    string2 = "Fracture";
                }
            }
            return string + ":" + string2 + ":" + this.getLength();
        }
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public SectionElement() {
            super(null, null);
        }

        @Override
        public String getName() {
            return "section";
        }
    }
}

