/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.WeakReferenceNode;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.invoke.ConstantObjectHandle;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.ReferenceQueue;

class MethodHandleCache {
    private Class<?> clazz;
    private MethodHandle classCastHandle;
    private MethodHandle nullConstantObjectHandle;
    private WeakReferenceNode<DirectHandle> directHandlesHead;
    private ReferenceQueue<DirectHandle> referenceQueue = new ReferenceQueue();

    private MethodHandleCache(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static MethodHandleCache getCache(Class<?> clazz) {
        VMLangAccess vMLangAccess = MethodHandles.Lookup.getVMLangAccess();
        MethodHandleCache methodHandleCache = (MethodHandleCache)vMLangAccess.getMethodHandleCache(clazz);
        if (null == methodHandleCache) {
            methodHandleCache = new MethodHandleCache(clazz);
            methodHandleCache = (MethodHandleCache)vMLangAccess.setMethodHandleCache(clazz, methodHandleCache);
        }
        return methodHandleCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodHandle getClassCastHandle() throws IllegalAccessException, NoSuchMethodException {
        if (null == this.classCastHandle) {
            MethodHandleCache methodHandleCache = this;
            synchronized (methodHandleCache) {
                if (null == this.classCastHandle) {
                    this.classCastHandle = MethodHandles.Lookup.internalPrivilegedLookup.bind(this.clazz, "cast", MethodType.methodType(Object.class, Object.class));
                }
            }
        }
        return this.classCastHandle;
    }

    public MethodHandle getNullConstantObjectHandle() {
        if (null == this.nullConstantObjectHandle) {
            this.nullConstantObjectHandle = new ConstantObjectHandle(MethodType.methodType(this.clazz), (Object)null);
        }
        return this.nullConstantObjectHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectHandle(DirectHandle directHandle) {
        WeakReferenceNode<DirectHandle> weakReferenceNode = new WeakReferenceNode<DirectHandle>(directHandle, this.referenceQueue);
        MethodHandleCache methodHandleCache = this;
        synchronized (methodHandleCache) {
            weakReferenceNode.addBefore(this.directHandlesHead);
            this.directHandlesHead = weakReferenceNode;
        }
        this.processReferenceQueue();
    }

    private synchronized void processReferenceQueue() {
        WeakReferenceNode weakReferenceNode;
        while (null != (weakReferenceNode = (WeakReferenceNode)this.referenceQueue.poll())) {
            if (this.directHandlesHead == weakReferenceNode) {
                this.directHandlesHead = weakReferenceNode.next();
                continue;
            }
            weakReferenceNode.remove();
        }
    }
}

