/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.Comparator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleCache;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.WrongMethodTypeException;
import java.util.concurrent.ConcurrentHashMap;

abstract class ConvertHandle
extends MethodHandle {
    final MethodHandle next;
    boolean requiresBoxing = false;

    ConvertHandle(MethodHandle methodHandle, MethodType methodType, byte by, Object object) {
        super(methodType, by, object);
        if (methodHandle == null || methodType == null) {
            throw new IllegalArgumentException();
        }
        this.next = methodHandle;
    }

    ConvertHandle(ConvertHandle convertHandle, MethodType methodType) {
        super(convertHandle, methodType);
        this.next = convertHandle.next;
        this.requiresBoxing = convertHandle.requiresBoxing;
    }

    final void checkConversion(MethodType methodType, MethodType methodType2) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = methodType.ptypes();
        if (classArray2.length != (classArray = methodType2.ptypes()).length) {
            ConvertHandle.throwWrongMethodTypeException(methodType2, methodType, classArray2.length);
        }
        boolean bl = this.kind == 16;
        for (int i = 0; i < classArray2.length; ++i) {
            Class<?> clazz = classArray[i];
            Class<?> clazz2 = classArray2[i];
            if (clazz == clazz2) continue;
            boolean bl2 = clazz2.isPrimitive();
            boolean bl3 = clazz.isPrimitive();
            if (!bl2 && !bl3) continue;
            if (bl2 && bl3) {
                if (bl || FilterHelpers.checkIfWideningPrimitiveConversion(clazz, clazz2)) continue;
                ConvertHandle.throwWrongMethodTypeException(methodType2, methodType, i);
            }
            if (bl2) {
                Class<?> clazz3;
                if (bl || clazz2 == (clazz3 = MethodTypeHelper.unwrapPrimitive(clazz)) || clazz.isAssignableFrom(MethodTypeHelper.wrapPrimitive(clazz2)) || FilterHelpers.checkIfWideningPrimitiveConversion(clazz3, clazz2)) continue;
                ConvertHandle.throwWrongMethodTypeException(methodType2, methodType, i);
            }
            if (clazz2.isAssignableFrom(MethodTypeHelper.wrapPrimitive(clazz))) {
                this.requiresBoxing = true;
                continue;
            }
            ConvertHandle.throwWrongMethodTypeException(methodType2, methodType, i);
        }
    }

    static final void throwWrongMethodTypeException(MethodType methodType, MethodType methodType2, int n) throws WrongMethodTypeException {
        throw new WrongMethodTypeException(Msg.getString("K05cb", methodType.toString(), methodType2.toString(), Integer.toString(n)));
    }

    final void compareWithConvert(ConvertHandle convertHandle, Comparator comparator) {
        comparator.compareChildHandle(convertHandle.next, this.next);
    }

    static {
        FilterHelpers.load();
    }

    static final class FilterHelpers {
        static MethodHandles.Lookup privilegedLookup = MethodHandles.Lookup.internalPrivilegedLookup;
        static final ConcurrentHashMap<MethodType, MethodHandle> cachedReturnFilters = new ConcurrentHashMap();

        FilterHelpers() {
        }

        static MethodHandle getReturnFilter(Class<?> clazz, Class<?> clazz2, boolean bl) {
            assert (clazz != clazz2);
            try {
                if (clazz == Void.TYPE) {
                    Comparable<Boolean> comparable = null;
                    if (clazz2.isPrimitive()) {
                        comparable = clazz2 == Boolean.TYPE ? Boolean.valueOf(false) : (clazz2 == Character.TYPE ? (Comparable<Character>)Character.valueOf('\u0000') : (Comparable<Character>)Byte.valueOf((byte)0));
                    }
                    return MethodHandles.constant(clazz2, comparable);
                }
                MethodType methodType = MethodType.methodType(clazz2, clazz);
                if (clazz.isPrimitive()) {
                    if (clazz2.isPrimitive()) {
                        return FilterHelpers.getPrimitiveReturnFilter(methodType, bl);
                    }
                    return FilterHelpers.getBoxingReturnFilter(methodType);
                }
                if (!clazz2.isPrimitive()) {
                    return FilterHelpers.getCastFilter(methodType, bl);
                }
                if (clazz2 == Void.TYPE) {
                    MethodHandle methodHandle = privilegedLookup.findStatic(FilterHelpers.class, "popObject", MethodType.methodType(Void.TYPE, Object.class));
                    return methodHandle.cloneWithNewType(methodType);
                }
                return FilterHelpers.getUnboxingReturnFilter(methodType, bl);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error(noSuchMethodException);
            }
        }

        static boolean checkIfWideningPrimitiveConversion(Class<?> clazz, Class<?> clazz2) {
            if (!clazz.isPrimitive() || !clazz2.isPrimitive()) {
                return false;
            }
            if (clazz == Boolean.TYPE || clazz2 == Boolean.TYPE || clazz == Double.TYPE || clazz2 == Character.TYPE) {
                return false;
            }
            return FilterHelpers.primitiveIndex1(clazz2) > FilterHelpers.primitiveIndex1(clazz);
        }

        private static int primitiveIndex1(Class<?> clazz) {
            char c = clazz.getName().charAt(0);
            int n = (c ^ c >> 3) & 7;
            return 4534630 >> 3 * n & 7;
        }

        static MethodHandle getPrimitiveReturnFilter(MethodType methodType, boolean bl) throws IllegalAccessException, NoSuchMethodException {
            Class<?> clazz = methodType.parameterType(0);
            Class<?> clazz2 = methodType.returnType();
            if (!bl && methodType.returnType() != Void.TYPE && !FilterHelpers.checkIfWideningPrimitiveConversion(clazz, clazz2)) {
                throw new WrongMethodTypeException();
            }
            MethodHandle methodHandle = cachedReturnFilters.get(methodType);
            if (methodHandle == null) {
                String string = MethodTypeHelper.getBytecodeStringName(clazz2);
                String string2 = MethodTypeHelper.getBytecodeStringName(methodType.parameterType(0));
                methodHandle = privilegedLookup.findStatic(FilterHelpers.class, string2 + "2" + string, methodType);
                MethodHandle methodHandle2 = cachedReturnFilters.putIfAbsent(methodType, methodHandle);
                if (methodHandle2 != null) {
                    methodHandle = methodHandle2;
                }
            }
            return methodHandle;
        }

        static MethodHandle getBoxingReturnFilter(MethodType methodType) throws IllegalAccessException, NoSuchMethodException {
            MethodHandle methodHandle;
            Class<?> clazz = MethodTypeHelper.wrapPrimitive(methodType.parameterType(0));
            if (!methodType.returnType().isAssignableFrom(clazz)) {
                throw new WrongMethodTypeException();
            }
            MethodHandle methodHandle2 = cachedReturnFilters.get(methodType);
            if (methodHandle2 == null && (methodHandle = cachedReturnFilters.putIfAbsent(methodType, methodHandle2 = privilegedLookup.findStatic(clazz, "valueOf", MethodType.methodType(clazz, methodType.parameterType(0))))) != null) {
                methodHandle2 = methodHandle;
            }
            if (methodType.returnType() != clazz) {
                methodHandle2 = methodHandle2.cloneWithNewType(methodType);
            }
            return methodHandle2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static MethodHandle getUnboxingReturnFilter(MethodType methodType, boolean bl) throws IllegalAccessException, NoSuchMethodException {
            Class<?> clazz;
            boolean bl2;
            Class<?> clazz2 = methodType.parameterType(0);
            Class<?> clazz3 = methodType.returnType();
            if (clazz2.equals(Object.class)) {
                String string = bl ? "explicitObject2" : "object2";
                string = string + MethodTypeHelper.getBytecodeStringName(clazz3);
                return privilegedLookup.findStatic(FilterHelpers.class, string, MethodType.methodType(clazz3, Object.class));
            }
            if (clazz2.equals(Number.class)) {
                if (!bl) {
                    if (clazz3 == Boolean.TYPE && clazz3 == Character.TYPE) throw new WrongMethodTypeException();
                    return privilegedLookup.findStatic(FilterHelpers.class, "number2" + MethodTypeHelper.getBytecodeStringName(clazz3), MethodType.methodType(clazz3, Number.class));
                }
                if (clazz3 == Boolean.TYPE || clazz3 == Character.TYPE) {
                    String string = "explicitNumber2" + MethodTypeHelper.getBytecodeStringName(clazz3);
                    return privilegedLookup.findStatic(FilterHelpers.class, string, MethodType.methodType(clazz3, Number.class));
                }
                String string = MethodTypeHelper.getBytecodeStringName(clazz3) + "Value";
                return privilegedLookup.findVirtual(Number.class, string, MethodType.methodType(clazz3));
            }
            if (clazz2.equals(Boolean.class)) {
                MethodHandle methodHandle = privilegedLookup.findVirtual(Boolean.class, "booleanValue", MethodType.methodType(Boolean.TYPE));
                if (clazz3.equals(Boolean.TYPE)) {
                    return methodHandle;
                }
                if (!bl) throw new WrongMethodTypeException();
                return MethodHandles.filterReturnValue(methodHandle, FilterHelpers.getPrimitiveReturnFilter(MethodType.methodType(clazz3, Boolean.TYPE), bl));
            }
            if (clazz2.equals(Character.class)) {
                MethodHandle methodHandle = privilegedLookup.findVirtual(Character.class, "charValue", MethodType.methodType(Character.TYPE));
                if (!clazz3.equals(Character.TYPE)) return MethodHandles.filterReturnValue(methodHandle, FilterHelpers.getPrimitiveReturnFilter(MethodType.methodType(clazz3, Character.TYPE), bl));
                return methodHandle;
            }
            if (!MethodTypeHelper.WRAPPER_SET.contains(clazz2) || !(bl2 = clazz3.equals(clazz = MethodTypeHelper.unwrapPrimitive(clazz2))) && !bl && !FilterHelpers.checkIfWideningPrimitiveConversion(clazz, clazz3)) throw new WrongMethodTypeException();
            if (!bl || bl2 || clazz3 != Character.TYPE && clazz3 != Boolean.TYPE) return privilegedLookup.findVirtual(clazz2, clazz3.getName() + "Value", MethodType.methodType(clazz3));
            MethodHandle methodHandle = privilegedLookup.findVirtual(clazz2, clazz.getName() + "Value", MethodType.methodType(clazz));
            MethodHandle methodHandle2 = FilterHelpers.getPrimitiveReturnFilter(MethodType.methodType(clazz3, clazz), bl);
            return MethodHandles.filterReturnValue(methodHandle, methodHandle2);
        }

        static MethodHandle getCastFilter(MethodType methodType, boolean bl) throws IllegalAccessException, NoSuchMethodException {
            Class<?> clazz = methodType.returnType();
            if (bl && clazz.isInterface()) {
                MethodType methodType2 = MethodType.methodType(Object.class, Object.class);
                return privilegedLookup.findStatic(FilterHelpers.class, "explicitCastInterfaceUnchecked", methodType2);
            }
            MethodHandleCache methodHandleCache = MethodHandleCache.getCache(clazz);
            return methodHandleCache.getClassCastHandle();
        }

        public static Object explicitCastInterfaceUnchecked(Object object) {
            return object;
        }

        public static boolean explicitObject2Z(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Character) {
                return ((byte)((Character)object).charValue() & 1) == 1;
            }
            return (((Number)object).byteValue() & 1) == 1;
        }

        public static byte explicitObject2B(Object object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof Boolean) {
                return (byte)((Boolean)object != false ? 1 : 0);
            }
            if (object instanceof Character) {
                return (byte)((Character)object).charValue();
            }
            return ((Number)object).byteValue();
        }

        public static short explicitObject2S(Object object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof Boolean) {
                return (short)((Boolean)object != false ? 1 : 0);
            }
            if (object instanceof Character) {
                return (short)((Character)object).charValue();
            }
            return ((Number)object).shortValue();
        }

        public static char explicitObject2C(Object object) {
            if (object == null) {
                return '\u0000';
            }
            if (object instanceof Boolean) {
                return (char)((Boolean)object != false ? 1 : 0);
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            return (char)((Number)object).intValue();
        }

        public static int explicitObject2I(Object object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            return ((Number)object).intValue();
        }

        public static long explicitObject2J(Object object) {
            if (object == null) {
                return 0L;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1L : 0L;
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            return ((Number)object).longValue();
        }

        public static float explicitObject2F(Object object) {
            if (object == null) {
                return 0.0f;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0f : 0.0f;
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            return ((Number)object).floatValue();
        }

        public static double explicitObject2D(Object object) {
            if (object == null) {
                return 0.0;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            return ((Number)object).doubleValue();
        }

        public static boolean explicitNumber2Z(Number number) {
            if (number == null) {
                return false;
            }
            return (number.byteValue() & 1) == 1;
        }

        public static char explicitNumber2C(Number number) {
            if (number == null) {
                return '\u0000';
            }
            return (char)number.intValue();
        }

        private static final ClassCastException newClassCastException() {
            return new ClassCastException();
        }

        public static boolean object2Z(Object object) {
            return (Boolean)object;
        }

        public static char object2C(Object object) {
            return ((Character)object).charValue();
        }

        public static byte object2B(Object object) {
            return FilterHelpers.number2B((Number)object);
        }

        public static short object2S(Object object) {
            return FilterHelpers.number2S((Number)object);
        }

        public static int object2I(Object object) {
            object.getClass();
            if (object instanceof Number) {
                return FilterHelpers.number2I((Number)object);
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static float object2F(Object object) {
            object.getClass();
            if (object instanceof Number) {
                return FilterHelpers.number2F((Number)object);
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static double object2D(Object object) {
            object.getClass();
            if (object instanceof Number) {
                return FilterHelpers.number2D((Number)object);
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static long object2J(Object object) {
            object.getClass();
            if (object instanceof Number) {
                return FilterHelpers.number2J((Number)object);
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static byte number2B(Number number) {
            return (Byte)number;
        }

        public static short number2S(Number number) {
            if (number instanceof Short || number instanceof Byte) {
                return number.shortValue();
            }
            number.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static int number2I(Number number) {
            if (number instanceof Integer || number instanceof Byte || number instanceof Short) {
                return number.intValue();
            }
            number.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static long number2J(Number number) {
            if (number instanceof Long || number instanceof Integer || number instanceof Byte || number instanceof Short) {
                return number.longValue();
            }
            number.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static float number2F(Number number) {
            if (number instanceof Float || number instanceof Integer || number instanceof Long || number instanceof Byte || number instanceof Short) {
                return number.floatValue();
            }
            number.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static double number2D(Number number) {
            if (number instanceof Double || number instanceof Float || number instanceof Integer || number instanceof Long || number instanceof Byte || number instanceof Short) {
                return number.doubleValue();
            }
            number.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static void popObject(Object object) {
        }

        public static double V2D() {
            return 0.0;
        }

        public static long V2J() {
            return 0L;
        }

        public static float V2F() {
            return 0.0f;
        }

        public static int V2I() {
            return 0;
        }

        public static char V2C() {
            return '\u0000';
        }

        public static short V2S() {
            return 0;
        }

        public static byte V2B() {
            return 0;
        }

        public static boolean V2Z() {
            return false;
        }

        public static Object V2object() {
            return null;
        }

        public static double Z2D(boolean bl) {
            return bl ? 1.0 : 0.0;
        }

        public static long Z2J(boolean bl) {
            return bl ? 1L : 0L;
        }

        public static float Z2F(boolean bl) {
            return bl ? 1.0f : 0.0f;
        }

        public static int Z2I(boolean bl) {
            return bl ? 1 : 0;
        }

        public static char Z2C(boolean bl) {
            return (char)(bl ? 1 : 0);
        }

        public static short Z2S(boolean bl) {
            return (short)(bl ? 1 : 0);
        }

        public static byte Z2B(boolean bl) {
            return (byte)(bl ? 1 : 0);
        }

        public static void Z2V(boolean bl) {
        }

        public static Object Z2object(boolean bl) {
            return bl;
        }

        public static double B2D(byte by) {
            return by;
        }

        public static long B2J(byte by) {
            return by;
        }

        public static float B2F(byte by) {
            return by;
        }

        public static int B2I(byte by) {
            return by;
        }

        public static char B2C(byte by) {
            return (char)by;
        }

        public static short B2S(byte by) {
            return by;
        }

        public static boolean B2Z(byte by) {
            return (byte)(by & 1) == 1;
        }

        public static void B2V(byte by) {
        }

        public static Object B2object(byte by) {
            return by;
        }

        public static double S2D(short s) {
            return s;
        }

        public static long S2J(short s) {
            return s;
        }

        public static float S2F(short s) {
            return s;
        }

        public static int S2I(short s) {
            return s;
        }

        public static char S2C(short s) {
            return (char)s;
        }

        public static byte S2B(short s) {
            return (byte)s;
        }

        public static boolean S2Z(short s) {
            return ((byte)s & 1) == 1;
        }

        public static void S2V(short s) {
        }

        public static Object S2object(short s) {
            return s;
        }

        public static double C2D(char c) {
            return c;
        }

        public static long C2J(char c) {
            return c;
        }

        public static float C2F(char c) {
            return c;
        }

        public static int C2I(char c) {
            return c;
        }

        public static short C2S(char c) {
            return (short)c;
        }

        public static byte C2B(char c) {
            return (byte)c;
        }

        public static boolean C2Z(char c) {
            return ((byte)c & 1) == 1;
        }

        public static void C2V(char c) {
        }

        public static Object C2object(char c) {
            return Character.valueOf(c);
        }

        public static boolean I2Z(int n) {
            return ((byte)n & 1) == 1;
        }

        public static byte I2B(int n) {
            return (byte)n;
        }

        public static short I2S(int n) {
            return (short)n;
        }

        public static char I2C(int n) {
            return (char)n;
        }

        public static float I2F(int n) {
            return n;
        }

        public static long I2J(int n) {
            return n;
        }

        public static double I2D(int n) {
            return n;
        }

        public static void I2V(int n) {
        }

        public static Object I2object(int n) {
            return n;
        }

        public static float J2F(long l) {
            return l;
        }

        public static double J2D(long l) {
            return l;
        }

        public static int J2I(long l) {
            return (int)l;
        }

        public static char J2C(long l) {
            return (char)l;
        }

        public static short J2S(long l) {
            return (short)l;
        }

        public static byte J2B(long l) {
            return (byte)l;
        }

        public static boolean J2Z(long l) {
            return ((byte)l & 1) == 1;
        }

        public static void J2V(long l) {
        }

        public static Object J2object(long l) {
            return l;
        }

        public static long F2J(float f) {
            return (long)f;
        }

        public static double F2D(float f) {
            return f;
        }

        public static int F2I(float f) {
            return (int)f;
        }

        public static char F2C(float f) {
            return (char)f;
        }

        public static short F2S(float f) {
            return (short)f;
        }

        public static byte F2B(float f) {
            return (byte)f;
        }

        public static boolean F2Z(float f) {
            return ((byte)f & 1) == 1;
        }

        public static void F2V(float f) {
        }

        public static Object F2object(float f) {
            return Float.valueOf(f);
        }

        public static float D2F(double d) {
            return (float)d;
        }

        public static long D2J(double d) {
            return (long)d;
        }

        public static int D2I(double d) {
            return (int)d;
        }

        public static char D2C(double d) {
            return (char)d;
        }

        public static short D2S(double d) {
            return (short)d;
        }

        public static byte D2B(double d) {
            return (byte)d;
        }

        public static boolean D2Z(double d) {
            return ((byte)d & 1) == 1;
        }

        public static void D2V(double d) {
        }

        public static Object D2object(double d) {
            return d;
        }

        static void load() {
        }
    }
}

