/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import sun.misc.Unsafe;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    static final boolean enableCompression;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER;
    private static final char[] emptyValue;
    private static final char[][] compressedAsciiTable;
    private static final char[][] decompressedAsciiTable;
    private static final JITHelpers helpers;
    private static StringCompressionFlag compressionFlag;
    private static final int uncompressedBit = Integer.MIN_VALUE;
    private static String[] stringArray;
    private static final int stringArraySize = 10;
    static boolean enableSharingInSubstringWhenOffsetIsZero;
    private final char[] value;
    private final int count;
    private int hashCode;
    private static char[] startCombiningAbove;
    private static char[] endCombiningAbove;
    private static char[] upperValues;
    private static char[] upperIndexs;
    private static final char[] regexMetaChars;
    private static final ObjectStreamField[] serialPersistentFields;

    private void checkLastChar(char c) {
        if (c == '\\') {
            throw new IllegalArgumentException(Msg.getString("K0801"));
        }
        if (c == '$') {
            throw new IllegalArgumentException(Msg.getString("K0802"));
        }
    }

    static void initCompressionFlag() {
        if (compressionFlag == null) {
            compressionFlag = new StringCompressionFlag();
        }
    }

    static boolean canEncodeAsLatin1(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (cArray[i] <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    static void compress(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putByteInArrayByIndex(byArray2, n2 + i, (byte)helpers.getCharFromArrayByIndex(byArray, n + i));
        }
    }

    static void compress(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putByteInArrayByIndex(byArray, n2 + i, (byte)helpers.getCharFromArrayByIndex(cArray, n + i));
        }
    }

    static void compress(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putByteInArrayByIndex(cArray, n2 + i, (byte)helpers.getCharFromArrayByIndex(byArray, n + i));
        }
    }

    static void compress(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putByteInArrayByIndex(cArray2, n2 + i, (byte)helpers.getCharFromArrayByIndex(cArray, n + i));
        }
    }

    static void decompress(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putCharInArrayByIndex(byArray2, n2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(byArray, n + i)));
        }
    }

    static void decompress(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putCharInArrayByIndex(byArray, n2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, n + i)));
        }
    }

    static void decompress(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putCharInArrayByIndex(cArray, n2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(byArray, n + i)));
        }
    }

    static void decompress(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putCharInArrayByIndex(cArray2, n2 + i, helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, n + i)));
        }
    }

    static void compressedArrayCopy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2 && n < n2) {
            for (int i = n3 - 1; i >= 0; --i) {
                helpers.putByteInArrayByIndex(byArray2, n2 + i, helpers.getByteFromArrayByIndex(byArray, n + i));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                helpers.putByteInArrayByIndex(byArray2, n2 + i, helpers.getByteFromArrayByIndex(byArray, n + i));
            }
        }
    }

    static void compressedArrayCopy(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putByteInArrayByIndex(cArray, n2 + i, helpers.getByteFromArrayByIndex(byArray, n + i));
        }
    }

    static void compressedArrayCopy(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            helpers.putByteInArrayByIndex(byArray, n2 + i, helpers.getByteFromArrayByIndex(cArray, n + i));
        }
    }

    static void compressedArrayCopy(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        if (cArray == cArray2 && n < n2) {
            for (int i = n3 - 1; i >= 0; --i) {
                helpers.putByteInArrayByIndex(cArray2, n2 + i, helpers.getByteFromArrayByIndex(cArray, n + i));
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                helpers.putByteInArrayByIndex(cArray2, n2 + i, helpers.getByteFromArrayByIndex(cArray, n + i));
            }
        }
    }

    static void decompressedArrayCopy(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        System.arraycopy((Object)cArray, n, (Object)cArray2, n2, n3);
    }

    boolean isCompressed() {
        return enableCompression && (null == compressionFlag || this.count >= 0);
    }

    public String() {
        this.value = emptyValue;
        this.count = 0;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    @Deprecated
    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2) {
        byArray.getClass();
        if (n >= 0 && 0 <= n2 && n2 <= byArray.length - n) {
            char[] cArray = StringCoding.decode(byArray, n, n2);
            if (enableCompression) {
                if (String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                    this.value = new char[cArray.length + 1 >>> 1];
                    this.count = cArray.length;
                    String.compress(cArray, 0, this.value, 0, cArray.length);
                } else {
                    this.value = cArray;
                    this.count = cArray.length | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = cArray;
                this.count = cArray.length;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    @Deprecated
    public String(byte[] byArray, int n, int n2, int n3) {
        byArray.getClass();
        if (n2 >= 0 && 0 <= n3 && n3 <= byArray.length - n2) {
            if (enableCompression) {
                if (n == 0) {
                    this.value = new char[n3 + 1 >>> 1];
                    this.count = n3;
                    String.compressedArrayCopy(byArray, n2, this.value, 0, n3);
                } else {
                    this.value = new char[n3];
                    this.count = n3 | Integer.MIN_VALUE;
                    n <<= 8;
                    for (int i = 0; i < n3; ++i) {
                        this.value[i] = (char)(n + (byArray[n2++] & 0xFF));
                    }
                    String.initCompressionFlag();
                }
            } else {
                this.value = new char[n3];
                this.count = n3;
                n <<= 8;
                for (int i = 0; i < n3; ++i) {
                    this.value[i] = (char)(n + (byArray[n2++] & 0xFF));
                }
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        string.getClass();
        byArray.getClass();
        if (n >= 0 && 0 <= n2 && n2 <= byArray.length - n) {
            char[] cArray = StringCoding.decode(string, byArray, n, n2);
            if (enableCompression) {
                if (String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                    this.value = new char[cArray.length + 1 >>> 1];
                    this.count = cArray.length;
                    String.compress(cArray, 0, this.value, 0, cArray.length);
                } else {
                    this.value = cArray;
                    this.count = cArray.length | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = cArray;
                this.count = cArray.length;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    private String(String string, char c) {
        int n;
        int n2;
        if (string == null) {
            string = "null";
        }
        if ((n2 = (n = string.lengthInternal()) + 1) < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (enableCompression) {
            if ((null == compressionFlag || string.count >= 0) && c <= '\u00ff') {
                this.value = new char[n2 + 1 >>> 1];
                this.count = n2;
                String.compressedArrayCopy(string.value, 0, this.value, 0, n);
                helpers.putByteInArrayByIndex(this.value, n, (byte)c);
            } else {
                this.value = new char[n2];
                this.count = n2 | Integer.MIN_VALUE;
                System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n);
                this.value[n] = c;
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[n2];
            this.count = n2;
            System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n);
            this.value[n] = c;
        }
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    String(char[] cArray, boolean bl) {
        if (enableCompression) {
            if (String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                this.value = new char[cArray.length + 1 >>> 1];
                this.count = cArray.length;
                String.compress(cArray, 0, this.value, 0, cArray.length);
            } else {
                this.value = new char[cArray.length];
                this.count = cArray.length | Integer.MIN_VALUE;
                System.arraycopy((Object)cArray, 0, (Object)this.value, 0, cArray.length);
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[cArray.length];
            this.count = cArray.length;
            System.arraycopy((Object)cArray, 0, (Object)this.value, 0, cArray.length);
        }
    }

    public String(char[] cArray, int n, int n2) {
        if (n >= 0 && 0 <= n2 && n2 <= cArray.length - n) {
            if (enableCompression) {
                if (String.canEncodeAsLatin1(cArray, n, n2)) {
                    this.value = new char[n2 + 1 >>> 1];
                    this.count = n2;
                    String.compress(cArray, n, this.value, 0, n2);
                } else {
                    this.value = new char[n2];
                    this.count = n2 | Integer.MIN_VALUE;
                    System.arraycopy((Object)cArray, n, (Object)this.value, 0, n2);
                    String.initCompressionFlag();
                }
            } else {
                this.value = new char[n2];
                this.count = n2;
                System.arraycopy((Object)cArray, n, (Object)this.value, 0, n2);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    String(char[] cArray, int n, int n2, boolean bl) {
        if (enableCompression) {
            if (n2 == 0) {
                this.value = emptyValue;
                this.count = 0;
            } else if (n2 == 1) {
                if (bl) {
                    char c = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, n));
                    this.value = compressedAsciiTable[c];
                    this.count = 1;
                    this.hashCode = c;
                } else {
                    char c = cArray[n];
                    this.value = c <= '\u00ff' ? decompressedAsciiTable[c] : new char[]{c};
                    this.count = -2147483647;
                    this.hashCode = c;
                    String.initCompressionFlag();
                }
            } else if (bl) {
                if (n == 0) {
                    this.value = cArray;
                    this.count = n2;
                } else {
                    this.value = new char[n2 + 1 >>> 1];
                    this.count = n2;
                    String.compressedArrayCopy(cArray, n, this.value, 0, n2);
                }
            } else {
                if (n == 0) {
                    this.value = cArray;
                    this.count = n2 | Integer.MIN_VALUE;
                } else {
                    this.value = new char[n2];
                    this.count = n2 | Integer.MIN_VALUE;
                    System.arraycopy((Object)cArray, n, (Object)this.value, 0, n2);
                }
                String.initCompressionFlag();
            }
        } else if (n2 == 0) {
            this.value = emptyValue;
            this.count = 0;
        } else if (n2 == 1 && cArray[n] <= '\u00ff') {
            int n3 = cArray[n];
            this.value = decompressedAsciiTable[n3];
            this.count = 1;
            this.hashCode = n3;
        } else if (n == 0) {
            this.value = cArray;
            this.count = n2;
        } else {
            this.value = new char[n2];
            this.count = n2;
            System.arraycopy((Object)cArray, n, (Object)this.value, 0, n2);
        }
    }

    String(char[] cArray, int n, int n2, boolean bl, boolean bl2) {
        if (enableCompression) {
            if (n2 == 0) {
                this.value = emptyValue;
                this.count = 0;
            } else if (n2 == 1) {
                if (bl) {
                    char c = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, n));
                    this.value = compressedAsciiTable[c];
                    this.count = 1;
                    this.hashCode = c;
                } else {
                    char c = cArray[n];
                    this.value = c <= '\u00ff' ? decompressedAsciiTable[c] : new char[]{c};
                    this.count = -2147483647;
                    this.hashCode = c;
                    String.initCompressionFlag();
                }
            } else if (bl) {
                if (n == 0 && bl2) {
                    this.value = cArray;
                    this.count = n2;
                } else {
                    this.value = new char[n2 + 1 >>> 1];
                    this.count = n2;
                    String.compressedArrayCopy(cArray, n, this.value, 0, n2);
                }
            } else {
                if (n == 0 && bl2) {
                    this.value = cArray;
                    this.count = n2 | Integer.MIN_VALUE;
                } else {
                    this.value = new char[n2];
                    this.count = n2 | Integer.MIN_VALUE;
                    System.arraycopy((Object)cArray, n, (Object)this.value, 0, n2);
                }
                String.initCompressionFlag();
            }
        } else if (n2 == 0) {
            this.value = emptyValue;
            this.count = 0;
        } else if (n2 == 1 && cArray[n] <= '\u00ff') {
            int n3 = cArray[n];
            this.value = decompressedAsciiTable[n3];
            this.count = 1;
            this.hashCode = n3;
        } else if (n == 0 && bl2) {
            this.value = cArray;
            this.count = n2;
        } else {
            this.value = new char[n2];
            this.count = n2;
            System.arraycopy((Object)cArray, n, (Object)this.value, 0, n2);
        }
    }

    public String(String string) {
        this.value = string.value;
        this.count = string.count;
        this.hashCode = string.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            char[] cArray = stringBuffer.shareValue();
            if (enableCompression) {
                if (stringBuffer.isCompressed()) {
                    this.value = cArray;
                    this.count = stringBuffer.length();
                } else {
                    this.value = cArray;
                    this.count = stringBuffer.length() | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = cArray;
                this.count = stringBuffer.length();
            }
        }
    }

    private String(String string, String string2) {
        int n;
        int n2;
        int n3;
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        if ((n3 = (n2 = string.lengthInternal()) + (n = string2.lengthInternal())) < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (enableCompression) {
            if (null == compressionFlag || (string.count | string2.count) >= 0) {
                this.value = new char[n3 + 1 >>> 1];
                this.count = n3;
                String.compressedArrayCopy(string.value, 0, this.value, 0, n2);
                String.compressedArrayCopy(string2.value, 0, this.value, n2, n);
            } else {
                this.value = new char[n3];
                this.count = n3 | Integer.MIN_VALUE;
                if (string.count >= 0) {
                    String.decompress(string.value, 0, this.value, 0, n2);
                } else {
                    System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n2);
                }
                if (string2.count >= 0) {
                    String.decompress(string2.value, 0, this.value, n2, n);
                } else {
                    System.arraycopy((Object)string2.value, 0, (Object)this.value, n2, n);
                }
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[n3];
            this.count = n3;
            System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n2);
            System.arraycopy((Object)string2.value, 0, (Object)this.value, n2, n);
        }
    }

    private String(String string, String string2, String string3) {
        int n;
        int n2;
        int n3;
        long l;
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        if (string3 == null) {
            string3 = "null";
        }
        if ((l = (long)(n3 = string.lengthInternal()) + (long)(n2 = string2.lengthInternal()) + (long)(n = string3.lengthInternal())) > Integer.MAX_VALUE) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        int n4 = (int)l;
        if (enableCompression) {
            if (null == compressionFlag || (string.count | string2.count | string3.count) >= 0) {
                this.value = new char[n4 + 1 >>> 1];
                this.count = n4;
                String.compressedArrayCopy(string.value, 0, this.value, 0, n3);
                String.compressedArrayCopy(string2.value, 0, this.value, n3, n2);
                String.compressedArrayCopy(string3.value, 0, this.value, n3 + n2, n);
            } else {
                this.value = new char[n4];
                this.count = n4 | Integer.MIN_VALUE;
                if (string.count >= 0) {
                    String.decompress(string.value, 0, this.value, 0, n3);
                } else {
                    System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n3);
                }
                if (string2.count >= 0) {
                    String.decompress(string2.value, 0, this.value, n3, n2);
                } else {
                    System.arraycopy((Object)string2.value, 0, (Object)this.value, n3, n2);
                }
                if (string3.count >= 0) {
                    String.decompress(string3.value, 0, this.value, n3 + n2, n);
                } else {
                    System.arraycopy((Object)string3.value, 0, (Object)this.value, n3 + n2, n);
                }
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[n4];
            this.count = n4;
            System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n3);
            System.arraycopy((Object)string2.value, 0, (Object)this.value, n3, n2);
            System.arraycopy((Object)string3.value, 0, (Object)this.value, n3 + n2, n);
        }
    }

    private String(String string, int n) {
        int n2;
        if (string == null) {
            string = "null";
        }
        int n3 = string.lengthInternal();
        int n4 = 1;
        int n5 = n;
        while ((n5 /= 10) != 0) {
            ++n4;
        }
        if (n >= 0) {
            n2 = -n;
        } else {
            ++n4;
            n2 = n;
        }
        int n6 = n3 + n4;
        if (n6 < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (enableCompression) {
            if (null == compressionFlag || string.count >= 0) {
                this.value = new char[n6 + 1 >>> 1];
                this.count = n6;
                int n7 = n6 - 1;
                do {
                    int n8 = n2 / 10;
                    int n9 = n2 - n8 * 10;
                    n2 = n8;
                    helpers.putByteInArrayByIndex(this.value, n7--, (byte)(48 - n9));
                } while (n2 != 0);
                if (n < 0) {
                    helpers.putByteInArrayByIndex(this.value, n7, (byte)45);
                }
                String.compressedArrayCopy(string.value, 0, this.value, 0, n3);
            } else {
                this.value = new char[n6];
                this.count = n6 | Integer.MIN_VALUE;
                int n10 = n6 - 1;
                do {
                    int n11 = n2 / 10;
                    int n12 = n2 - n11 * 10;
                    n2 = n11;
                    this.value[n10--] = (char)(48 - n12);
                } while (n2 != 0);
                if (n < 0) {
                    this.value[n10] = 45;
                }
                System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n3);
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[n6];
            this.count = n6;
            int n13 = n6 - 1;
            do {
                int n14 = n2 / 10;
                int n15 = n2 - n14 * 10;
                n2 = n14;
                this.value[n13--] = (char)(48 - n15);
            } while (n2 != 0);
            if (n < 0) {
                this.value[n13] = 45;
            }
            System.arraycopy((Object)string.value, 0, (Object)this.value, 0, n3);
        }
    }

    private String(int n, String string, int n2, String string2, String string3) {
        int n3;
        int n4;
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        if (string3 == null) {
            string3 = "null";
        }
        int n5 = string.lengthInternal();
        int n6 = string2.lengthInternal();
        int n7 = string3.lengthInternal();
        int n8 = 1;
        int n9 = 1;
        int n10 = n;
        while ((n10 /= 10) != 0) {
            ++n8;
        }
        if (n >= 0) {
            n4 = -n;
        } else {
            ++n8;
            n4 = n;
        }
        int n11 = n2;
        while ((n11 /= 10) != 0) {
            ++n9;
        }
        if (n2 >= 0) {
            n3 = -n2;
        } else {
            ++n9;
            n3 = n2;
        }
        long l = (long)n5 + (long)n8 + (long)n9 + (long)n6 + (long)n7;
        if (l > Integer.MAX_VALUE) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        int n12 = (int)l;
        if (enableCompression) {
            if (null == compressionFlag || (string.count | string2.count | string3.count) >= 0) {
                int n13;
                int n14;
                this.value = new char[n12 + 1 >>> 1];
                this.count = n12;
                int n15 = n12;
                String.compressedArrayCopy(string3.value, 0, this.value, n15 -= n7, n7);
                String.compressedArrayCopy(string2.value, 0, this.value, n15 -= n6, n6);
                int n16 = n15 - 1;
                do {
                    n14 = n3 / 10;
                    n13 = n3 - n14 * 10;
                    n3 = n14;
                    helpers.putByteInArrayByIndex(this.value, n16--, (byte)(48 - n13));
                } while (n3 != 0);
                if (n2 < 0) {
                    helpers.putByteInArrayByIndex(this.value, n16--, (byte)45);
                }
                n15 = n16 + 1 - n5;
                String.compressedArrayCopy(string.value, 0, this.value, n15, n5);
                n14 = n15 - 1;
                do {
                    n13 = n4 / 10;
                    int n17 = n4 - n13 * 10;
                    n4 = n13;
                    helpers.putByteInArrayByIndex(this.value, n14--, (byte)(48 - n17));
                } while (n4 != 0);
                if (n < 0) {
                    helpers.putByteInArrayByIndex(this.value, n14--, (byte)45);
                }
            } else {
                int n18;
                int n19;
                this.value = new char[n12];
                this.count = n12 | Integer.MIN_VALUE;
                int n20 = n12;
                n20 -= n7;
                if (string3.count >= 0) {
                    String.decompress(string3.value, 0, this.value, n20, n7);
                } else {
                    System.arraycopy((Object)string3.value, 0, (Object)this.value, n20, n7);
                }
                n20 -= n6;
                if (string2.count >= 0) {
                    String.decompress(string2.value, 0, this.value, n20, n6);
                } else {
                    System.arraycopy((Object)string2.value, 0, (Object)this.value, n20, n6);
                }
                int n21 = n20 - 1;
                do {
                    n19 = n3 / 10;
                    n18 = n3 - n19 * 10;
                    n3 = n19;
                    this.value[n21--] = (char)(48 - n18);
                } while (n3 != 0);
                if (n2 < 0) {
                    this.value[n21--] = 45;
                }
                n20 = n21 + 1 - n5;
                if (string.count >= 0) {
                    String.decompress(string.value, 0, this.value, n20, n5);
                } else {
                    System.arraycopy((Object)string.value, 0, (Object)this.value, n20, n5);
                }
                n19 = n20 - 1;
                do {
                    n18 = n4 / 10;
                    int n22 = n4 - n18 * 10;
                    n4 = n18;
                    this.value[n19--] = (char)(48 - n22);
                } while (n4 != 0);
                if (n < 0) {
                    this.value[n19--] = 45;
                }
                String.initCompressionFlag();
            }
        } else {
            int n23;
            int n24;
            this.value = new char[n12];
            this.count = n12;
            int n25 = n12;
            System.arraycopy((Object)string3.value, 0, (Object)this.value, n25 -= n7, n7);
            System.arraycopy((Object)string2.value, 0, (Object)this.value, n25 -= n6, n6);
            int n26 = n25 - 1;
            do {
                n24 = n3 / 10;
                n23 = n3 - n24 * 10;
                n3 = n24;
                this.value[n26--] = (char)(48 - n23);
            } while (n3 != 0);
            if (n2 < 0) {
                this.value[n26--] = 45;
            }
            n25 = n26 + 1 - n5;
            System.arraycopy((Object)string.value, 0, (Object)this.value, n25, n5);
            n24 = n25 - 1;
            do {
                n23 = n4 / 10;
                int n27 = n4 - n23 * 10;
                n4 = n23;
                this.value[n24--] = (char)(48 - n27);
            } while (n4 != 0);
            if (n < 0) {
                this.value[n24--] = 45;
            }
        }
    }

    private static String cachedConstantString(String string, String string2, int n) {
        if (n < 10) {
            if (stringArray[n] == null) {
                String.stringArray[n] = new String(string, string2);
            }
        } else {
            return new String(string, string2);
        }
        return stringArray[n];
    }

    @Override
    public char charAt(int n) {
        if (0 <= n && n < this.lengthInternal()) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n));
            }
            return this.value[n];
        }
        throw new StringIndexOutOfBoundsException();
    }

    char charAtInternal(int n) {
        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
            return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n));
        }
        return this.value[n];
    }

    char charAtInternal(int n, char[] cArray) {
        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
            return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, n));
        }
        return cArray[n];
    }

    @Override
    public int compareTo(String string) {
        int n;
        String string2 = this;
        String string3 = string;
        int n2 = string2.lengthInternal();
        int n3 = n2 < (n = string3.lengthInternal()) ? n2 : n;
        int n4 = 0;
        int n5 = 0;
        char[] cArray = string2.value;
        char[] cArray2 = string3.value;
        if (enableCompression && (null == compressionFlag || (string2.count | string3.count) >= 0)) {
            while (n4 < n3) {
                int n6;
                if ((n6 = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, n4++)) - helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray2, n5++))) == 0) continue;
                return n6;
            }
        } else {
            while (n4 < n3) {
                int n7;
                if ((n7 = string2.charAtInternal(n4++, cArray) - string3.charAtInternal(n5++, cArray2)) == 0) continue;
                return n7;
            }
        }
        return n2 - n;
    }

    private static char compareValue(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 32);
        }
        return Character.toLowerCase(Character.toUpperCase(c));
    }

    private static char compareValue(byte by) {
        if (65 <= by && by <= 90) {
            return (char)(helpers.byteToCharUnsigned(by) + 32);
        }
        return Character.toLowerCase(Character.toUpperCase(helpers.byteToCharUnsigned(by)));
    }

    private static boolean charValuesEqualIgnoreCase(char c, char c2) {
        boolean bl = false;
        char c3 = (char)String.toUpperCase(c);
        char c4 = (char)String.toUpperCase(c2);
        if ((c <= '\u00ff' || c2 <= '\u00ff') && c3 == c4 || String.toLowerCase(c3) == String.toLowerCase(c4)) {
            bl = true;
        }
        return bl;
    }

    public int compareToIgnoreCase(String string) {
        int n;
        String string2 = this;
        String string3 = string;
        int n2 = string2.lengthInternal();
        int n3 = n2 < (n = string3.lengthInternal()) ? n2 : n;
        int n4 = 0;
        int n5 = 0;
        char[] cArray = string2.value;
        char[] cArray2 = string3.value;
        if (enableCompression && (null == compressionFlag || (string2.count | string3.count) >= 0)) {
            while (n4 < n3) {
                int n6;
                byte by;
                byte by2;
                if ((by2 = helpers.getByteFromArrayByIndex(cArray, n4++)) == (by = helpers.getByteFromArrayByIndex(cArray2, n5++)) || (n6 = String.compareValue(by2) - String.compareValue(by)) == 0) continue;
                return n6;
            }
        } else {
            while (n4 < n3) {
                int n7;
                char c;
                char c2;
                if ((c2 = string2.charAtInternal(n4++, cArray)) == (c = string3.charAtInternal(n5++, cArray2)) || (n7 = String.compareValue(c2) - String.compareValue(c)) == 0) continue;
                return n7;
            }
        }
        return n2 - n;
    }

    public String concat(String string) {
        String string2 = this;
        String string3 = string;
        int n = string2.lengthInternal();
        int n2 = string3.lengthInternal();
        if (n2 == 0) {
            return string2;
        }
        int n3 = n + n2;
        if (n3 < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (enableCompression && (null == compressionFlag || (string2.count | string3.count) >= 0)) {
            char[] cArray = new char[n3 + 1 >>> 1];
            String.compressedArrayCopy(string2.value, 0, cArray, 0, n);
            String.compressedArrayCopy(string3.value, 0, cArray, n, n2);
            return new String(cArray, 0, n3, true);
        }
        char[] cArray = new char[n3];
        if (enableCompression && string2.count >= 0) {
            String.decompress(string2.value, 0, cArray, 0, n);
        } else {
            System.arraycopy((Object)string2.value, 0, (Object)cArray, 0, n);
        }
        if (enableCompression && string3.count >= 0) {
            String.decompress(string3.value, 0, cArray, n, n2);
        } else {
            System.arraycopy((Object)string3.value, 0, (Object)cArray, n, n2);
        }
        return new String(cArray, 0, n3, false);
    }

    public static String copyValueOf(char[] cArray) {
        return new String(cArray, 0, cArray.length);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(this.lengthInternal() - string.lengthInternal(), string, 0, string.lengthInternal());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof String) {
            int n;
            String string = this;
            String string2 = (String)object;
            int n2 = string.lengthInternal();
            if (n2 != (n = string2.lengthInternal())) {
                return false;
            }
            char[] cArray = string.value;
            char[] cArray2 = string2.value;
            if (cArray == cArray2) {
                return true;
            }
            int n3 = string.hashCode;
            int n4 = string2.hashCode;
            if (n3 != 0 && n4 != 0 && n3 != n4) {
                return false;
            }
            if (!String.regionMatchesInternal(string, string2, cArray, cArray2, 0, 0, n2)) {
                return false;
            }
            if (VM.J9_JIT_STRING_DEDUP_POLICY != 0) {
                String.deduplicateStrings(string, cArray, string2, cArray2);
            }
            return true;
        }
        return false;
    }

    private static final void deduplicateStrings(String string, Object object, String string2, Object object2) {
        if (!enableCompression || null == compressionFlag || (string.count ^ string2.count) >= 0) {
            long l = UnsafeHelpers.valueFieldOffset;
            if (VM.J9_JIT_STRING_DEDUP_POLICY == 1) {
                if (helpers.acmplt(object, object2)) {
                    helpers.putObjectInObject(string2, l, object);
                } else {
                    helpers.putObjectInObject(string, l, object2);
                }
            } else if (helpers.acmplt(object2, object)) {
                helpers.putObjectInObject(string2, l, object);
            } else {
                helpers.putObjectInObject(string, l, object2);
            }
        }
    }

    public boolean equalsIgnoreCase(String string) {
        int n;
        String string2 = this;
        String string3 = string;
        if (string2 == string3) {
            return true;
        }
        if (string3 == null) {
            return false;
        }
        int n2 = string2.lengthInternal();
        if (n2 != (n = string3.lengthInternal())) {
            return false;
        }
        if (0 == n2) {
            return true;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        char[] cArray = string2.value;
        char[] cArray2 = string3.value;
        if (enableCompression && (null == compressionFlag || (string2.count | string3.count) >= 0)) {
            byte by;
            byte by2 = helpers.getByteFromArrayByIndex(cArray, n2 - 1);
            if (by2 != (by = helpers.getByteFromArrayByIndex(cArray2, n2 - 1)) && String.toUpperCase(helpers.byteToCharUnsigned(by2)) != String.toUpperCase(helpers.byteToCharUnsigned(by))) {
                return false;
            }
            while (n3 < n5 - 1) {
                byte by3;
                byte by4;
                if ((by4 = helpers.getByteFromArrayByIndex(cArray, n3++)) == (by3 = helpers.getByteFromArrayByIndex(cArray2, n4++)) || String.toUpperCase(helpers.byteToCharUnsigned(by4)) == String.toUpperCase(helpers.byteToCharUnsigned(by3))) continue;
                return false;
            }
        } else {
            char c;
            char c2 = string2.charAtInternal(n2 - 1, cArray);
            if (c2 != (c = string3.charAtInternal(n2 - 1, cArray2)) && !String.charValuesEqualIgnoreCase(c2, c)) {
                return false;
            }
            while (n3 < n5 - 1) {
                char c3;
                char c4;
                if ((c4 = string2.charAtInternal(n3++, cArray)) == (c3 = string3.charAtInternal(n4++, cArray2)) || String.charValuesEqualIgnoreCase(c4, c3)) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] getBytes() {
        char[] cArray;
        int n = this.lengthInternal();
        if (enableCompression && this.count >= 0) {
            cArray = new char[n];
            String.decompress(this.value, 0, cArray, 0, n);
        } else {
            cArray = this.value;
        }
        return StringCoding.encode(cArray, 0, n);
    }

    @Deprecated
    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (0 <= n && n <= n2 && n2 <= this.lengthInternal() && 0 <= n3 && n2 - n <= byArray.length - n3) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                String.compressedArrayCopy(this.value, n, byArray, n3, n2 - n);
            } else {
                String.compress(this.value, n, byArray, n3, n2 - n);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    void getBytes(int n, int n2, char[] cArray, int n3) {
        if (0 <= n && n <= n2 && n2 <= this.lengthInternal()) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                String.compressedArrayCopy(this.value, n, cArray, n3, n2 - n);
            } else {
                String.compress(this.value, n, cArray, n3, n2 - n);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        char[] cArray;
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.lengthInternal();
        if (enableCompression && this.count >= 0) {
            cArray = new char[n];
            String.decompress(this.value, 0, cArray, 0, n);
        } else {
            cArray = this.value;
        }
        return StringCoding.encode(string, cArray, 0, n);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (0 <= n && n <= n2 && n2 <= this.lengthInternal() && 0 <= n3 && n2 - n <= cArray.length - n3) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                String.decompress(this.value, n, cArray, n3, n2 - n);
            } else {
                System.arraycopy((Object)this.value, n, (Object)cArray, n3, n2 - n);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    void getCharsNoBoundChecks(int n, int n2, char[] cArray, int n3) {
        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
            String.decompress(this.value, n, cArray, n3, n2 - n);
        } else {
            String.decompressedArrayCopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public int hashCode() {
        int n;
        if (this.hashCode == 0 && (n = this.lengthInternal()) > 0) {
            this.hashCode = enableCompression && (compressionFlag == null || this.count >= 0) ? String.hashCodeImplCompressed(this.value, 0, n) : String.hashCodeImplDecompressed(this.value, 0, n);
        }
        return this.hashCode;
    }

    private static int hashCodeImplCompressed(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = (n3 << 5) - n3 + helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray, i));
        }
        return n3;
    }

    private static int hashCodeImplDecompressed(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = (n3 << 5) - n3 + cArray[i];
        }
        return n3;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOf(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n2 >= n3) return -1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= 0 && n <= 65535) {
            char[] cArray = this.value;
            if (!enableCompression || null != compressionFlag && this.count < 0) return helpers.intrinsicIndexOfUTF16(cArray, (char)n, n2, n3);
            if (n > 255) return -1;
            return helpers.intrinsicIndexOfLatin1(cArray, (byte)n, n2, n3);
        }
        if (n > 0x10FFFF) return -1;
        for (int i = n2; i < n3; ++i) {
            int n4 = this.codePointAt(i);
            if (n4 == n) {
                return i;
            }
            if (n4 < 65536) continue;
            ++i;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        if (string.length() == 1) {
            return this.indexOf(string.charAtInternal(0), n);
        }
        if (n < 0) {
            n = 0;
        }
        String string2 = this;
        String string3 = string;
        int n2 = string2.lengthInternal();
        int n3 = string3.lengthInternal();
        if (n3 > 0) {
            if (n > n2 - n3) {
                return -1;
            }
            char[] cArray = string2.value;
            char[] cArray2 = string3.value;
            if (enableCompression) {
                if (null == compressionFlag || (string2.count | string3.count) >= 0) {
                    return helpers.intrinsicIndexOfStringLatin1(cArray, n2, cArray2, n3, n);
                }
                if ((string2.count & string3.count) < 0) {
                    return helpers.intrinsicIndexOfStringUTF16(cArray, n2, cArray2, n3, n);
                }
                char c = string3.charAtInternal(0, cArray2);
                while (true) {
                    int n4;
                    if ((n4 = this.indexOf(c, n)) == -1 || n3 + n4 > n2) {
                        return -1;
                    }
                    int n5 = n4;
                    int n6 = 0;
                    while (++n6 < n3 && string2.charAtInternal(++n5, cArray) == string3.charAtInternal(n6, cArray2)) {
                    }
                    if (n6 == n3) {
                        return n4;
                    }
                    n = n4 + 1;
                }
            }
            return helpers.intrinsicIndexOfStringUTF16(cArray, n2, cArray2, n3, n);
        }
        return n < n2 ? n : n2;
    }

    public native String intern();

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.lengthInternal() - 1);
    }

    public int lastIndexOf(int n, int n2) {
        block6: {
            block7: {
                char[] cArray;
                block8: {
                    if (n2 < 0) break block6;
                    int n3 = this.lengthInternal();
                    if (n2 >= n3) {
                        n2 = n3 - 1;
                    }
                    if (n < 0 || n > 65535) break block7;
                    cArray = this.value;
                    if (!enableCompression || null != compressionFlag && this.count < 0) break block8;
                    if (n > 255) break block6;
                    byte by = (byte)n;
                    for (int i = n2; i >= 0; --i) {
                        if (helpers.getByteFromArrayByIndex(cArray, i) != by) continue;
                        return i;
                    }
                    break block6;
                }
                for (int i = n2; i >= 0; --i) {
                    if (cArray[i] != n) continue;
                    return i;
                }
                break block6;
            }
            if (n <= 0x10FFFF) {
                for (int i = n2; i >= 0; --i) {
                    int n4 = this.codePointAt(i);
                    if (n4 == n) {
                        return i;
                    }
                    if (n4 < 65536) continue;
                    --i;
                }
            }
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.lengthInternal());
    }

    public int lastIndexOf(String string, int n) {
        String string2 = this;
        String string3 = string;
        int n2 = string2.lengthInternal();
        int n3 = string3.lengthInternal();
        if (n3 <= n2 && n >= 0) {
            if (n3 > 0) {
                if (n > n2 - n3) {
                    n = n2 - n3;
                }
                char[] cArray = string2.value;
                char[] cArray2 = string3.value;
                if (enableCompression && (null == compressionFlag || (string2.count | string3.count) >= 0)) {
                    char c = helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(cArray2, 0));
                    while (true) {
                        int n4;
                        if ((n4 = this.lastIndexOf(c, n)) == -1) {
                            return -1;
                        }
                        int n5 = n4;
                        int n6 = 0;
                        while (++n6 < n3 && helpers.getByteFromArrayByIndex(cArray, ++n5) == helpers.getByteFromArrayByIndex(cArray2, n6)) {
                        }
                        if (n6 == n3) {
                            return n4;
                        }
                        n = n4 - 1;
                    }
                }
                char c = string3.charAtInternal(0, cArray2);
                while (true) {
                    int n7;
                    if ((n7 = this.lastIndexOf(c, n)) == -1) {
                        return -1;
                    }
                    int n8 = n7;
                    int n9 = 0;
                    while (++n9 < n3 && string2.charAtInternal(++n8, cArray) == string3.charAtInternal(n9, cArray2)) {
                    }
                    if (n9 == n3) {
                        return n7;
                    }
                    n = n7 - 1;
                }
            }
            return n < n2 ? n : n2;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.lengthInternal();
    }

    int lengthInternal() {
        if (enableCompression) {
            if (compressionFlag == null || this.count >= 0) {
                return this.count;
            }
            return this.count & Integer.MAX_VALUE;
        }
        return this.count;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        string.getClass();
        String string2 = this;
        String string3 = string;
        int n4 = string2.lengthInternal();
        int n5 = string3.lengthInternal();
        if (n2 < 0 || n5 - n2 < n3) {
            return false;
        }
        if (n < 0 || n4 - n < n3) {
            return false;
        }
        return String.regionMatchesInternal(string2, string3, string2.value, string3.value, n, n2, n3);
    }

    private static boolean regionMatchesInternal(String string, String string2, char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (n3 <= 0) {
            return true;
        }
        int n4 = n3 - 1;
        if (enableCompression && (compressionFlag == null || (string.count | string2.count) >= 0)) {
            if (helpers.getByteFromArrayByIndex(cArray, n + n4) != helpers.getByteFromArrayByIndex(cArray2, n2 + n4)) {
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                if (helpers.getByteFromArrayByIndex(cArray, n + i) == helpers.getByteFromArrayByIndex(cArray2, n2 + i)) continue;
                return false;
            }
        } else {
            if (string.charAtInternal(n + n4, cArray) != string2.charAtInternal(n2 + n4, cArray2)) {
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                if (string.charAtInternal(n + i, cArray) == string2.charAtInternal(n2 + i, cArray2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (!bl) {
            return this.regionMatches(n, string, n2, n3);
        }
        string.getClass();
        String string2 = this;
        String string3 = string;
        int n4 = string2.lengthInternal();
        int n5 = string3.lengthInternal();
        if (n < 0 || n3 > n4 - n) {
            return false;
        }
        if (n2 < 0 || n3 > n5 - n2) {
            return false;
        }
        if (n3 <= 0) {
            return true;
        }
        int n6 = n;
        int n7 = n2;
        int n8 = n + n3;
        char[] cArray = string2.value;
        char[] cArray2 = string3.value;
        if (enableCompression && (null == compressionFlag || (string2.count | string3.count) >= 0)) {
            while (n6 < n8) {
                byte by;
                byte by2;
                if ((by2 = helpers.getByteFromArrayByIndex(cArray, n6++)) == (by = helpers.getByteFromArrayByIndex(cArray2, n7++)) || String.charValuesEqualIgnoreCase(helpers.byteToCharUnsigned(by2), helpers.byteToCharUnsigned(by))) continue;
                return false;
            }
        } else {
            while (n6 < n8) {
                char c;
                char c2;
                if ((c2 = string2.charAtInternal(n6++, cArray)) == (c = string3.charAtInternal(n7++, cArray2)) || String.charValuesEqualIgnoreCase(c2, c)) continue;
                return false;
            }
        }
        return true;
    }

    public String replace(char c, char c2) {
        int n = this.indexOf(c, 0);
        if (n == -1) {
            return this;
        }
        int n2 = this.lengthInternal();
        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
            if (c2 <= '\u00ff') {
                char[] cArray = new char[n2 + 1 >>> 1];
                String.compressedArrayCopy(this.value, 0, cArray, 0, n2);
                do {
                    helpers.putByteInArrayByIndex(cArray, n++, (byte)c2);
                } while ((n = this.indexOf(c, n)) != -1);
                return new String(cArray, 0, n2, true);
            }
            char[] cArray = new char[n2];
            String.decompress(this.value, 0, cArray, 0, n2);
            do {
                cArray[n++] = c2;
            } while ((n = this.indexOf(c, n)) != -1);
            return new String(cArray, 0, n2, false);
        }
        char[] cArray = new char[n2];
        System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n2);
        do {
            cArray[n++] = c2;
        } while ((n = this.indexOf(c, n)) != -1);
        return new String(cArray, 0, n2, false);
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean startsWith(String string, int n) {
        if (string.length() == 1) {
            if (n < 0 || n >= this.length()) {
                return false;
            }
            return this.charAtInternal(n) == string.charAtInternal(0);
        }
        return this.regionMatches(n, string, 0, string.lengthInternal());
    }

    public String substring(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.lengthInternal();
        if (0 <= n && n <= n2) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                return new String(this.value, n, n2 - n, true, enableSharingInSubstringWhenOffsetIsZero);
            }
            return new String(this.value, n, n2 - n, false, enableSharingInSubstringWhenOffsetIsZero);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public String substring(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n == 0 && n2 == n3) {
            return this;
        }
        if (0 <= n && n <= n2 && n2 <= n3) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                return new String(this.value, n, n2 - n, true, enableSharingInSubstringWhenOffsetIsZero);
            }
            return new String(this.value, n, n2 - n, false, enableSharingInSubstringWhenOffsetIsZero);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public char[] toCharArray() {
        int n = this.lengthInternal();
        char[] cArray = new char[n];
        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
            String.decompress(this.value, 0, cArray, 0, n);
        } else {
            System.arraycopy((Object)this.value, 0, (Object)cArray, 0, n);
        }
        return cArray;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    private static int toLowerCase(int n) {
        if (n < 128) {
            if (65 <= n && n <= 90) {
                return n + 32;
            }
            return n;
        }
        return Character.toLowerCase(n);
    }

    private static int toUpperCase(int n) {
        if (n < 128) {
            if (97 <= n && n <= 122) {
                return n - 32;
            }
            return n;
        }
        return Character.toUpperCase(n);
    }

    public String toLowerCase(Locale locale) {
        String string = locale.getLanguage();
        int n = this.lengthInternal();
        if (n == 0) {
            return this;
        }
        if (helpers.supportsIntrinsicCaseConversion() && string == "en") {
            char[] cArray;
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                char[] cArray2 = new char[n + 1 >>> 1];
                if (helpers.toLowerIntrinsicLatin1(this.value, cArray2, n)) {
                    return new String(cArray2, 0, n, true);
                }
            } else if (n <= 0x3FFFFFFF && helpers.toLowerIntrinsicUTF16(this.value, cArray = new char[n], n * 2)) {
                return new String(cArray, 0, n, false);
            }
        }
        return this.toLowerCaseCore(string);
    }

    private String toLowerCaseCore(String string) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = null;
        int n = this.lengthInternal();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.charAtInternal(i);
            if (n3 >= 55296 && n3 <= 56319) {
                n3 = this.codePointAt(i);
            }
            if (n3 != (n2 = String.toLowerCase(n3))) {
                int n4;
                if (stringBuilder == null) {
                    bl = string == "tr" || string == "az";
                    bl2 = string == "lt";
                    stringBuilder = new StringBuilder(n);
                    if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                        stringBuilder.append(this.value, 0, i, true);
                    } else {
                        stringBuilder.append(this.value, 0, i, false);
                    }
                }
                if (n3 == 931) {
                    stringBuilder.append(this.convertSigma(i));
                    continue;
                }
                if (!bl && 304 == n3) {
                    stringBuilder.append("i\u0307");
                    continue;
                }
                if (bl) {
                    if (n3 == 73) {
                        n4 = i + 1 < n && this.charAtInternal(i + 1) == '\u0307' ? 1 : 0;
                        stringBuilder.append(n4 != 0 ? (char)'i' : '\u0131');
                        if (n4 != 0) {
                            ++i;
                        }
                    } else {
                        stringBuilder.appendCodePoint(n2);
                    }
                } else if (bl2) {
                    if (n3 == 73 || n3 == 74 || n3 == 302) {
                        stringBuilder.append(n3 == 302 ? (char)'\u012f' : (char)(n3 + 32));
                        if (i + 1 < n && String.isCombiningAbove(n4 = this.codePointAt(i + 1))) {
                            stringBuilder.append('\u0307');
                        }
                    } else if (n3 == 204) {
                        stringBuilder.append("i\u0307\u0300");
                    } else if (n3 == 205) {
                        stringBuilder.append("i\u0307\u0301");
                    } else if (n3 == 296) {
                        stringBuilder.append("i\u0307\u0303");
                    } else {
                        stringBuilder.appendCodePoint(n2);
                    }
                } else {
                    stringBuilder.appendCodePoint(n2);
                }
            } else if (stringBuilder != null) {
                stringBuilder.appendCodePoint(n3);
            }
            if (n3 < 65536) continue;
            ++i;
        }
        if (stringBuilder == null) {
            return this;
        }
        return stringBuilder.toString();
    }

    private static int binarySearchRange(char[] cArray, char c) {
        char c2 = '\u0000';
        int n = 0;
        int n2 = -1;
        int n3 = cArray.length - 1;
        while (n <= n3) {
            n2 = n + n3 >>> 1;
            c2 = cArray[n2];
            if (c > c2) {
                n = n2 + 1;
                continue;
            }
            if (c == c2) {
                return n2;
            }
            n3 = n2 - 1;
        }
        return n2 - (c < c2 ? 1 : 0);
    }

    private static boolean isCombiningAbove(int n) {
        if (n < 65535) {
            int n2 = String.binarySearchRange(startCombiningAbove, (char)n);
            return n2 >= 0 && endCombiningAbove[n2] >= n;
        }
        return n == 68111 || n == 68152 || n >= 69888 && n <= 69890 || n >= 119173 && n <= 119177 || n >= 119210 && n <= 119213 || n >= 119362 && n <= 119364;
    }

    private static boolean isWordPart(int n) {
        return n == 837 || String.isWordStart(n);
    }

    private static boolean isWordStart(int n) {
        int n2 = Character.getType(n);
        return n2 >= 1 && n2 <= 3 || n >= 688 && n <= 696 || n >= 704 && n <= 705 || n >= 736 && n <= 740 || n == 890 || n >= 8544 && n <= 8575 || n >= 7468 && n <= 7521;
    }

    private char convertSigma(int n) {
        if (n == 0 || !String.isWordStart(this.codePointBefore(n)) || n + 1 < this.lengthInternal() && String.isWordPart(this.codePointAt(n + 1))) {
            return '\u03c3';
        }
        return '\u03c2';
    }

    @Override
    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    private static int upperIndex(int n) {
        int n2 = -1;
        if (n <= 1415) {
            if (n == 223) {
                n2 = 0;
            } else if (n <= 329) {
                if (n == 329) {
                    n2 = 1;
                }
            } else if (n <= 496) {
                if (n == 496) {
                    n2 = 2;
                }
            } else if (n <= 912) {
                if (n == 912) {
                    n2 = 3;
                }
            } else if (n <= 944) {
                if (n == 944) {
                    n2 = 4;
                }
            } else if (n <= 1415 && n == 1415) {
                n2 = 5;
            }
        } else if (n >= 7830) {
            if (n <= 7834) {
                n2 = 6 + n - 7830;
            } else if (n >= 8016 && n <= 8188) {
                n2 = upperIndexs[n - 8016];
                if (n2 == 0) {
                    n2 = -1;
                }
            } else if (n >= 64256) {
                if (n <= 64262) {
                    n2 = 90 + n - 64256;
                } else if (n >= 64275 && n <= 64279) {
                    n2 = 97 + n - 64275;
                }
            }
        }
        return n2;
    }

    public String toUpperCase(Locale locale) {
        String string = locale.getLanguage();
        int n = this.lengthInternal();
        if (n == 0) {
            return this;
        }
        if (helpers.supportsIntrinsicCaseConversion() && string == "en") {
            char[] cArray;
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                char[] cArray2 = new char[n + 1 >>> 1];
                if (helpers.toUpperIntrinsicLatin1(this.value, cArray2, n)) {
                    return new String(cArray2, 0, n, true);
                }
            } else if (n <= 0x3FFFFFFF && helpers.toUpperIntrinsicUTF16(this.value, cArray = new char[n], n * 2)) {
                return new String(cArray, 0, n, false);
            }
        }
        return this.toUpperCaseCore(string);
    }

    private String toUpperCaseCore(String string) {
        boolean bl = string == "tr" || string == "az";
        boolean bl2 = string == "lt";
        StringBuilder stringBuilder = null;
        int n = this.lengthInternal();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.charAtInternal(i);
            if (n3 >= 55296 && n3 <= 56319) {
                n3 = this.codePointAt(i);
            }
            int n4 = -1;
            if (n3 >= 223 && n3 <= 64279) {
                n4 = String.upperIndex(n3);
            }
            if (n4 == -1) {
                int n5 = n2 = !bl || n3 != 105 ? String.toUpperCase(n3) : 304;
                if (n3 != n2) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(n);
                        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                            stringBuilder.append(this.value, 0, i, true);
                        } else {
                            stringBuilder.append(this.value, 0, i, false);
                        }
                    }
                    stringBuilder.appendCodePoint(n2);
                } else if (stringBuilder != null) {
                    stringBuilder.appendCodePoint(n3);
                }
                if (bl2 && n3 <= 7883 && i + 1 < n && this.charAt(i + 1) == '\u0307' && "ij\u012f\u0268\u0456\u0458\u1e2d\u1ecb".indexOf(n3, 0) != -1) {
                    ++i;
                }
            } else {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n + n / 6 + 2).append(this, 0, i);
                }
                n2 = n4 * 3;
                stringBuilder.append(upperValues[n2]);
                stringBuilder.append(upperValues[n2 + 1]);
                char c = upperValues[n2 + 2];
                if (c != '\u0000') {
                    stringBuilder.append(c);
                }
            }
            if (n3 < 65536) continue;
            ++i;
        }
        if (stringBuilder == null) {
            return this;
        }
        return stringBuilder.toString();
    }

    public String trim() {
        int n;
        int n2;
        int n3 = n2 = this.lengthInternal() - 1;
        if (enableCompression && (null == compressionFlag || this.count >= 0)) {
            for (n = 0; n <= n3 && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n)) <= ' '; ++n) {
            }
            while (n3 >= n && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n3)) <= ' ') {
                --n3;
            }
            if (n == 0 && n3 == n2) {
                return this;
            }
            return new String(this.value, n, n3 - n + 1, true);
        }
        while (n <= n3 && this.charAtInternal(n) <= ' ') {
            ++n;
        }
        while (n3 >= n && this.charAtInternal(n3) <= ' ') {
            --n3;
        }
        if (n == 0 && n3 == n2) {
            return this;
        }
        return new String(this.value, n, n3 - n + 1, false);
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray, 0, cArray.length);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String valueOf(char c) {
        String string = c <= '\u00ff' ? (enableCompression ? new String(compressedAsciiTable[c], 0, 1, true) : new String(decompressedAsciiTable[c], 0, 1, false)) : new String(new char[]{c}, 0, 1, false);
        return string;
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(Object object) {
        return object != null ? object.toString() : "null";
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n = stringBuffer.length();
            if (this.lengthInternal() != n) {
                return false;
            }
            if (enableCompression && stringBuffer.isCompressed()) {
                return this.regionMatches(0, new String(stringBuffer.getValue(), 0, n, true), 0, n);
            }
            return this.regionMatches(0, new String(stringBuffer.getValue(), 0, n, false), 0, n);
        }
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public String replaceAll(String string, String string2) {
        if (string != null && string2 != null && string.lengthInternal() == 1 && !String.hasMetaChars(string)) {
            int n = string2.lengthInternal();
            int n2 = this.lengthInternal();
            if (n < 2) {
                if (enableCompression && this.isCompressed() && (n == 0 || string2.isCompressed())) {
                    char[] cArray = new char[n2 + 1 >>> 1];
                    byte by = helpers.getByteFromArrayByIndex(string.value, 0);
                    byte by2 = -1;
                    if (n == 1) {
                        by2 = helpers.getByteFromArrayByIndex(string2.value, 0);
                        this.checkLastChar((char)by2);
                    }
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        byte by3 = helpers.getByteFromArrayByIndex(this.value, i);
                        if (by3 != by) {
                            helpers.putByteInArrayByIndex(cArray, n3++, by3);
                            continue;
                        }
                        if (n != 1) continue;
                        helpers.putByteInArrayByIndex(cArray, n3++, by2);
                    }
                    return new String(cArray, 0, n3, true);
                }
                if (!enableCompression || !this.isCompressed()) {
                    char[] cArray = new char[n2];
                    char c = string.charAtInternal(0);
                    char c2 = '\uffff';
                    if (n == 1) {
                        c2 = string2.charAtInternal(0);
                        this.checkLastChar(c2);
                    }
                    int n4 = 0;
                    for (int i = 0; i < n2; ++i) {
                        char c3 = helpers.getCharFromArrayByIndex(this.value, i);
                        if (c3 != c) {
                            helpers.putCharInArrayByIndex(cArray, n4++, c3);
                            continue;
                        }
                        if (n != 1) continue;
                        helpers.putCharInArrayByIndex(cArray, n4++, c2);
                    }
                    return new String(cArray, 0, n4, false);
                }
            }
        }
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String[] split(String string) {
        return this.split(string, 0);
    }

    private static final boolean hasMetaChars(String string) {
        for (int i = 0; i < string.lengthInternal(); ++i) {
            char c = string.charAtInternal(i);
            if (c >= '\ud800' && c <= '\udfff') {
                return true;
            }
            for (int j = 0; j < regexMetaChars.length; ++j) {
                if (c != regexMetaChars[j]) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isSingleEscapeLiteral(String string) {
        if (string != null && string.lengthInternal() == 2 && string.charAtInternal(0) == '\\') {
            char c = string.charAtInternal(1);
            for (int i = 0; i < regexMetaChars.length; ++i) {
                if (c != regexMetaChars[i]) continue;
                return true;
            }
        }
        return false;
    }

    public String[] split(String string, int n) {
        boolean bl = String.isSingleEscapeLiteral(string);
        if (string != null && string.lengthInternal() > 0 && (!String.hasMetaChars(string) || bl)) {
            int n2;
            int n3;
            if (n == 1) {
                return new String[]{this};
            }
            ArrayList<String> arrayList = new ArrayList<String>(n > 0 && n < 100 ? n : 10);
            char[] cArray = this.value;
            boolean bl2 = enableCompression && (null == compressionFlag || this.count >= 0);
            int n4 = 0;
            int n5 = this.lengthInternal();
            if (string.lengthInternal() == 1 || bl) {
                n3 = string.charAtInternal(bl ? 1 : 0);
                for (n2 = 0; n2 < n5; ++n2) {
                    if (this.charAtInternal(n2, cArray) != n3) continue;
                    arrayList.add(new String(cArray, n4, n2 - n4, bl2));
                    n4 = n2 + 1;
                    if (n <= 0 || arrayList.size() != n - 1) continue;
                    arrayList.add(new String(cArray, n4, n5 - n4, bl2));
                    break;
                }
            } else {
                n3 = string.lengthInternal();
                char[] cArray2 = string.value;
                char c = this.charAtInternal(0, string.value);
                while (n2 < n5) {
                    if (this.charAtInternal(n2, cArray) == c) {
                        int n6;
                        int n7 = n2 + 1;
                        for (n6 = 1; n6 < n3 && n7 < n5 && this.charAtInternal(n7, cArray) == this.charAtInternal(n6, cArray2); ++n6, ++n7) {
                        }
                        if (n6 == n3) {
                            arrayList.add(new String(cArray, n4, n2 - n4, bl2));
                            n4 = n2 + n3;
                            if (n > 0 && arrayList.size() == n - 1) {
                                arrayList.add(new String(cArray, n4, n5 - n4, bl2));
                                break;
                            }
                            n2 += n3;
                            continue;
                        }
                    }
                    ++n2;
                }
            }
            if (arrayList.size() == 0) {
                return new String[]{this};
            }
            if (n4 <= n2 && arrayList.size() != n) {
                arrayList.add(new String(cArray, n4, n2 - n4, bl2));
            }
            if (n == 0) {
                n5 = arrayList.size();
                while (n5 > 0 && ((String)arrayList.get(n5 - 1)).lengthInternal() == 0) {
                    arrayList.remove(--n5);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return Pattern.compile(string).split(this, n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String(int[] nArray, int n, int n2) {
        if (n >= 0 && 0 <= n2 && n2 <= nArray.length - n) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            boolean bl = enableCompression;
            for (n6 = n; n6 < n + n2; ++n6) {
                n5 = nArray[n6];
                if (n5 < 0) {
                    throw new IllegalArgumentException();
                }
                if (n5 < 65536) {
                    if (bl && n5 > 255) {
                        bl = false;
                    }
                    ++n7;
                    continue;
                }
                if (n5 <= 0x10FFFF) {
                    if (bl) {
                        n4 = 55296 + ((n5 -= 65536) >> 10);
                        n3 = 56320 + (n5 & 0x3FF);
                        if (n4 > 255 || n3 > 255) {
                            bl = false;
                        }
                    }
                    n7 += 2;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (bl) {
                this.value = new char[n7 + 1 >>> 1];
                this.count = n7;
                n5 = 0;
                for (n6 = n; n6 < n + n2; ++n6) {
                    n4 = nArray[n6];
                    if (n4 < 65536) {
                        helpers.putByteInArrayByIndex(this.value, n5++, (byte)n4);
                        continue;
                    }
                    n3 = 55296 + ((n4 -= 65536) >> 10);
                    int n8 = 56320 + (n4 & 0x3FF);
                    helpers.putByteInArrayByIndex(this.value, n5++, (byte)n3);
                    helpers.putByteInArrayByIndex(this.value, n5++, (byte)n8);
                }
            } else {
                this.value = new char[n7];
                if (enableCompression) {
                    this.count = n7 | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                } else {
                    this.count = n7;
                }
                n5 = 0;
                for (n6 = n; n6 < n + n2; ++n6) {
                    n4 = nArray[n6];
                    if (n4 < 65536) {
                        this.value[n5++] = (char)n4;
                        continue;
                    }
                    this.value[n5++] = (char)(55296 + ((n4 -= 65536) >> 10));
                    this.value[n5++] = (char)(56320 + (n4 & 0x3FF));
                }
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(StringBuilder stringBuilder) {
        char[] cArray = stringBuilder.shareValue();
        if (enableCompression) {
            if (stringBuilder.isCompressed()) {
                this.value = cArray;
                this.count = stringBuilder.lengthInternal();
            } else {
                this.value = cArray;
                this.count = stringBuilder.lengthInternal() | Integer.MIN_VALUE;
                String.initCompressionFlag();
            }
        } else {
            this.value = cArray;
            this.count = stringBuilder.lengthInternal();
        }
    }

    public int codePointAt(int n) {
        int n2 = this.lengthInternal();
        if (n >= 0 && n < n2) {
            char c;
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n));
            }
            char c2 = this.charAtInternal(n);
            if (n < n2 - 1 && Character.isHighSurrogate(c2) && Character.isLowSurrogate(c = this.charAtInternal(n + 1))) {
                return Character.toCodePoint(c2, c);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointBefore(int n) {
        int n2 = this.lengthInternal();
        if (n > 0 && n <= n2) {
            char c;
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n - 1));
            }
            char c2 = this.charAtInternal(n - 1);
            if (n > 1 && Character.isLowSurrogate(c2) && Character.isHighSurrogate(c = this.charAtInternal(n - 2))) {
                return Character.toCodePoint(c, c2);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointCount(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n >= 0 && n <= n2 && n2 <= n3) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                return n2 - n;
            }
            int n4 = 0;
            for (int i = n; i < n2; ++i) {
                if (i < n2 - 1 && Character.isHighSurrogate(this.charAtInternal(i)) && Character.isLowSurrogate(this.charAtInternal(i + 1))) {
                    ++i;
                }
                ++n4;
            }
            return n4;
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n >= 0 && n <= n3) {
            if (enableCompression && (null == compressionFlag || this.count >= 0)) {
                int n4 = n + n2;
                if (n4 > n3) {
                    throw new IndexOutOfBoundsException();
                }
                return n4;
            }
            int n5 = n;
            if (n2 == 0) {
                return n;
            }
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    if (n5 == n3) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n5 < n3 - 1 && Character.isHighSurrogate(this.charAtInternal(n5)) && Character.isLowSurrogate(this.charAtInternal(n5 + 1))) {
                        ++n5;
                    }
                    ++n5;
                }
            } else {
                for (int i = n2; i < 0; ++i) {
                    if (n5 < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n5 > 1 && Character.isLowSurrogate(this.charAtInternal(n5 - 1)) && Character.isHighSurrogate(this.charAtInternal(n5 - 2))) {
                        --n5;
                    }
                    --n5;
                }
            }
            return n5;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean contentEquals(CharSequence charSequence) {
        int n = this.lengthInternal();
        if (n != charSequence.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.charAtInternal(i) == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(CharSequence charSequence) {
        int n = this.lengthInternal();
        int n2 = charSequence.length();
        if (n2 > n) {
            return false;
        }
        int n3 = 0;
        if (n2 > 0) {
            if (n2 + n3 > n) {
                return false;
            }
            char c = charSequence.charAt(0);
            while (true) {
                int n4;
                if ((n4 = this.indexOf(c, n3)) == -1 || n2 + n4 > n) {
                    return false;
                }
                int n5 = n4;
                int n6 = 0;
                while (++n6 < n2 && this.charAtInternal(++n5) == charSequence.charAt(n6)) {
                }
                if (n6 == n2) {
                    return true;
                }
                n3 = n4 + 1;
            }
        }
        return true;
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        if (charSequence2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.lengthInternal();
        int n3 = charSequence.length();
        if (n3 == 0) {
            int n4 = charSequence2.length();
            if (n4 != 0 && n2 >= (Integer.MAX_VALUE - n2) / n4) {
                throw new OutOfMemoryError(Msg.getString("K0D01"));
            }
            StringBuilder stringBuilder = new StringBuilder(n2 + (n2 + 1) * n4);
            stringBuilder.append(charSequence2);
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(this.charAt(i)).append(charSequence2);
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = 0;
        int n6 = 0;
        char c = charSequence.charAt(0);
        while (n5 < n2 && (n = this.indexOf(c, n5)) != -1) {
            boolean bl = true;
            if (n3 > 1) {
                if (n3 > n2 - n) break;
                for (int i = 1; i < n3; ++i) {
                    if (this.charAt(n + i) == charSequence.charAt(i)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                stringBuilder.append(this.substring(n6, n)).append(charSequence2);
                n6 = n5 = n + n3;
                continue;
            }
            n5 = n + 1;
        }
        if (stringBuilder.length() == 0 && n6 == 0) {
            return this;
        }
        stringBuilder.append(this.substring(n6));
        return stringBuilder.toString();
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(string, objectArray).toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        return new Formatter(locale).format(string, objectArray).toString();
    }

    public boolean isEmpty() {
        return this.lengthInternal() == 0;
    }

    public String(byte[] byArray, Charset charset) {
        this(byArray, 0, byArray.length, charset);
    }

    public String(byte[] byArray, int n, int n2, Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        if (n >= 0 && 0 <= n2 && n2 <= byArray.length - n) {
            char[] cArray = StringCoding.decode(charset, byArray, n, n2);
            if (enableCompression) {
                if (String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                    this.value = new char[cArray.length + 1 >>> 1];
                    this.count = cArray.length;
                    String.compress(cArray, 0, this.value, 0, cArray.length);
                } else {
                    this.value = cArray;
                    this.count = cArray.length | Integer.MIN_VALUE;
                    String.initCompressionFlag();
                }
            } else {
                this.value = cArray;
                this.count = cArray.length;
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public byte[] getBytes(Charset charset) {
        char[] cArray;
        int n = this.lengthInternal();
        if (enableCompression && this.count >= 0) {
            cArray = new char[n];
            String.decompress(this.value, 0, cArray, 0, n);
        } else {
            cArray = this.value;
        }
        return StringCoding.encode(charset, cArray, 0, n);
    }

    public static String join(CharSequence charSequence, CharSequence ... charSequenceArray) {
        StringJoiner stringJoiner = new StringJoiner(charSequence);
        for (CharSequence charSequence2 : charSequenceArray) {
            stringJoiner.add(charSequence2);
        }
        return stringJoiner.toString();
    }

    public static String join(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        StringJoiner stringJoiner = new StringJoiner(charSequence);
        Iterator<? extends CharSequence> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringJoiner.add(iterator.next());
        }
        return stringJoiner.toString();
    }

    static {
        char[] cArray;
        int n;
        enableCompression = VM.J9_STRING_COMPRESSION_ENABLED;
        CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
        emptyValue = new char[0];
        helpers = JITHelpers.getHelpers();
        stringArray = new String[10];
        compressedAsciiTable = new char[256][];
        for (n = 0; n < compressedAsciiTable.length; ++n) {
            cArray = new char[1];
            helpers.putByteInArrayByIndex(cArray, 0, (byte)n);
            String.compressedAsciiTable[n] = cArray;
        }
        decompressedAsciiTable = new char[256][];
        for (n = 0; n < decompressedAsciiTable.length; ++n) {
            cArray = new char[1];
            helpers.putCharInArrayByIndex(cArray, 0, (char)n);
            String.decompressedAsciiTable[n] = cArray;
        }
        startCombiningAbove = new char[]{'\u0300', '\u033d', '\u0346', '\u034a', '\u0350', '\u0357', '\u035b', '\u0363', '\u0483', '\u0592', '\u0597', '\u059c', '\u05a8', '\u05ab', '\u05af', '\u05c4', '\u0610', '\u0653', '\u0657', '\u065d', '\u06d6', '\u06df', '\u06e4', '\u06e7', '\u06eb', '\u0730', '\u0732', '\u0735', '\u073a', '\u073d', '\u073f', '\u0743', '\u0745', '\u0747', '\u0749', '\u07eb', '\u07f3', '\u0816', '\u081b', '\u0825', '\u0829', '\u08e4', '\u08e7', '\u08ea', '\u08f3', '\u08f7', '\u08fb', '\u0951', '\u0953', '\u0f82', '\u0f86', '\u135d', '\u17dd', '\u193a', '\u1a17', '\u1a75', '\u1b6b', '\u1b6d', '\u1cd0', '\u1cda', '\u1ce0', '\u1cf4', '\u1dc0', '\u1dc3', '\u1dcb', '\u1dd1', '\u1dfe', '\u20d0', '\u20d4', '\u20db', '\u20e1', '\u20e7', '\u20e9', '\u20f0', '\u2cef', '\u2de0', '\ua66f', '\ua674', '\ua69f', '\ua6f0', '\ua8e0', '\uaab0', '\uaab2', '\uaab7', '\uaabe', '\uaac1', '\ufe20'};
        endCombiningAbove = new char[]{'\u0314', '\u0344', '\u0346', '\u034c', '\u0352', '\u0357', '\u035b', '\u036f', '\u0487', '\u0595', '\u0599', '\u05a1', '\u05a9', '\u05ac', '\u05af', '\u05c4', '\u0617', '\u0654', '\u065b', '\u065e', '\u06dc', '\u06e2', '\u06e4', '\u06e8', '\u06ec', '\u0730', '\u0733', '\u0736', '\u073a', '\u073d', '\u0741', '\u0743', '\u0745', '\u0747', '\u074a', '\u07f1', '\u07f3', '\u0819', '\u0823', '\u0827', '\u082d', '\u08e5', '\u08e8', '\u08ec', '\u08f5', '\u08f8', '\u08fe', '\u0951', '\u0954', '\u0f83', '\u0f87', '\u135f', '\u17dd', '\u193a', '\u1a17', '\u1a7c', '\u1b6b', '\u1b73', '\u1cd2', '\u1cdb', '\u1ce0', '\u1cf4', '\u1dc1', '\u1dc9', '\u1dcc', '\u1de6', '\u1dfe', '\u20d1', '\u20d7', '\u20dc', '\u20e1', '\u20e7', '\u20e9', '\u20f0', '\u2cf1', '\u2dff', '\ua66f', '\ua67d', '\ua69f', '\ua6f1', '\ua8f1', '\uaab0', '\uaab3', '\uaab8', '\uaabf', '\uaac1', '\ufe26'};
        upperValues = new char[]{'S', 'S', '\u0000', '\u02bc', 'N', '\u0000', 'J', '\u030c', '\u0000', '\u0399', '\u0308', '\u0301', '\u03a5', '\u0308', '\u0301', '\u0535', '\u0552', '\u0000', 'H', '\u0331', '\u0000', 'T', '\u0308', '\u0000', 'W', '\u030a', '\u0000', 'Y', '\u030a', '\u0000', 'A', '\u02be', '\u0000', '\u03a5', '\u0313', '\u0000', '\u03a5', '\u0313', '\u0300', '\u03a5', '\u0313', '\u0301', '\u03a5', '\u0313', '\u0342', '\u1f08', '\u0399', '\u0000', '\u1f09', '\u0399', '\u0000', '\u1f0a', '\u0399', '\u0000', '\u1f0b', '\u0399', '\u0000', '\u1f0c', '\u0399', '\u0000', '\u1f0d', '\u0399', '\u0000', '\u1f0e', '\u0399', '\u0000', '\u1f0f', '\u0399', '\u0000', '\u1f08', '\u0399', '\u0000', '\u1f09', '\u0399', '\u0000', '\u1f0a', '\u0399', '\u0000', '\u1f0b', '\u0399', '\u0000', '\u1f0c', '\u0399', '\u0000', '\u1f0d', '\u0399', '\u0000', '\u1f0e', '\u0399', '\u0000', '\u1f0f', '\u0399', '\u0000', '\u1f28', '\u0399', '\u0000', '\u1f29', '\u0399', '\u0000', '\u1f2a', '\u0399', '\u0000', '\u1f2b', '\u0399', '\u0000', '\u1f2c', '\u0399', '\u0000', '\u1f2d', '\u0399', '\u0000', '\u1f2e', '\u0399', '\u0000', '\u1f2f', '\u0399', '\u0000', '\u1f28', '\u0399', '\u0000', '\u1f29', '\u0399', '\u0000', '\u1f2a', '\u0399', '\u0000', '\u1f2b', '\u0399', '\u0000', '\u1f2c', '\u0399', '\u0000', '\u1f2d', '\u0399', '\u0000', '\u1f2e', '\u0399', '\u0000', '\u1f2f', '\u0399', '\u0000', '\u1f68', '\u0399', '\u0000', '\u1f69', '\u0399', '\u0000', '\u1f6a', '\u0399', '\u0000', '\u1f6b', '\u0399', '\u0000', '\u1f6c', '\u0399', '\u0000', '\u1f6d', '\u0399', '\u0000', '\u1f6e', '\u0399', '\u0000', '\u1f6f', '\u0399', '\u0000', '\u1f68', '\u0399', '\u0000', '\u1f69', '\u0399', '\u0000', '\u1f6a', '\u0399', '\u0000', '\u1f6b', '\u0399', '\u0000', '\u1f6c', '\u0399', '\u0000', '\u1f6d', '\u0399', '\u0000', '\u1f6e', '\u0399', '\u0000', '\u1f6f', '\u0399', '\u0000', '\u1fba', '\u0399', '\u0000', '\u0391', '\u0399', '\u0000', '\u0386', '\u0399', '\u0000', '\u0391', '\u0342', '\u0000', '\u0391', '\u0342', '\u0399', '\u0391', '\u0399', '\u0000', '\u1fca', '\u0399', '\u0000', '\u0397', '\u0399', '\u0000', '\u0389', '\u0399', '\u0000', '\u0397', '\u0342', '\u0000', '\u0397', '\u0342', '\u0399', '\u0397', '\u0399', '\u0000', '\u0399', '\u0308', '\u0300', '\u0399', '\u0308', '\u0301', '\u0399', '\u0342', '\u0000', '\u0399', '\u0308', '\u0342', '\u03a5', '\u0308', '\u0300', '\u03a5', '\u0308', '\u0301', '\u03a1', '\u0313', '\u0000', '\u03a5', '\u0342', '\u0000', '\u03a5', '\u0308', '\u0342', '\u1ffa', '\u0399', '\u0000', '\u03a9', '\u0399', '\u0000', '\u038f', '\u0399', '\u0000', '\u03a9', '\u0342', '\u0000', '\u03a9', '\u0342', '\u0399', '\u03a9', '\u0399', '\u0000', 'F', 'F', '\u0000', 'F', 'I', '\u0000', 'F', 'L', '\u0000', 'F', 'F', 'I', 'F', 'F', 'L', 'S', 'T', '\u0000', 'S', 'T', '\u0000', '\u0544', '\u0546', '\u0000', '\u0544', '\u0535', '\u0000', '\u0544', '\u053b', '\u0000', '\u054e', '\u0546', '\u0000', '\u0544', '\u053d', '\u0000'};
        upperIndexs = new char[]{'\u000b', '\u0000', '\f', '\u0000', '\r', '\u0000', '\u000e', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '\u0000', '\u0000', '?', '@', 'A', '\u0000', 'B', 'C', '\u0000', '\u0000', '\u0000', '\u0000', 'D', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'E', 'F', 'G', '\u0000', 'H', 'I', '\u0000', '\u0000', '\u0000', '\u0000', 'J', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'K', 'L', '\u0000', '\u0000', 'M', 'N', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'O', 'P', 'Q', '\u0000', 'R', 'S', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'T', 'U', 'V', '\u0000', 'W', 'X', '\u0000', '\u0000', '\u0000', '\u0000', 'Y'};
        regexMetaChars = new char[]{'.', '$', '|', '(', ')', '[', ']', '{', '}', '^', '?', '*', '+', '\\'};
        serialPersistentFields = new ObjectStreamField[0];
    }

    private static class UnsafeHelpers {
        public static final long valueFieldOffset = UnsafeHelpers.getValueFieldOffset();

        private UnsafeHelpers() {
        }

        static long getValueFieldOffset() {
            try {
                return Unsafe.getUnsafe().objectFieldOffset(String.class.getDeclaredField("value"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
        }
    }

    static class StringCompressionFlag
    implements Serializable {
        private static final long serialVersionUID = 1346155847239551492L;

        StringCompressionFlag() {
        }
    }

    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

