/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.ntlm;

import com.sun.security.ntlm.NTLM;
import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Version;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public final class Client
extends NTLM {
    private final String hostname;
    private final String username;
    private String domain;
    private byte[] pw1;
    private byte[] pw2;

    public Client(String string, String string2, String string3, String string4, char[] cArray) throws NTLMException {
        super(string);
        if (string3 == null || cArray == null) {
            throw new NTLMException(6, "username/password cannot be null");
        }
        this.hostname = string2;
        this.username = string3;
        this.domain = string4 == null ? "" : string4;
        this.pw1 = Client.getP1(cArray);
        this.pw2 = Client.getP2(cArray);
        this.debug("NTLM Client: (h,u,t,version(v)) = (%s,%s,%s,%s(%s))\n", new Object[]{string2, string3, string4, string, this.v.toString()});
    }

    public byte[] type1() {
        NTLM.Writer writer = new NTLM.Writer(1, 32);
        int n = 33287;
        if (this.v != Version.NTLM) {
            n |= 0x80000;
        }
        writer.writeInt(12, n);
        this.debug("NTLM Client: Type 1 created\n", new Object[0]);
        this.debug(writer.getBytes());
        return writer.getBytes();
    }

    public byte[] type3(byte[] byArray, byte[] byArray2) throws NTLMException {
        if (byArray == null || this.v != Version.NTLM && byArray2 == null) {
            throw new NTLMException(6, "type2 and nonce cannot be null");
        }
        this.debug("NTLM Client: Type 2 received\n", new Object[0]);
        this.debug(byArray);
        NTLM.Reader reader = new NTLM.Reader(byArray);
        byte[] byArray3 = reader.readBytes(24, 8);
        int n = reader.readInt(20);
        boolean bl = (n & 1) == 1;
        int n2 = 0x88200 | n & 3;
        NTLM.Writer writer = new NTLM.Writer(3, 64);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        writer.writeSecurityBuffer(28, this.domain, bl);
        writer.writeSecurityBuffer(36, this.username, bl);
        writer.writeSecurityBuffer(44, this.hostname, bl);
        if (this.v == Version.NTLM) {
            byte[] byArray6 = this.calcLMHash(this.pw1);
            byte[] byArray7 = this.calcNTHash(this.pw2);
            if (this.writeLM) {
                byArray4 = this.calcResponse(byArray6, byArray3);
            }
            if (this.writeNTLM) {
                byArray5 = this.calcResponse(byArray7, byArray3);
            }
        } else if (this.v == Version.NTLM2) {
            byte[] byArray8 = this.calcNTHash(this.pw2);
            byArray4 = Client.ntlm2LM(byArray2);
            byArray5 = this.ntlm2NTLM(byArray8, byArray2, byArray3);
        } else {
            byte[] byArray9 = this.calcNTHash(this.pw2);
            if (this.writeLM) {
                byArray4 = this.calcV2(byArray9, this.username.toUpperCase(Locale.US) + this.domain, byArray2, byArray3);
            }
            if (this.writeNTLM) {
                byte[] byArray10 = (n & 0x800000) != 0 ? reader.readSecurityBuffer(40) : new byte[]{};
                byte[] byArray11 = new byte[32 + byArray10.length];
                System.arraycopy((Object)new byte[]{1, 1, 0, 0, 0, 0, 0, 0}, 0, (Object)byArray11, 0, 8);
                byte[] byArray12 = BigInteger.valueOf(new Date().getTime()).add(new BigInteger("11644473600000")).multiply(BigInteger.valueOf(10000L)).toByteArray();
                for (int i = 0; i < byArray12.length; ++i) {
                    byArray11[8 + byArray12.length - i - 1] = byArray12[i];
                }
                System.arraycopy((Object)byArray2, 0, (Object)byArray11, 16, 8);
                System.arraycopy((Object)new byte[]{0, 0, 0, 0}, 0, (Object)byArray11, 24, 4);
                System.arraycopy((Object)byArray10, 0, (Object)byArray11, 28, byArray10.length);
                System.arraycopy((Object)new byte[]{0, 0, 0, 0}, 0, (Object)byArray11, 28 + byArray10.length, 4);
                byArray5 = this.calcV2(byArray9, this.username.toUpperCase(Locale.US) + this.domain, byArray11, byArray3);
            }
        }
        writer.writeSecurityBuffer(12, byArray4);
        writer.writeSecurityBuffer(20, byArray5);
        writer.writeSecurityBuffer(52, new byte[0]);
        writer.writeInt(60, n2);
        this.debug("NTLM Client: Type 3 created\n", new Object[0]);
        this.debug(writer.getBytes());
        return writer.getBytes();
    }

    public String getDomain() {
        return this.domain;
    }

    public void dispose() {
        Arrays.fill(this.pw1, (byte)0);
        Arrays.fill(this.pw2, (byte)0);
    }
}

