/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryUsageUtil;
import com.ibm.oti.util.Msg;
import com.sun.management.GcInfo;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class GcInfoUtil {
    private static CompositeType compositeType;
    private static Constructor<GcInfo> gcInfoPrivateConstructor;

    private static Constructor<GcInfo> getGcInfoPrivateConstructor() {
        if (null == gcInfoPrivateConstructor) {
            gcInfoPrivateConstructor = AccessController.doPrivileged(new PrivilegedAction<Constructor<GcInfo>>(){

                @Override
                public Constructor<GcInfo> run() {
                    try {
                        Constructor<GcInfo> constructor = GcInfo.class.getDeclaredConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class);
                        constructor.setAccessible(true);
                        return constructor;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        InternalError internalError = new InternalError(Msg.getString("K0660"));
                        internalError.initCause(noSuchMethodException);
                        throw internalError;
                    }
                }
            });
        }
        return gcInfoPrivateConstructor;
    }

    public static CompositeType getCompositeType() {
        block3: {
            if (null == compositeType) {
                String[] stringArray = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
                String[] stringArray2 = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, MemoryUsageUtil.getTabularType(), MemoryUsageUtil.getTabularType()};
                try {
                    compositeType = new CompositeType(GcInfo.class.getName(), GcInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(GcInfo gcInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            compositeDataSupport = null;
            if (null != gcInfo) {
                CompositeType compositeType = GcInfoUtil.getCompositeType();
                String[] stringArray = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
                Object[] objectArray = new Object[]{gcInfo.getId(), gcInfo.getStartTime(), gcInfo.getEndTime(), MemoryUsageUtil.toTabularData(gcInfo.getMemoryUsageBeforeGc()), MemoryUsageUtil.toTabularData(gcInfo.getMemoryUsageAfterGc())};
                try {
                    compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeDataSupport;
    }

    public static GcInfo newGcInfoInstance(long l, long l2, long l3, Map<String, MemoryUsage> map, Map<String, MemoryUsage> map2) {
        GcInfo gcInfo = null;
        Constructor<GcInfo> constructor = GcInfoUtil.getGcInfoPrivateConstructor();
        try {
            gcInfo = constructor.newInstance(l, l2, l3, map, map2);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError(Msg.getString("K0661"));
            internalError.initCause(exception);
            throw internalError;
        }
        return gcInfo;
    }

    private GcInfoUtil() {
    }

    static {
        gcInfoPrivateConstructor = null;
    }
}

