/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gpu;

import com.ibm.gpu.CUDAManager;
import com.ibm.gpu.GPUConfigurationException;
import com.ibm.gpu.GPUSortException;
import com.ibm.gpu.SortNetwork;
import java.util.Objects;

public class Maths {
    private static int getDefaultDevice() {
        return CUDAManager.instanceInternal().getDefaultDevice();
    }

    public static void sortArray(double[] dArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(dArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), dArray, 0, dArray.length);
    }

    public static void sortArray(double[] dArray, int n, int n2) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(dArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), dArray, n, n2);
    }

    public static void sortArray(float[] fArray) throws GPUSortException, GPUConfigurationException {
        Objects.requireNonNull(fArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), fArray, 0, fArray.length);
    }

    public static void sortArray(float[] fArray, int n, int n2) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(fArray);
        Maths.sortArray(Maths.getDefaultDevice(), fArray, n, n2);
    }

    public static void sortArray(int n, double[] dArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(dArray);
        SortNetwork.sortArray(n, dArray, 0, dArray.length);
    }

    public static void sortArray(int n, double[] dArray, int n2, int n3) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(dArray);
        SortNetwork.sortArray(n, dArray, n2, n3);
    }

    public static void sortArray(int n, float[] fArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(fArray);
        SortNetwork.sortArray(n, fArray, 0, fArray.length);
    }

    public static void sortArray(int n, float[] fArray, int n2, int n3) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(fArray);
        SortNetwork.sortArray(n, fArray, n2, n3);
    }

    public static void sortArray(int n, int[] nArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(nArray);
        SortNetwork.sortArray(n, nArray, 0, nArray.length);
    }

    public static void sortArray(int n, int[] nArray, int n2, int n3) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(nArray);
        SortNetwork.sortArray(n, nArray, n2, n3);
    }

    public static void sortArray(int n, long[] lArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(lArray);
        SortNetwork.sortArray(n, lArray, 0, lArray.length);
    }

    public static void sortArray(int n, long[] lArray, int n2, int n3) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(lArray);
        SortNetwork.sortArray(n, lArray, n2, n3);
    }

    public static void sortArray(int[] nArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(nArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), nArray, 0, nArray.length);
    }

    public static void sortArray(int[] nArray, int n, int n2) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(nArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), nArray, n, n2);
    }

    public static void sortArray(long[] lArray) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(lArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), lArray, 0, lArray.length);
    }

    public static void sortArray(long[] lArray, int n, int n2) throws GPUConfigurationException, GPUSortException {
        Objects.requireNonNull(lArray);
        SortNetwork.sortArray(Maths.getDefaultDevice(), lArray, n, n2);
    }
}

