/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ConcisePanel;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.ui.TextWriter;

public abstract class LiveText
extends Group {
    String text;

    public LiveText(int width) {
        this.setSize(width, TannFont.font.getLineHeight());
        this.setTransform(false);
    }

    public abstract String fetchText();

    @Override
    public void act(float delta) {
        String newText = this.fetchText();
        if (!newText.equals(this.text)) {
            this.setToNewText(newText);
        }
        super.act(delta);
    }

    private void setToNewText(String newText) {
        String cs;
        Color c;
        int end;
        this.text = newText;
        this.clearChildren();
        Color fc = Colours.text;
        if (newText.startsWith("[") && (end = newText.indexOf("]")) > 0 && (c = TextWriter.getMapCol(cs = newText.substring(1, end))) != null) {
            newText = newText.substring(end + 1);
            fc = c;
        }
        Actor a = ConcisePanel.makeTitle(newText, fc, (int)this.getWidth());
        this.addActor(a);
        Tann.center(a);
        a.setY(0.0f);
    }
}

