/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.util.Noise;
import com.tann.dice.util.Tann;

public class ShakeAction
extends Action {
    final float startTime;
    final float frequency;
    float timeLeft;
    float startMagnitude;
    Interpolation interpolation;
    float startX;
    float startY;
    float prevX;
    float prevY;
    boolean started;
    float rand;
    boolean cancelled;

    public ShakeAction(float magnitude, float frequency, float time, Interpolation interpolation) {
        this.startTime = time;
        this.timeLeft = time;
        this.startMagnitude = magnitude;
        this.frequency = frequency;
        this.interpolation = interpolation;
        this.rand = Tann.random() * 100.0f;
    }

    @Override
    public void setActor(Actor actor) {
        this.cancelled = true;
        if (actor != null) {
            this.cancelled = false;
            for (Action a : actor.getActions()) {
                if (!(a instanceof ShakeAction)) continue;
                this.cancelled = true;
            }
        }
        super.setActor(actor);
    }

    private void setupStart() {
        this.startX = this.target.getX();
        this.startY = this.target.getY();
    }

    private void setupSPrev() {
        this.prevX = this.target.getX();
        this.prevY = this.target.getY();
    }

    @Override
    public boolean act(float delta) {
        if (this.cancelled) {
            return true;
        }
        if (!this.started) {
            this.started = true;
            this.setupStart();
        } else if (this.prevX != this.target.getX() && this.startX != this.target.getX() || this.prevY != this.target.getY() && this.startY != this.target.getY()) {
            this.setupStart();
        }
        float ratio = this.timeLeft / this.startTime;
        float currentMagnitude = this.startMagnitude * this.interpolation.apply(ratio);
        this.target.setPosition((float)((double)this.startX + Noise.noise(this.rand, this.frequency * Main.secs) * (double)currentMagnitude), (float)((double)this.startY + Noise.noise(100.0f + this.rand, this.frequency * Main.secs) * (double)currentMagnitude));
        if (ratio <= 0.0f) {
            this.target.setPosition(this.startX, this.startY);
            return true;
        }
        this.timeLeft -= delta;
        this.setupSPrev();
        return false;
    }
}

