/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.RainbowAction;
import com.tann.dice.util.Tann;

public class FlameActor
extends Actor {
    static final Color[] cols = new Color[]{Colours.light, Colours.orange, Colours.red, Colours.dark, Colours.withAlpha(Colours.dark, 0.0f).cpy()};
    int size;
    boolean radial;
    float moveAmount;
    float duration;

    public FlameActor(int size, float moveAmount, boolean radial, float duration) {
        this.size = size;
        this.radial = radial;
        this.moveAmount = moveAmount;
        this.duration = duration;
    }

    public void animate(float delay) {
        float moveY;
        float moveX;
        this.setScale(0.3f);
        this.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.radial) {
            Vector2 random = Tann.randomRadial(this.moveAmount);
            moveX = random.x;
            moveY = random.y;
        } else {
            float randomSide = 10.0f;
            float randomUp = 10.0f;
            moveX = Tann.random(randomSide, -randomSide);
            moveY = this.moveAmount + Tann.random(randomUp);
        }
        this.addAction(Actions.sequence((Action)Actions.delay(delay), (Action)Actions.parallel((Action)Actions.moveBy(moveX, moveY, this.duration), (Action)new RainbowAction(this.duration, cols), (Action)Actions.scaleTo(1.0f, 1.0f, this.duration, Interpolation.pow3Out)), (Action)Actions.removeActor()));
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        Draw.fillEllipse(batch, this.getX(), this.getY(), (float)this.size * this.getScaleX(), (float)this.size * this.getScaleY());
    }
}

