/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Maths;
import java.util.HashMap;
import java.util.Map;

public class Draw {
    public static TextureRegion circle50;
    private static TextureRegion wSq;
    private static Map<String, Texture> arcs;
    static float[] triangle;

    public static void setup() {
        circle50 = ImageUtils.loadExt("junk/misc/circle50");
    }

    public static void draw(Batch batch, Texture t, float x, float y) {
        Draw.drawRotatedScaled(batch, t, x, y, 1.0f, 1.0f, 0.0f);
    }

    public static void drawScaled(Batch batch, Texture t, float x, float y, float scaleX, float scaleY) {
        Draw.drawRotatedScaled(batch, t, x, y, scaleX, scaleY, 0.0f);
    }

    public static void drawRotatedScaled(Batch batch, Texture t, float x, float y, float scaleX, float scaleY, float radianRotation) {
        Draw.drawRotatedScaledFlipped(batch, t, x, y, scaleX, scaleY, radianRotation, false, false);
    }

    public static void drawRotatedScaledFlipped(Batch batch, Texture t, float x, float y, float scaleX, float scaleY, float radianRotation, boolean xFlip, boolean yFlip) {
        batch.draw(t, x, y, 0.0f, 0.0f, t.getWidth(), t.getHeight(), scaleX, scaleY, Draw.rad2deg(radianRotation), 0, 0, t.getWidth(), t.getHeight(), xFlip, yFlip);
    }

    public static void drawCentered(Batch batch, Texture t, float x, float y) {
        Draw.drawCenteredRotatedScaled(batch, t, x, y, 1.0f, 1.0f, 0.0f);
    }

    public static void drawCenteredScaled(Batch batch, Texture t, float x, float y, float scaleX, float scaleY) {
        Draw.drawCenteredRotatedScaled(batch, t, x, y, scaleX, scaleY, 0.0f);
    }

    public static void drawCenteredRotated(Batch batch, Texture t, float x, float y, float radianRotation) {
        Draw.drawCenteredRotatedScaled(batch, t, x, y, 1.0f, 1.0f, radianRotation);
    }

    public static void drawCenteredRotatedScaled(Batch batch, Texture t, float x, float y, float xScale, float yScale, float radianRotation) {
        Draw.drawCenteredRotatedScaledFlipped(batch, t, x, y, xScale, yScale, radianRotation, false, false);
    }

    public static void drawCenteredRotatedScaledFlipped(Batch batch, Texture t, float x, float y, float xScale, float yScale, float radianRotation, boolean xFlip, boolean yFlip) {
        batch.draw(t, x - (float)(t.getWidth() / 2), y - (float)(t.getHeight() / 2), (float)t.getWidth() / 2.0f, (float)t.getHeight() / 2.0f, t.getWidth(), t.getHeight(), xScale, yScale, Draw.rad2deg(radianRotation), 0, 0, t.getWidth(), t.getHeight(), xFlip, yFlip);
    }

    public static void draw(Batch batch, TextureRegion t, float x, float y) {
        Draw.drawRotatedScaled(batch, t, x, y, 1.0f, 1.0f, 0.0f);
    }

    public static void drawScaled(Batch batch, TextureRegion t, float x, float y, float scaleX, float scaleY) {
        Draw.drawRotatedScaled(batch, t, x, y, scaleX, scaleY, 0.0f);
    }

    public static void drawRotatedScaled(Batch batch, TextureRegion t, float x, float y, float scaleX, float scaleY, float radianRotation) {
        batch.draw(t, x, y, 0.0f, 0.0f, t.getRegionWidth(), t.getRegionHeight(), scaleX, scaleY, Draw.rad2deg(radianRotation));
    }

    public static void drawCentered(Batch batch, TextureRegion t, float x, float y) {
        Draw.drawCenteredRotatedScaled(batch, t, x, y, 1.0f, 1.0f, 0.0f);
    }

    public static void drawCenteredScaled(Batch batch, TextureRegion t, float x, float y, float scaleX, float scaleY) {
        Draw.drawCenteredRotatedScaled(batch, t, x, y, scaleX, scaleY, 0.0f);
    }

    public static void drawCenteredRotated(Batch batch, TextureRegion t, float x, float y, float radianRotation) {
        Draw.drawCenteredRotatedScaled(batch, t, x, y, 1.0f, 1.0f, radianRotation);
    }

    public static void drawCenteredRotatedScaled(Batch batch, TextureRegion t, float x, float y, float xScale, float yScale, float radianRotation) {
        Draw.drawCenteredRotatedScaledFlipped(batch, t, x, y, xScale, yScale, radianRotation);
    }

    public static void drawCenteredRotatedScaledFlipped(Batch batch, TextureRegion t, float x, float y, float scaleX, float scaleY, float radianRotation) {
        batch.draw(t, (int)(x - (float)t.getRegionWidth() / 2.0f), (int)(y - (float)t.getRegionHeight() / 2.0f), (float)t.getRegionWidth() / 2.0f, (float)t.getRegionHeight() / 2.0f, t.getRegionWidth(), t.getRegionHeight(), scaleX, scaleY, Draw.rad2deg(radianRotation));
    }

    public static void drawFlipped(Batch batch, TextureRegion t, float x, float y, boolean xFlip, boolean yFlip) {
        batch.draw(t, xFlip ? x + (float)t.getRegionWidth() : x, yFlip ? y + (float)t.getRegionHeight() : y, 0.0f, 0.0f, t.getRegionWidth(), t.getRegionHeight(), xFlip ? -1.0f : 1.0f, yFlip ? -1.0f : 1.0f, 0.0f);
    }

    public static void drawRectangle(Batch batch, float x, float y, float width, float height, int lineWidth) {
        Draw.fillRectangle(batch, x, y, width, lineWidth);
        Draw.fillRectangle(batch, x, y + height - (float)lineWidth, width, lineWidth);
        Draw.fillRectangle(batch, x, y, lineWidth, height);
        Draw.fillRectangle(batch, x + width - (float)lineWidth, y, lineWidth, height);
    }

    public static void drawRectangle(Batch batch, float x, float y, float width, float height) {
        Draw.drawRectangle(batch, x, y, width, height, 1);
    }

    public static void fillRectangle(Batch batch, float x, float y, float width, float height) {
        Draw.drawScaled(batch, Draw.getSq(), x, y, width, height);
    }

    public static void fillRectangle(Batch batch, float x, float y, float width, float height, Color inside, Color edge, int border) {
        batch.setColor(edge);
        Draw.fillRectangle(batch, x, y, width, height);
        batch.setColor(inside);
        Draw.fillRectangle(batch, x + (float)border, y + (float)border, width - (float)(border * 2), height - (float)(border * 2));
    }

    public static void fillEllipse(Batch batch, float x, float y, float width, float height) {
        Draw.drawScaled(batch, circle50, x - width / 2.0f, y - height / 2.0f, width / 50.0f, height / 50.0f);
    }

    public static void drawLine(Batch batch, Vector2 start, Vector2 end, int width) {
        Draw.drawLine(batch, start.x, start.y, end.x, end.y, width);
    }

    public static void drawLine(Batch batch, float x, float y, float tX, float tY, float width) {
        float dist = (float)Math.sqrt((tX - x) * (tX - x) + (tY - y) * (tY - y)) + 0.01f;
        float radians = (float)Math.atan2(tY - y, tX - x);
        batch.draw(Draw.getSq(), x + 0.5f, y, 0.0f, 0.5f, 1.0f, 1.0f, dist, width, (float)Math.toDegrees(radians));
    }

    public static void drawDottedLine(Batch batch, float x, float y, float tX, float tY, float width, float segmentSize, float gapSize, float speed) {
        float dist = (float)Math.sqrt((tX - x) * (tX - x) + (tY - y) * (tY - y)) + 0.01f;
        float radians = (float)Math.atan2(tY - y, tX - x);
        float position = Main.secs * speed * (gapSize + segmentSize);
        position %= segmentSize + gapSize;
        position -= segmentSize + gapSize;
        while (position < dist) {
            float drawX = (float)((double)x + Math.cos(radians) * (double)Math.max(0.0f, position));
            float drawY = (float)((double)y + Math.sin(radians) * (double)Math.max(0.0f, position));
            float segmentWidth = Math.min(position + segmentSize, dist) - position;
            if (position > -segmentSize) {
                if (position < 0.0f) {
                    segmentWidth += position;
                }
                batch.draw(Draw.getSq(), drawX, drawY, 0.0f, 0.5f, 1.0f, 1.0f, segmentWidth, width, (float)Math.toDegrees(radians));
            }
            position += gapSize + segmentSize;
        }
    }

    public static float rad2deg(float rad) {
        return (float)((double)(rad * 180.0f) / Math.PI);
    }

    public static TextureRegion getSq() {
        if (wSq == null) {
            wSq = ImageUtils.loadExt("junk/misc/pixel");
        }
        return wSq;
    }

    public static Pixmap getPixmap(Texture t) {
        t.getTextureData().prepare();
        return t.getTextureData().consumePixmap();
    }

    public static Pixmap getPixmap(TextureRegion t) {
        return Draw.getPixmap(t.getTexture());
    }

    public static void drawSize(Batch batch, TextureRegion textureRegion, float x, float y, float width, float height) {
        batch.draw(textureRegion, x, y, 0.0f, 0.0f, textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), width / (float)textureRegion.getRegionWidth(), height / (float)textureRegion.getRegionHeight(), 0.0f);
    }

    public static void drawSizeCentered(Batch batch, TextureRegion textureRegion, float x, float y, float width, float height) {
        Draw.drawCenteredScaled(batch, textureRegion, x, y, width / (float)textureRegion.getRegionWidth(), height / (float)textureRegion.getRegionHeight());
    }

    public static void fillActor(Batch batch, Actor a, Color col) {
        batch.setColor(col);
        Draw.fillActor(batch, a);
    }

    public static void fillActor(Batch batch, Actor a, Color col, int allOffset) {
        batch.setColor(col);
        Draw.fillRectangle(batch, (int)a.getX() + allOffset, (int)a.getY() + allOffset, a.getWidth() - (float)(allOffset * 2), a.getHeight() - (float)(allOffset * 2));
    }

    public static void fillActor(Batch batch, Actor a) {
        Draw.fillRectangle(batch, (int)a.getX(), (int)a.getY(), a.getWidth(), a.getHeight());
    }

    public static void fillActor(Batch batch, Actor a, int border) {
        Draw.fillRectangle(batch, (int)a.getX() + border, (int)a.getY() + border, a.getWidth() - (float)(border * 2), a.getHeight() - (float)(border * 2));
    }

    public static void borderActor(Batch batch, Actor a) {
        Draw.drawRectangle(batch, a.getX(), a.getY(), a.getWidth(), a.getHeight(), 1);
    }

    public static void fillActor(Batch batch, Actor a, Color bg, Color border, int borderSize) {
        Draw.fillRectangle(batch, a.getX(), a.getY(), a.getWidth(), a.getHeight(), bg, border, borderSize);
    }

    public static void fillActor(Batch batch, Actor a, Color bg, Color border) {
        Draw.fillRectangle(batch, a.getX(), a.getY(), a.getWidth(), a.getHeight(), bg, border, 1);
    }

    public static void fillActor(Batch batch, Actor a, Color bg, Color border, int borderSize, boolean pix) {
        if (!pix) {
            Draw.fillActor(batch, a, bg, border, borderSize);
            return;
        }
        Draw.fillRectangle(batch, (int)a.getX(), (int)a.getY(), (int)a.getWidth(), (int)a.getHeight(), bg, border, borderSize);
    }

    public static void drawArrow(Batch batch, float x, float y, float x1, float y1, int width) {
        Draw.drawLine(batch, x, y, x1, y1, width);
        double angle = Math.atan2(y1 - y, x1 - x);
        int angleDiff = -40;
        int dist = 20;
        double angle1 = angle + (double)angleDiff;
        double angle2 = angle - (double)angleDiff;
        Draw.drawLine(batch, x1, y1, x1 + (float)(Math.cos(angle1) * (double)dist), y1 + (float)(Math.sin(angle1) * (double)dist), width);
        Draw.drawLine(batch, x1, y1, x1 + (float)(Math.cos(angle2) * (double)dist), y1 + (float)(Math.sin(angle2) * (double)dist), width);
    }

    public static void drawLoadingAnimation(Batch batch, float x, float y, float radius, float size, float speed, int numDots) {
        for (int i = 0; i < numDots; ++i) {
            double angle = Math.PI * 2 / (double)numDots * (double)i;
            float drawX = (float)((double)x + Math.sin(angle += (double)(Main.secs * speed)) * (double)radius);
            float drawY = (float)((double)y + Math.cos(angle) * (double)radius);
            Draw.fillEllipse(batch, drawX - size / 2.0f, drawY - size / 2.0f, size, size);
        }
    }

    public static void fillArc(Batch batch, float x, float y, int radius, float startRadians, float endRadians) {
        String key = radius + ":" + startRadians + ":" + endRadians;
        Texture t = arcs.get(key);
        if (t == null) {
            Pixmap p = new Pixmap(radius * 2, radius * 2, Pixmap.Format.RGBA8888);
            p.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            for (int pX = -radius; pX < radius; ++pX) {
                for (int pY = -radius; pY < radius; ++pY) {
                    double angle;
                    float dist = Maths.dist(pX, pY);
                    if (dist > (float)radius || !Draw.is_angle_between((float)(angle = Math.atan2(pY, pX)), startRadians + (float)Math.PI, endRadians + (float)Math.PI)) continue;
                    p.drawPixel(pX + radius, pY + radius);
                }
            }
            t = new Texture(p);
            arcs.put(key, t);
        }
        batch.draw(t, x - (float)radius, y - (float)radius);
    }

    static boolean is_angle_between(float x, float a, float b) {
        b = Draw.modN(b - a);
        x = Draw.modN(x - a);
        if (b < (float)Math.PI) {
            return x < b;
        }
        return b < x;
    }

    static float modN(float x) {
        float m = x % ((float)Math.PI * 2);
        if (m < 0.0f) {
            m += (float)Math.PI * 2;
        }
        return m;
    }

    public static void setAlpha(Batch batch, float alpha) {
        batch.setColor(Colours.withAlpha(batch.getColor(), alpha));
    }

    public static void drawTriangle(Batch batch, float x0, float y0, float x1, float y1, float x2, float y2) {
        float colorBits;
        if (triangle == null) {
            triangle = new float[]{0.0f, 0.0f, 0.0f, Draw.getSq().getU(), Draw.getSq().getV2(), 0.0f, 0.0f, 0.0f, Draw.getSq().getU(), Draw.getSq().getV(), 0.0f, 0.0f, 0.0f, Draw.getSq().getU2(), Draw.getSq().getV(), 0.0f, 0.0f, 0.0f, Draw.getSq().getU2(), Draw.getSq().getV2()};
        }
        if ((colorBits = batch.getPackedColor()) != triangle[2]) {
            for (int i = 0; i < 4; ++i) {
                Draw.triangle[i * 5 + 2] = colorBits;
            }
        }
        Draw.triangle[0] = x0;
        Draw.triangle[1] = y0;
        Draw.triangle[5] = x1;
        Draw.triangle[6] = y1;
        Draw.triangle[10] = x2;
        Draw.triangle[11] = y2;
        Draw.triangle[15] = x2;
        Draw.triangle[16] = y2;
        batch.draw(Draw.getSq().getTexture(), triangle, 0, 20);
    }

    public static float getScale(TextureRegion tr, int width, int height) {
        float trWidth = tr.getRegionWidth();
        float trHeight = tr.getRegionHeight();
        return Math.max((float)width / trWidth, (float)height / trHeight);
    }

    public static float getScale(Texture t, int width, int height) {
        float trWidth = t.getWidth();
        float trHeight = t.getHeight();
        return Math.min((float)width / trWidth, (float)height / trHeight);
    }

    public static void scaleRegion(Batch batch, Texture tr, int x, int y, int width, int height) {
        float trWidth = tr.getWidth();
        float trHeight = tr.getHeight();
        float scale = Draw.getScale(tr, width, height);
        Draw.drawScaled(batch, tr, (float)((int)((float)x + ((float)width - trWidth * scale) / 2.0f)), (float)y, scale, scale);
    }

    public static void scaleRegion(Batch batch, TextureRegion tr, int x, int y, int width, int height) {
        float trWidth = tr.getRegionWidth();
        float trHeight = tr.getRegionHeight();
        float scale = Draw.getScale(tr, width, height);
        Draw.drawScaled(batch, tr, (float)((int)((float)x + ((float)width - trWidth * scale) / 2.0f)), (float)y, scale, scale);
    }

    public static void pixel(Batch batch, int x, int y) {
        Draw.draw(batch, Draw.getSq(), (float)x, (float)y);
    }

    static {
        arcs = new HashMap<String, Texture>();
    }
}

