/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.group.PartyLayoutType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.trigger.global.heroLevelupAffect.HeroGenType;
import com.tann.dice.test.util.Test;
import com.tann.dice.util.Tann;
import java.util.ArrayList;

public class TestParty {
    @Test
    public static void noDuplicateHeroes() {
        int attempts = 50;
        for (int i = 0; i < 50; ++i) {
            Party p = Party.generate(1, HeroGenType.Normal, PartyLayoutType.Force, new ArrayList<HeroType>());
            ArrayList<HeroType> types = new ArrayList<HeroType>();
            for (Hero hero : p.getHeroes()) {
                types.add(hero.getHeroType());
            }
            ArrayList unDupe = new ArrayList(types);
            Tann.uniquify(unDupe);
            Tann.assertEquals("Both should have 5 heroes: " + types, types.size(), unDupe.size());
        }
    }

    @Test
    public static void partyLayoutsValid() {
        int attempts = 10;
        ArrayList<PartyLayoutType> fails = new ArrayList<PartyLayoutType>();
        for (PartyLayoutType value : PartyLayoutType.values()) {
            if (value.isLockedMeta()) continue;
            for (int i = 0; i < 10; ++i) {
                Party p = Party.generate(1, HeroGenType.Normal, value, new ArrayList<HeroType>());
                for (Hero hero : p.getHeroes()) {
                    if (!hero.isMissingno()) continue;
                    fails.add(value);
                }
            }
        }
        Tann.assertTrue("Should be no fails: " + fails, fails.isEmpty());
    }
}

