/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.splashScreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

public class SplashDraw {
    Texture loading = new Texture("splash/loading.png");
    Texture resolution = new Texture("splash/resolution.png");
    Texture px = new Texture("splash/darkpx.png");
    SpriteBatch spriteBatch = new SpriteBatch();

    public void draw(SplashType type) {
        this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.spriteBatch.begin();
        Texture splash = type == SplashType.Loading ? this.loading : this.resolution;
        float scale = Math.min(Gdx.graphics.getWidth() / splash.getWidth(), Gdx.graphics.getHeight() / splash.getHeight());
        scale = Math.max(scale, 1.0f);
        float width = (float)splash.getWidth() * scale;
        float height = (float)splash.getHeight() * scale;
        this.spriteBatch.draw(this.px, 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.spriteBatch.draw(splash, (float)((int)((float)Gdx.graphics.getWidth() - width) / 2), (float)((int)((float)Gdx.graphics.getHeight() - height) / 2), width, height);
        this.spriteBatch.end();
    }

    public static enum SplashType {
        Loading,
        InvalidResolution;

    }
}

