/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.views;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.book.views.EntityLedgerView;
import com.tann.dice.screens.dungeon.panels.book.views.HeroLedgerView;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;

public class MonsterLedgerView
extends EntityLedgerView {
    private final MonsterType type;

    public MonsterLedgerView(MonsterType type, boolean hidden) {
        this.type = type;
        this.setTransform(false);
        switch (type.size) {
            case small: {
                this.setSize(26.0f, 20.0f);
                break;
            }
            case reg: {
                this.setSize(30.0f, 28.0f);
                break;
            }
            case big: {
                this.setSize(35.0f, 35.0f);
                break;
            }
            case huge: {
                this.setSize(70.0f, 70.0f);
            }
        }
        TextureRegion tr = type.portrait;
        if (UnUtil.isLocked(type)) {
            tr = Images.padlock;
        }
        ImageActor ia = new ImageActor(tr);
        ia.setXFlipped(true);
        ImageActor a = ia;
        this.addActor(a);
        Tann.center(a);
        this.setTransform(false);
        if (hidden && !UnUtil.isLocked(type)) {
            HeroLedgerView.addUnencountered(this);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Draw.fillActor(batch, this, Colours.dark, Colours.purple, 1);
        super.draw(batch, parentAlpha);
    }

    @Override
    public EntityLedgerView basicListener() {
        this.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                DiePanel dp = new DiePanel(MonsterLedgerView.this.type.makeEnt());
                Sounds.playSound(Sounds.pip);
                Main.getCurrentScreen().push(dp, 0.0f);
                Tann.center(dp);
                return true;
            }
        });
        return this;
    }
}

