/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.tann.dice.Main;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.book.TopTab;
import com.tann.dice.screens.dungeon.panels.book.page.BookPage;
import com.tann.dice.screens.dungeon.panels.book.sidebar.SideBar;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.KeyListen;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.PostPop;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Book
extends Group
implements PostPop,
KeyListen,
ExplanelReposition {
    public static final Color BOOK_COL = Colours.purple;
    private static final int MAIN_SECTION_BUTTON_WIDTH_LANDSCAPE = 45;
    private static final int LEFT_BORDER_WIDTH = 0;
    private static final int TT_HEIGHT = 16;
    private static final int TOP_BORDER_HEIGHT = 0;
    private static final int BOTTOM_BORDER_HEIGHT = 1;
    private static final int OUTER_BORDER = 20;
    List<BookPage> pages = new ArrayList<BookPage>();
    SideBar sideBar;
    BookPage focused;

    public Book() {
        this.setTransform(false);
        int ALMANAC_WIDTH = Main.width - 40;
        int ALMANAC_HEIGHT = Main.height - 40;
        if (Main.isPortrait()) {
            ALMANAC_WIDTH = Main.width - 6;
            ALMANAC_HEIGHT = (int)((float)Main.height * 0.74f);
        }
        this.setSize(ALMANAC_WIDTH, ALMANAC_HEIGHT);
        Map<String, Stat> allMergedStats = Main.self().masterStats.createMergedStats();
        this.pages.addAll(BookPage.getAll(allMergedStats, ALMANAC_WIDTH - 0, ALMANAC_HEIGHT - 0 - 1));
        Pixl p = new Pixl(0);
        this.sideBar = new SideBar();
        for (int i = 0; i < this.pages.size(); ++i) {
            final BookPage page = this.pages.get(i);
            TopTab tt = page.makeTopTab();
            tt.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Sounds.playSound(Sounds.pipSmall);
                    Book.this.focusPage(page);
                    return true;
                }
            });
            int width = Main.isPortrait() ? (int)this.getWidth() : 45;
            tt.setSize(width, 16.0f);
            this.sideBar.addItem(tt);
        }
        if (Main.isPortrait()) {
            this.sideBar.layoutHori((int)this.getWidth(), Book.getMainTitlesHeight());
        } else {
            this.sideBar.layoutVerti(Book.getMainTitlesHeight() + 2);
        }
        this.addActor(this.sideBar);
        this.sideBar.setY(this.getHeight() - this.sideBar.getHeight());
        Group topBorder = p.pix();
        this.addActor(topBorder);
        topBorder.setY(this.getHeight() - topBorder.getHeight());
        BookPage bp = this.getRecommendedDefaultPage();
        if (bp == null) {
            this.focusPage(this.pages.get(0));
        } else {
            this.focusPage(bp, Book.getSavedItemString());
        }
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.cancel();
                return true;
            }
        });
    }

    public static int getMainTitlesHeight() {
        if (Main.isPortrait()) {
            return 28;
        }
        return (int)((float)Main.height * 0.32f);
    }

    private static String getSavedItemString() {
        String focus = Main.getSettings().getLastAlmanacPage();
        if (focus != null && focus.contains("-")) {
            return focus.split("-")[1];
        }
        return null;
    }

    private static String getSavedPageString() {
        String focus = Main.getSettings().getLastAlmanacPage();
        if (focus != null && focus.contains("-")) {
            return focus.split("-")[0];
        }
        return null;
    }

    public static boolean inBook() {
        return Tann.findByClass(Main.stage, Book.class) != null;
    }

    private BookPage getRecommendedDefaultPage() {
        String focus = Book.getSavedPageString();
        if (focus != null) {
            return this.getPage(focus);
        }
        return null;
    }

    private BookPage getPage(String name) {
        for (BookPage page : this.pages) {
            if (!page.title.toLowerCase().contains(name)) continue;
            return page;
        }
        return null;
    }

    public void focusPage(BookPage page) {
        this.focusPage(page, null);
    }

    public void focusPage(BookPage page, String defaultSidebar) {
        if (this.focused != null) {
            this.focused.remove();
            this.focused = null;
        }
        this.focused = page;
        this.addActor(page);
        page.setY(1.0f);
        if (!Main.isPortrait()) {
            page.setX(0.0f);
        }
        this.sideBar.highlightAssoc(page);
        Main.stage.setScrollFocus(page);
        page.onFocus(defaultSidebar);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Draw.fillActor(batch, this, Colours.dark, BOOK_COL, 1);
        SideBar exsb = this.pages.get(0).getSideBar();
        exsb = this.focused.getSideBar();
        if (Main.isPortrait()) {
            int yy = (int)exsb.getY() + 1;
            int hh = (int)exsb.getHeight();
            Draw.fillRectangle(batch, this.getX(), this.getY() + (float)yy, this.sideBar.getWidth(), hh, Colours.dark, BOOK_COL, 1);
        } else {
            Draw.fillRectangle(batch, this.getX(), this.getY(), this.sideBar.getWidth(), this.getHeight(), Colours.dark, BOOK_COL, 1);
            int ry = (int)(this.getHeight() - exsb.getY() - exsb.getHeight());
            int uy = (int)this.sideBar.getHeight();
            int amt = ry - uy - 1;
            if (amt > 0) {
                int yy = (int)(this.getY() + exsb.getHeight());
                batch.setColor(BOOK_COL);
                Draw.fillRectangle(batch, this.getX(), yy, exsb.getWidth(), amt);
            }
        }
        super.draw(batch, parentAlpha);
    }

    public static Actor makeAlmanacButton() {
        Actor almanacButton = DungeonUtils.makeBasicButton(Images.almanac);
        almanacButton.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Book.openBook(true);
                return true;
            }
        });
        return almanacButton;
    }

    public static void openBook(boolean manual) {
        Book.openBook(null, null, manual);
    }

    public static void openBook(String path) {
        String[] parts = path.split("-");
        if (parts.length != 2) {
            TannLog.error("Error opening book from path: " + path);
        }
        Book.openBook(parts[0], parts[1], true);
    }

    public String getPath() {
        return "menu/system";
    }

    public static void openBook(String pageName, String sidebar, boolean manual) {
        BookPage p;
        Main.getCurrentScreen().popAllMedium();
        if (manual) {
            Sounds.playSound(Sounds.pip);
        }
        Book a = new Book();
        if (pageName != null && (p = a.getPage(pageName)) != null) {
            a.focusPage(p, sidebar);
        }
        a.setPosition((int)((float)(Main.width / 2) - a.getWidth() / 2.0f), (int)((float)(Main.height / 2) - a.getHeight() / 2.0f));
        Main.getCurrentScreen().push(a, true, true, false, 0.6f);
    }

    @Override
    public void postPop() {
        boolean wasInMenu;
        boolean bl = wasInMenu = Tann.findByClass(Main.stage, DungeonUtils.CogTag.class) != null;
        if (wasInMenu) {
            DungeonUtils.showCogMenu();
        }
    }

    @Override
    public boolean keyPress(int keycode) {
        switch (keycode) {
            case 69: 
            case 70: 
            case 111: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void repositionExplanel(Explanel a) {
        a.setPosition((int)((float)(Main.width / 2) - a.getWidth() / 2.0f), (int)((float)(Main.height / 2) - a.getHeight() / 2.0f));
    }
}

