/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.Explanel;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.creative.WishMode;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.DieSidePanel;
import com.tann.dice.screens.dungeon.panels.Explanel.Explanel;
import com.tann.dice.screens.dungeon.panels.Explanel.InfoPanel;
import com.tann.dice.screens.dungeon.panels.Explanel.NetPanel;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.APIUtils;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ConcisePanel;
import com.tann.dice.screens.dungeon.panels.threeD.DieSpinner;
import com.tann.dice.screens.generalPanels.PartyManagementPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.AlternativePop;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.CopyButtonHolder;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.PostPop;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.Flasher;
import com.tann.dice.util.ui.Glowverlay;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.resolver.HeroTypeResolver;
import java.util.ArrayList;
import java.util.List;

public class DiePanel
extends InfoPanel
implements PostPop,
ExplanelReposition,
AlternativePop,
CopyButtonHolder {
    public Ent ent;
    Group hpWriter;
    NetPanel netPanel;
    Group explanelsGroup;
    final boolean showPassives;
    private static final int gap = 3;
    List<Actor> traitActors = new ArrayList<Actor>();
    Group portraitGroup;
    DieSpinner dieSpinner;
    private boolean dirty = false;
    boolean traitsVisible = true;

    public DiePanel(Ent ent) {
        this(ent, true);
    }

    public DiePanel(Ent ent, boolean showPassives) {
        this.showPassives = showPassives;
        this.ent = ent;
        this.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                boolean top;
                boolean bl = top = (double)(y / DiePanel.this.getHeight()) > 0.4;
                if (Main.getCurrentScreen().getTopPushedActor() instanceof Explanel) {
                    Main.getCurrentScreen().popSingleLight();
                    return true;
                }
                if (Main.getCurrentScreen().popAllLight()) {
                    Sounds.playSound(Sounds.pop);
                }
                return false;
            }
        });
        this.layout();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    public void layout() {
        DungeonScreen ds = DungeonScreen.get();
        this.layout(PartyManagementPanel.tinyPanels && ds != null && ds.partyManagementPanel != null && ds.partyManagementPanel.hasParent());
    }

    public void layout(boolean tiny) {
        this.dirty = false;
        this.traitActors.clear();
        this.clearChildren();
        EntState visualState = this.ent.getState(FightLog.Temporality.Visual);
        if (visualState == null) {
            visualState = this.ent.getBlankState();
        }
        if (this.ent.isPlayer() && this.ent.getSize() == EntSize.reg) {
            this.playerLayout(visualState, tiny);
        } else {
            this.monsterLayout(visualState);
        }
        int y = 0;
        ArrayList visualClasses = new ArrayList();
        ArrayList<String> visualDescriptions = new ArrayList<String>();
        for (Personal pt : visualState.getActiveTriggers()) {
            visualClasses.add(pt.getClass());
            visualDescriptions.add(pt.describeForTriggerPanel());
        }
        ArrayList<Actor> actors = new ArrayList<Actor>();
        if (this.showPassives) {
            List<Actor> tmp;
            List<Actor> potentialTraitActors = DiePanel.makeTraitActors((int)this.getWidth(), visualState, this.ent);
            if (Tann.totalHeight(potentialTraitActors) > 50 && Tann.totalHeight(tmp = DiePanel.makeTraitActors((int)Math.min((float)Main.width * 0.9f, this.getWidth() * 2.0f), visualState, this.ent)) < Tann.totalHeight(potentialTraitActors)) {
                potentialTraitActors = tmp;
            }
            this.traitActors.addAll(potentialTraitActors);
            actors.addAll(potentialTraitActors);
        }
        this.explanelsGroup = Tann.makeGroup();
        for (Actor a : actors) {
            this.explanelsGroup.addActor(a);
            y = (int)((float)y - (a.getHeight() - 1.0f));
            a.setPosition((int)(this.getWidth() / 2.0f - a.getWidth() / 2.0f), y);
        }
        this.addActor(this.explanelsGroup);
        this.updateTraitVisibility();
        if (OptionLib.shouldShowCopy()) {
            this.addCopyButton();
        }
    }

    @Override
    public void addCopyButton() {
        APIUtils.addCopyButton(this, this.ent.getName(false));
    }

    private static List<Actor> makeTraitActors(int width, EntState visualState, Ent ent) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (Personal t : ent.getEntPanel().getAllDescribableTriggers()) {
            if (!t.showInDiePanel()) continue;
            if (t.getTrait() == null) {
                Boolean incoming = Personal.treatAsIncoming(t, visualState.getActiveTriggers());
                if (incoming != null && incoming.booleanValue() && !t.showAsIncoming()) continue;
                Explanel e = new Explanel(t, ent, incoming, width);
                actors.add(e);
                continue;
            }
            if (!t.getTrait().visible) continue;
            Explanel e = new Explanel(t.getTrait(), ent, width);
            actors.add(e);
        }
        return actors;
    }

    public Actor getFullActor() {
        if (!this.traitsVisible || this.traitActors.size() == 0) {
            return this;
        }
        Pixl p = new Pixl(-1).actor(this);
        for (Actor a : this.traitActors) {
            p.row().actor(a);
        }
        return p.pix();
    }

    private void playerLayout(EntState visualState, boolean tiny) {
        int TEXT_HEIGHT = 10;
        int SPINNER_GAP = 4;
        this.setSize(tiny ? 71.0f : 96.0f, 61.0f);
        Rectactor.fill(this, this.ent.getColour());
        TextureRegion portrait = this.ent.getPortrait();
        int pWidth = 0;
        this.portraitGroup = new Pixl(1, 2).border(Colours.dark, this.ent.getColour(), 1).image(portrait).pix();
        this.addActor(this.portraitGroup);
        if (tiny) {
            this.portraitGroup.setPosition(this.getWidth() - this.portraitGroup.getWidth(), this.getHeight() - this.portraitGroup.getHeight());
        } else {
            this.portraitGroup.setPosition(0.0f, this.getHeight() - this.portraitGroup.getHeight());
            pWidth = (int)this.portraitGroup.getWidth();
        }
        if (DungeonScreen.isWish()) {
            this.addWishListener(this.portraitGroup);
        }
        TextWriter levelTag = DiePanel.makeLevelTag((Hero)this.ent);
        this.addActor(levelTag);
        levelTag.setPosition(pWidth - (tiny ? 0 : 1), this.getHeight() - 10.0f);
        int textOffset = (int)(levelTag.getWidth() - 1.0f);
        int textboxWidth = (int)(this.getWidth() - (float)pWidth + (float)(!tiny ? 1 : 0) - (float)textOffset);
        if (((Hero)this.ent).isDiedLastRound()) {
            ImageActor died = new ImageActor(Images.eq_skullWhite, Colours.withAlpha(Colours.grey, 0.6f).cpy());
            this.addActor(died);
            boolean skullGap = true;
            died.setPosition(levelTag.getX() + 1.0f + 1.0f, levelTag.getY() - died.getHeight() - 1.0f);
        }
        Group textBox = Tann.makeGroup(textboxWidth, 10);
        Rectactor.fill(textBox, this.ent.getColour());
        int hpw = tiny ? (int)(this.getWidth() - this.portraitGroup.getWidth() - levelTag.getWidth()) : this.getHpWidth();
        this.hpWriter = this.getTitle(DiePanel.getHpString(visualState, tiny), hpw, !tiny);
        textBox.addActor(this.hpWriter);
        Tann.center(this.hpWriter);
        if (tiny) {
            this.hpWriter.setX((int)(this.hpWriter.getX() - this.portraitGroup.getWidth() / 2.0f + 1.0f));
        }
        this.addActor(textBox);
        textBox.setPosition(this.getWidth() - (float)textboxWidth, this.getHeight() - textBox.getHeight());
        this.addNameChangeListener(textBox);
        if (!tiny) {
            float av = this.getHeight() - this.portraitGroup.getHeight() + 1.0f;
            this.dieSpinner = new DieSpinner(this.ent.getDie(), (float)this.ent.getSize().getPixels() * 1.5f);
            this.addActor(this.dieSpinner);
            this.dieSpinner.setPosition(4.0f, (int)(av / 2.0f - this.dieSpinner.getHeight() / 2.0f));
        }
        this.netPanel = new NetPanel(this.ent, false);
        this.addActor(this.netPanel);
        float hAv = this.getHeight() - textBox.getHeight() + 1.0f;
        this.netPanel.setPosition(tiny ? 5.0f : (float)((int)(this.dieSpinner.getX() + this.dieSpinner.getWidth() + 4.0f)), (int)(hAv / 2.0f - this.netPanel.getHeight() / 2.0f));
        if (tiny) {
            Group a;
            this.portraitGroup.setZIndex(textBox.getZIndex() + 1);
            String hps = DiePanel.getHpString(visualState, tiny);
            this.hpWriter = a = new Pixl(0, 3).border(this.ent.getColour()).text(hps).pix();
            a.setTouchable(Touchable.disabled);
            this.addActor(a);
            a.setX(this.getWidth() - a.getWidth());
            this.netPanel.toFront();
        }
    }

    private void addWishListener(final Group g) {
        g.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                if (!Tann.hasParent(g, PartyManagementPanel.class)) {
                    return false;
                }
                new HeroTypeResolver(){

                    @Override
                    public void resolve(HeroType heroType) {
                        if (heroType != null && !heroType.isMissingno()) {
                            DungeonScreen ds = DungeonScreen.get();
                            if (ds != null) {
                                Hero h = (Hero)DiePanel.this.ent;
                                h.levelUpTo(heroType, DungeonScreen.getCurrentContextIfInGame());
                                ds.save();
                                WishMode.makeWishSound();
                            }
                        } else {
                            Sounds.playSound(Sounds.error);
                        }
                    }
                }.activate(Mode.WISH.wishFor("levelup", Colours.yellow));
                return true;
            }
        });
    }

    private void addNameChangeListener(final Group g) {
        g.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                if (!Tann.hasParent(g, PartyManagementPanel.class)) {
                    return false;
                }
                Main.self().control.textInput(new Input.TextInputListener(){

                    @Override
                    public void input(String text) {
                        if (text == null || text.isEmpty()) {
                            return;
                        }
                        DungeonScreen ds = DungeonScreen.get();
                        if (ds != null) {
                            Hero h = (Hero)DiePanel.this.ent;
                            String safeText = text.replaceAll("[^a-zA-Z0-9 ]", "");
                            HeroType newHero = HeroTypeLib.byName(h.getName(false) + ".n." + safeText);
                            if (newHero.isMissingno()) {
                                return;
                            }
                            h.levelUpTo(newHero, null);
                            ds.save();
                        }
                    }

                    @Override
                    public void canceled() {
                    }
                }, "rename", null, null);
                return true;
            }
        });
    }

    private int getHpWidth() {
        int pnw;
        int bonus = 6;
        if (this.ent instanceof Hero) {
            bonus += (int)DiePanel.makeLevelTag((Hero)this.ent).getWidth();
        }
        switch (this.ent.getSize()) {
            case small: {
                pnw = 72;
                break;
            }
            case reg: {
                pnw = 94;
                break;
            }
            case big: {
                pnw = 91;
                break;
            }
            case huge: {
                pnw = 115;
                break;
            }
            default: {
                throw new RuntimeException("unset size: " + (Object)((Object)this.ent.getSize()));
            }
        }
        return pnw - this.ent.getPortrait().getRegionWidth() - bonus;
    }

    public static TextWriter makeLevelTag(Hero ent) {
        return DiePanel.makeLevelTag(ent.getLevel(), ent.getHeroCol().col);
    }

    public static TextWriter makeLevelTag(int tier, Color col) {
        String levelText = TextWriter.getTag(col) + Words.getTierString(tier);
        return new TextWriter(levelText, 999, col, 2);
    }

    private Group getTitle(String hpString, int width, boolean showHp) {
        TextWriter hp = new TextWriter(hpString);
        String text = this.ent.entType.getName(true, false);
        Actor left = ConcisePanel.makeTitle(text, this.ent.getColour(), (int)((float)width - (showHp ? hp.getWidth() : 0.0f)));
        int maxHpGap = 5;
        return new Pixl(0).actor(left).actor(showHp ? new Pixl().gap(Math.min(5, (int)((float)width - left.getWidth() - hp.getWidth()))).actor(hp) : null).pix();
    }

    private void monsterLayout(EntState visualState) {
        ImageActor portraitImage = new ImageActor(this.ent.getPortrait());
        portraitImage.setXFlipped(true);
        Group portrait = new Pixl(1, 2).border(Colours.dark, this.ent.getColour(), 1).actor(portraitImage).pix();
        Pixl p = new Pixl(3, 2);
        this.hpWriter = new Pixl().actor(this.getTitle(DiePanel.getHpString(visualState, false), this.getHpWidth(), true)).gap((int)portrait.getWidth()).pix();
        p.actor(this.hpWriter);
        p.row(4);
        if (this.ent.getSize() == EntSize.small || this.ent.getSize() == EntSize.reg) {
            this.dieSpinner = new DieSpinner(this.ent.getDie(), (float)this.ent.getSize().getPixels() * 1.5f);
            p.actor(this.dieSpinner);
        }
        this.netPanel = new NetPanel(this.ent, false);
        p.actor(this.netPanel);
        Tann.become(this, p.pix());
        Color c = this.ent.getColour();
        if (c == null) {
            c = Colours.pink;
        }
        Rectactor ra = new Rectactor((int)this.getWidth(), (int)this.hpWriter.getHeight() + 4, c);
        this.addActor(ra);
        ra.setY(this.getHeight() - ra.getHeight());
        this.setTransform(true);
        ra.toBack();
        this.addActor(portrait);
        portrait.setPosition(this.getWidth() - portrait.getWidth(), this.getHeight() - portrait.getHeight());
        portrait.setZIndex(ra.getZIndex() + 1);
        Rectactor.fill(this, c);
    }

    private static String getHpString(EntState visualState, boolean tiny) {
        if (tiny && visualState.getHp() >= 10) {
            return (visualState.isAtMaxHp() ? "[red]" : "[purple]") + visualState.getMaxHp();
        }
        if (visualState.isAtMaxHp()) {
            return "[red]" + visualState.getMaxHp();
        }
        return "[red]" + visualState.getHp() + "[grey][p]/[cu][purple][p]" + visualState.getMaxHp() + "[cu]";
    }

    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.dirty) {
            this.layout();
        }
        super.draw(batch, parentAlpha);
    }

    @Override
    public void postPop() {
        this.ent.getEntPanel().setArrowIntensity(0.0f, 0.0f);
    }

    @Override
    public void repositionExplanel(Explanel exp) {
        Vector2 pos = Tann.getAbsoluteCoordinates(this);
        if (pos.y - (float)exp.getFullHeight() < 0.0f) {
            exp.setPosition((int)((float)(Main.width / 2) - exp.getWidth() / 2.0f), (int)((float)(Main.height / 2) - exp.getHeight() / 2.0f));
            return;
        }
        switch (this.ent.getSize()) {
            case small: 
            case reg: {
                exp.getFullHeight();
                Vector2 local = Tann.getAbsoluteCoordinates(this);
                exp.setPosition((int)(local.x + this.getWidth() / 2.0f - exp.getWidth() / 2.0f), (int)(local.y - exp.getHeight() + 1.0f));
                break;
            }
            case big: 
            case huge: {
                exp.setPosition((int)((float)(Main.width / 2) - exp.getWidth() / 2.0f), (int)((float)(Main.height / 2) - exp.getHeight() / 2.0f));
            }
        }
    }

    @Override
    public boolean alternativePop() {
        if (!(Main.getCurrentScreen() instanceof DungeonScreen) || !DungeonScreen.checkActive(this.ent)) {
            this.withoutDice();
            return false;
        }
        this.clearActions();
        EntPanel ePan = this.ent.getEntPanel();
        Vector2 coord = Tann.getAbsoluteCoordinates(ePan);
        this.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.scaleTo(0.0f, 0.0f, 0.3f), (Action)Actions.moveTo(coord.x + (ePan.ent.isPlayer() ? ePan.getWidth() : 0.0f), coord.y + ePan.getHeight() / 2.0f, 0.3f)), (Action)Actions.removeActor()));
        return true;
    }

    public void flash(int prevMaxHp, int newMaxHp, int prevHp, int newHp, int[] prevHashes, int[] newHashes) {
        if (newMaxHp != prevMaxHp || prevHp != newHp) {
            this.flashHp();
        }
        for (int i = 0; i < prevHashes.length; ++i) {
            if (newHashes[i] == prevHashes[i]) continue;
            this.netPanel.flashSide(i);
        }
    }

    public void flashHp() {
        this.hpWriter.addActor(new Flasher(this.hpWriter, DieSidePanel.EQUIP_BONUS_FLASH_COLOUR, 0.4f));
    }

    public void show() {
        this.layout();
        Sounds.playSound(Sounds.pip);
        DiePanel pan = this.ent.getDiePanel();
        DungeonScreen.get().push(pan, false, true, false, 0.0f);
        pan.setScale(0.0f);
        EntPanel ePan = this.ent.getEntPanel();
        Vector2 coord = Tann.getAbsoluteCoordinates(ePan);
        pan.setPosition(coord.x + ePan.getWidth() * (this.ent.isPlayer() ? 0.8f : 0.2f), coord.y + ePan.getHeight() / 2.0f);
        float dur = 0.4f;
        Interpolation terp = Chrono.i;
        pan.clearActions();
        pan.addAction(Actions.parallel((Action)Actions.scaleTo(1.0f, 1.0f, dur * 0.8f, terp), (Action)Actions.moveTo(pan.getNiceX(), pan.getNiceY(), dur, terp)));
        this.ent.getEntPanel().setArrowIntensity(1.0f, 0.0f);
    }

    private void updateTraitVisibility() {
        for (Actor a : this.traitActors) {
            a.setVisible(this.traitsVisible);
        }
    }

    public void setTraitsVisible(boolean visible) {
        this.traitsVisible = visible;
        this.updateTraitVisibility();
    }

    public void addPortraitFlasher() {
        Glowverlay go = new Glowverlay(Colours.light);
        this.portraitGroup.toFront();
        this.portraitGroup.addActor(go);
    }

    public void removeDice() {
        if (this.dieSpinner != null) {
            this.dieSpinner.remove();
        }
    }

    public DiePanel withoutDice() {
        this.removeDice();
        return this;
    }
}

