/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.effect.targetable.Targetable;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.background.BackgroundHolder;
import com.tann.dice.screens.dungeon.panels.ReinforcementsPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.screens.shaderFx.DeathType;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.ui.Flasher;
import com.tann.dice.util.ui.action.PixAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntContainer
extends Group {
    public static final int width = 84;
    static final int BUTT_GAP = 2;
    private List<Ent> entities = new ArrayList<Ent>();
    private Map<Ent, Boolean> forwardsMap;
    private List<Monster> reinforcementsCache;
    boolean friendly;
    public static final int MARGIN = 2;
    final boolean cachedAv;
    final boolean cachedAvTop;
    boolean entitiesSetBefore;
    float nextRearrange = 0.0f;
    long lastTargetableHeld;
    long deathAnimFinish = 0L;
    boolean inPlace = true;
    Runnable inPlaceRunnable;

    public EntContainer(boolean friendly) {
        this.setTransform(false);
        this.friendly = friendly;
        float height = Main.height - DungeonScreen.getBottomButtonHeight() - 2;
        if (Main.isPortrait()) {
            height = (float)((double)height * 0.5);
        }
        this.cachedAv = OptionLib.GAP.c() > 0;
        boolean bl = this.cachedAvTop = OptionLib.GAP.c() == 2;
        if (!friendly && this.cachedAv) {
            height *= 0.75f;
        }
        this.setSize(84.0f, (int)height);
        this.setPosition(this.getPreferredX(), this.getPreferredY());
    }

    public float getPreferredX() {
        int extraGap = EntContainer.getPanelTuckback(this.friendly) * (this.friendly ? -1 : 1);
        return (this.friendly ? 2 + Main.self().notch(3) : Main.width - 84 - 2 - Main.self().notch(1)) + extraGap;
    }

    public float getPreferredY() {
        if (!this.friendly && this.cachedAv) {
            if (this.cachedAvTop) {
                return 0.0f;
            }
            return (float)Main.height - this.getHeight();
        }
        return DungeonScreen.getBottomButtonHeight() + 2;
    }

    public void slideIn(Vector2 dist, final Runnable after) {
        this.clearActions();
        dist.scl(1.0f / (float)Main.scale);
        this.setPosition(this.getPreferredX() + dist.x, this.getPreferredY() + dist.y);
        this.addAction(Actions.sequence(PixAction.moveTo((int)this.getPreferredX(), (int)this.getPreferredY(), BackgroundHolder.MOVE_SPEED, BackgroundHolder.MOVE_TERP), (Action)Actions.delay(0.05f)));
        if (after != null) {
            this.addAction(Actions.after(new RunnableAction(){

                @Override
                public void run() {
                    after.run();
                }
            }));
        }
    }

    public void slideAway() {
        Tann.slideAway(this, this.getSlideDir(), BulletStuff.getPanelSlideAmount() + 5, false);
    }

    private Tann.TannPosition getSlideDir() {
        return this.friendly ? Tann.TannPosition.Left : Tann.TannPosition.Right;
    }

    private void setupPreferredPositions(List<Ent> alive, boolean hasReinforcement) {
        float gap;
        float heightAvailable = this.getHeight();
        for (Ent de : alive) {
            heightAvailable -= de.getEntPanel().getHeight();
        }
        if (hasReinforcement) {
            heightAvailable -= (float)(TannFont.font.getHeight() + 4);
        }
        float currentY = gap = heightAvailable / (float)(alive.size() + 1 + (hasReinforcement ? 1 : 0));
        for (int i = alive.size() - 1; i >= 0; --i) {
            Ent de = alive.get(i);
            EntPanel panel = de.getEntPanel();
            panel.setMargin(gap / 2.0f - 3.0f);
            panel.setPreferredY((int)currentY);
            currentY += gap;
            currentY += panel.getHeight();
        }
    }

    private void rearrangeEntities(boolean setup, List<Monster> reinforcements) {
        ArrayList<Ent> alive = new ArrayList<Ent>();
        for (Ent de : this.entities) {
            if (de.getState(FightLog.Temporality.Visual).isDead()) continue;
            alive.add(de);
        }
        this.setupPreferredPositions(alive, reinforcements.size() > 0);
        if (this.nextRearrange > 0.0f) {
            return;
        }
        float TARGETABLE_HOLD_DURATION = 0.1f;
        float timeSinceHeld = (float)(System.currentTimeMillis() - this.lastTargetableHeld) / 1000.0f;
        if (timeSinceHeld < 0.1f) {
            this.nextRearrange = 0.1f - timeSinceHeld;
            return;
        }
        this.clearChildren();
        float duration = setup ? 0.0f : 0.25f;
        for (int i = 0; i < alive.size(); ++i) {
            Ent de = (Ent)alive.get(i);
            EntPanel panel = de.getEntPanel();
            this.addActor(panel);
            if (de.isPlayer()) {
                panel.clearActions();
            }
            panel.addAction(PixAction.moveTo((int)panel.getPreferredX(), (int)panel.getPreferredY(), duration, Chrono.i));
        }
        for (Ent de : alive) {
            Ent summoner = de.getSummonedBy();
            if (summoner == null) continue;
            EntPanel panel = de.getEntPanel();
            panel.toBack();
            EntPanel summonerPanel = summoner.getEntPanel();
            panel.setPosition(summonerPanel.getX(), summonerPanel.getY());
            de.setSummonedBy(null);
        }
        if (reinforcements.size() > 0) {
            Group reinforcementsPanel = ReinforcementsPanel.makePanel(reinforcements.size());
            this.addActor(reinforcementsPanel);
            int x = (int)(this.getWidth() / 2.0f - reinforcementsPanel.getWidth() / 2.0f);
            reinforcementsPanel.setPosition(x, this.getHeight() - reinforcementsPanel.getHeight() - 1.0f);
            if (this.reinforcementsCache != null && this.reinforcementsCache.size() > 0 && reinforcements.size() != this.reinforcementsCache.size()) {
                reinforcementsPanel.addActor(new Flasher(reinforcementsPanel, Colours.light));
            }
        }
    }

    public void setEntities(Snapshot snapshot, List<? extends Ent> entities, List<Monster> reinforcements) {
        Map<Ent, Boolean> newForwards = this.getForwardMap(snapshot, entities);
        if (this.entities.equals(entities) && newForwards.equals(this.forwardsMap) && this.reinforcementsCache.equals(reinforcements)) {
            return;
        }
        for (Monster m : reinforcements) {
            m.setSummonedBy(null);
        }
        List<Ent> newlyDead = null;
        if (this.forwardsMap != null) {
            newlyDead = this.getNewlyDead(this.forwardsMap, newForwards);
            newlyDead.removeAll(reinforcements);
        }
        this.forwardsMap = newForwards;
        this.reinforcementsCache = reinforcements;
        this.entities.clear();
        this.entities.addAll(entities);
        if (newlyDead != null && newlyDead.size() > 0) {
            this.deathAnimation(newlyDead, snapshot);
        } else {
            this.rearrangeEntities(!this.entitiesSetBefore, reinforcements);
        }
        this.entitiesSetBefore = true;
    }

    @Override
    public void act(float delta) {
        Targetable t;
        if (DungeonScreen.get().targetingManager.getSelectedTargetable() != null && !(t = DungeonScreen.get().targetingManager.getSelectedTargetable()).getDerivedEffects().isFriendly()) {
            this.lastTargetableHeld = System.currentTimeMillis();
        }
        if (this.nextRearrange > 0.0f) {
            this.nextRearrange -= delta;
            if (this.nextRearrange <= 0.0f) {
                this.rearrangeEntities(false, this.reinforcementsCache);
            }
        }
        super.act(delta);
    }

    private void deathAnimation(List<Ent> newlyDead, Snapshot snapshot) {
        for (Ent de : newlyDead) {
            EntState es = snapshot.getState(de);
            DeathType dt = DeathType.Alpha;
            if (es != null) {
                dt = es.getDeathType();
            }
            float time = dt.activate(de.getEntPanel());
            this.nextRearrange = Math.max(this.nextRearrange, time);
            this.deathAnimFinish = Math.max(this.deathAnimFinish, System.currentTimeMillis() + (long)(time * 1000.0f));
        }
    }

    private List<Ent> getNewlyDead(Map<Ent, Boolean> forwardsMap, Map<Ent, Boolean> newForwards) {
        ArrayList<Ent> result = new ArrayList<Ent>();
        for (Ent de : forwardsMap.keySet()) {
            if (forwardsMap.get(de) == null || newForwards.get(de) != null) continue;
            result.add(de);
        }
        return result;
    }

    private Map<Ent, Boolean> getForwardMap(Snapshot snapshot, List<? extends Ent> entities) {
        HashMap<Ent, Boolean> results = new HashMap<Ent, Boolean>();
        for (Ent ent : entities) {
            EntState visual = snapshot.getState(ent);
            if (visual.isDead()) {
                results.put(ent, null);
                continue;
            }
            results.put(ent, visual.isForwards() && ent.getFightLog().anyHidingVisual() && entities.size() > 0);
        }
        return results;
    }

    public List<Ent> getEntities() {
        return this.entities;
    }

    public void assumeHoldsDie() {
        for (Ent de : this.getEntities()) {
            de.getDie().flatDraw = true;
            de.getEntPanel().holdsDie = true;
        }
    }

    public void setInPlace(boolean inPlace) {
        this.inPlace = inPlace;
        if (inPlace && this.inPlaceRunnable != null) {
            this.inPlaceRunnable.run();
            this.inPlaceRunnable = null;
        }
    }

    public boolean inPlace() {
        return this.inPlace;
    }

    public void afterInPlace(Runnable runnable) {
        if (this.inPlace()) {
            runnable.run();
        } else {
            this.inPlaceRunnable = runnable;
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        float px = this.getX();
        float py = this.getY();
        this.setPosition((int)Math.ceil(px), (int)Math.ceil(py));
        super.draw(batch, parentAlpha);
        this.setPosition(px, py);
    }

    public void clearAfterInPlace() {
        this.inPlaceRunnable = null;
    }

    public boolean anyDeathAnimationsOngoing() {
        return System.currentTimeMillis() < this.deathAnimFinish;
    }

    public static int getPanelTuckback(boolean friendly) {
        int extraGap = 22;
        int remainder = (int)((float)Main.width - 168.0f - (float)extraGap);
        int result = Math.max(0, -remainder / 2);
        float friendlyAmt = 0.8f;
        if (friendly) {
            return (int)((float)result * friendlyAmt);
        }
        return (int)((float)result * (2.0f - friendlyAmt));
    }
}

