/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.background;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.screens.debugScreen.TransSection;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.background.PortBoard;
import com.tann.dice.screens.dungeon.panels.EntContainer;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BackgroundHolder
extends Group {
    public static float MOVE_SPEED = 2.0f;
    public static Interpolation MOVE_TERP = Interpolation.smooth;
    List<Actor> backgroundActors = new ArrayList<Actor>();
    private static int SCR_W = Gdx.graphics.getWidth();
    boolean skipProgress;
    static TextureRegion override = ImageUtils.loadExtBig("dungeon/tiling/missingno");
    int index = 0;
    Map<Integer, Vector2> indexPositions = new HashMap<Integer, Vector2>();
    int currentX;
    int setupIndex = 0;

    public BackgroundHolder() {
        this.setTransform(false);
    }

    public static int getHFull() {
        if (Main.isPortrait()) {
            EntContainer a = DungeonScreen.get().enemy;
            return (int)((a.getY() + a.getHeight()) * (float)Main.scale);
        }
        return Gdx.graphics.getHeight();
    }

    public void populate(List<TP<Zone, Integer>> levelTypes) {
        this.skipProgress = ((Zone)((Object)levelTypes.get((int)0).a)).validMonsters.size() == 0;
        SCR_W = Gdx.graphics.getWidth();
        this.indexPositions.clear();
        Zone first = (Zone)((Object)levelTypes.get((int)0).a);
        Zone last = (Zone)((Object)levelTypes.get((int)(levelTypes.size() - 1)).a);
        this.backFill(first);
        for (int i = 0; i < levelTypes.size(); ++i) {
            Zone t = (Zone)((Object)levelTypes.get((int)i).a);
            int numLevels = (Integer)levelTypes.get((int)i).b;
            this.populate(t, numLevels);
            if (i >= levelTypes.size() - 1) continue;
            this.addTransition(t, (Zone)((Object)levelTypes.get((int)(i + 1)).a));
        }
        this.addSectionImage(BackgroundHolder.getImage(last, -1));
    }

    private static TextureRegion getImage(Zone type, int offset) {
        DungeonScreen ds = DungeonScreen.get();
        if (ds == null) {
            return override;
        }
        int seed = ds.getDungeonContext().getSeed();
        Random r = Tann.makeStdRandom(seed += type.index);
        List<TextureRegion> bs = type.background;
        if (bs.isEmpty()) {
            return Images.qmark;
        }
        if (bs.size() == 1 || offset == -1) {
            return bs.get(0);
        }
        int chosenForOne = r.nextInt(3);
        if (chosenForOne == offset) {
            return bs.get(1);
        }
        if (bs.size() > 2) {
            boolean higher;
            boolean bl = higher = offset == 2 || offset == 1 && chosenForOne == 2;
            if (higher ^ r.nextBoolean()) {
                return bs.get(2);
            }
        }
        return bs.get(0);
    }

    private void backFill(Zone type) {
        int backFillX = SCR_W;
        while (backFillX > 0) {
            TextureRegion tr = BackgroundHolder.getImage(type, -1);
            backFillX = (int)((float)backFillX - BackgroundHolder.getWidth(tr));
            Image image = new Image(tr);
            this.backgroundActors.add(image);
            image.setSize(BackgroundHolder.getWidth(tr), BackgroundHolder.getHeight(tr));
            image.setPosition(backFillX, this.getImageY());
            this.addActor(image);
        }
        this.currentX = SCR_W;
    }

    private int getImageY() {
        return 0;
    }

    private static float getWidth(TextureRegion tr) {
        int regionHeight = tr.getRegionHeight();
        float scaledHeight = BackgroundHolder.getHFull();
        float scale = scaledHeight / (float)regionHeight;
        float scaledWidth = (float)tr.getRegionWidth() * scale;
        return (float)Math.ceil(scaledWidth);
    }

    private static float getHeight(TextureRegion tr) {
        return BackgroundHolder.getHFull();
    }

    private void populate(Zone type, int numLevels) {
        int counter = 0;
        for (int i = 0; i < numLevels - 1; ++i) {
            this.addSectionImage(BackgroundHolder.getImage(type, counter++));
        }
    }

    private void addTransition(Zone prev, Zone next) {
        TextureRegion tr = prev.getTransition(next);
        if (tr != null) {
            this.addSectionImage(tr);
        } else {
            TransSection ts = new TransSection(BackgroundHolder.getImage(prev, 0), BackgroundHolder.getImage(next, 0));
            ts.setSize(BackgroundHolder.getWidth(BackgroundHolder.getImage(prev, 0)), BackgroundHolder.getHeight(BackgroundHolder.getImage(next, 0)));
            this.addSection(ts);
        }
    }

    public Vector2 progress() {
        ++this.index;
        this.index %= this.indexPositions.size();
        Vector2 previousPos = this.index == 0 ? new Vector2(0.0f, 0.0f) : this.indexPositions.get(this.index - 1);
        Vector2 nextPos = this.indexPositions.get(this.index);
        if (!this.skipProgress) {
            this.addAction(Actions.moveTo(nextPos.x, nextPos.y, MOVE_SPEED, MOVE_TERP));
        }
        return previousPos.cpy().sub(nextPos);
    }

    public void setStartIndex(int currentLevelNumber) {
        this.index = currentLevelNumber % this.indexPositions.size();
        if (this.index >= 0) {
            Vector2 pos = this.indexPositions.get(this.index);
            this.setPosition(pos.x, pos.y);
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        for (int index = 0; index < this.backgroundActors.size(); ++index) {
            Actor i = this.backgroundActors.get(index);
            float imageX = this.getX() + i.getX();
            i.setVisible(imageX + i.getWidth() >= 0.0f && imageX <= (float)SCR_W);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Main.self().stop2d(true);
        SpriteBatch batch1 = Main.self().startBackground();
        float posX = this.getX();
        float posY = this.getY();
        int intX = (int)(this.getX() / (float)Main.scale) * Main.scale;
        int intY = (int)(this.getY() / (float)Main.scale) * Main.scale;
        this.setPosition(intX, intY);
        super.draw(batch1, parentAlpha);
        PortBoard.drawTopIfNecessary(batch1);
        this.setPosition(posX, posY);
        batch1.setColor(Colours.dark);
        Draw.fillRectangle(batch1, Main.width * Main.scale, 0.0f, 10.0f, Gdx.graphics.getHeight());
        DungeonScreen.drawVersionPixel(batch1);
        Main.self().stopBackground();
        Main.self().start2d(true);
    }

    private void addSectionImage(TextureRegion tr) {
        Image image = new Image(tr);
        image.setSize(BackgroundHolder.getWidth(tr), BackgroundHolder.getHeight(tr));
        this.addSection(image);
    }

    private void addSection(Actor image) {
        this.addActor(image);
        this.backgroundActors.add(image);
        image.setPosition(this.currentX, this.getImageY());
        this.indexPositions.put(this.setupIndex, new Vector2((int)((float)(-this.currentX + SCR_W) - image.getWidth()), 0.0f));
        ++this.setupIndex;
        this.currentX = (int)((float)this.currentX + image.getWidth());
    }
}

