/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.affectSideModular.effect;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.EffectDraw;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AffectSideEffect;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import java.util.List;

public class BonusForIdentical
extends AffectSideEffect {
    final int bonus = 1;

    @Override
    public String describe() {
        return "Weird wording...";
    }

    @Override
    public String getOverrideDescription(List<AffectSideCondition> conditions, List<AffectSideEffect> effects) {
        return "All sides get " + Tann.delta(1) + " for each other identical side";
    }

    @Override
    public boolean needsGraphic() {
        return true;
    }

    @Override
    public EffectDraw getAddDraw(boolean hasSideImage, List<AffectSideCondition> conditions) {
        return new EffectDraw(){

            @Override
            public void draw(Batch batch, int x, int y, int index) {
                float mid = 8.5f;
                batch.setColor(Colours.blue);
                for (int i = 0; i < 2; ++i) {
                    float add = (float)(i * 2 - 1) * 2.5f;
                    float yAdd = add / 2.0f;
                    Draw.drawCentered(batch, Images.plusBig, (float)x + 8.5f + add, (float)y + 8.5f + yAdd);
                }
            }
        };
    }

    @Override
    public void affect(EntSideState sideState, EntState owner, int index, AffectSides sourceTrigger, int sourceIndex) {
        Eff myEff = sideState.getCalculatedEffect();
        if (!myEff.hasValue()) {
            return;
        }
        int myHash = myEff.hashEff();
        int numDupes = 0;
        for (EntSide es : owner.getEnt().getSides()) {
            EntSideState ess;
            if (es == sideState.getOriginal() || (ess = new EntSideState(owner, es, sourceIndex)).getCalculatedEffect().hashEff() != myHash) continue;
            ++numDupes;
        }
        if (numDupes == 0) {
            return;
        }
        int newValue = myEff.getValue() + numDupes;
        myEff.setValue(newValue);
    }
}

