/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.pool.item;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class GlobalExtraItemPool
extends Global {
    private final List<Item> extras;

    public GlobalExtraItemPool(List<Item> extras) {
        this.extras = extras;
    }

    @Override
    public void affectItemOptions(List<Item> result, int itemTier) {
        for (Item option : this.extras) {
            if (option.getTier() != itemTier) continue;
            result.add(option);
        }
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Pixl p = new Pixl(3, 3).border(Colours.yellow);
        p.text("[grey]Item Pool +").row();
        if (this.extras.size() > 20) {
            big = false;
        }
        if (big) {
            for (Item option : this.extras) {
                p.actor(new ItemPanel(option, false), 100.0f);
            }
        } else {
            p.text(this.extras.size());
        }
        return p.pix();
    }

    @Override
    public String describeForSelfBuff() {
        ArrayList<String> strings = new ArrayList<String>();
        for (Item option : this.extras) {
            strings.add(option.getName());
        }
        return "Add " + Tann.commaList(strings) + " to the item pool";
    }
}

