/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked.all;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.lang.Words;

public class GlobalAllEntities
extends GlobalLinked {
    public final Personal personal;
    final Boolean player;

    public GlobalAllEntities(Personal personal) {
        this(null, personal);
    }

    public GlobalAllEntities(Boolean player, Personal personal) {
        super(personal);
        this.player = player;
        this.personal = personal;
    }

    @Override
    public String describeForSelfBuff() {
        String end = ":[cu] ";
        String start = this.player == null ? "[text]All heroes and monsters:[cu] " : (this.player != false ? "[green]All heroes:[cu] " : "[red]All monsters:[cu] ");
        return start + Words.capitaliseFirst(this.personal.describeForSelfBuff().toLowerCase());
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if ((this.player == null || entState.getEnt().isPlayer() == this.player.booleanValue()) && this.personal.canBeAddedTo(entState)) {
            return this.personal;
        }
        return super.getLinkedTrigger(entState);
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.personal.getCollisionBits(this.player);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Actor a = this.personal.makePanelActor(big);
        if (a == null) {
            return null;
        }
        Color border = GlobalAllEntities.colForPlayer(this.player);
        Group g = new Pixl(0, 3).border(border).actor(a).pix();
        return g;
    }

    public static Color colForPlayer(Boolean player) {
        Color border = Colours.yellow;
        if (player != null) {
            border = player != false ? Colours.green : Colours.red;
        }
        return border;
    }

    public Boolean getPlayer() {
        return this.player;
    }
}

