/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.global.scaffolding.HeroPosition;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.util.Colours;

public class GlobalPositional
extends GlobalLinked {
    final HeroPosition heroPosition;
    public final Personal trigger;

    public GlobalPositional(HeroPosition heroPosition, Personal trigger) {
        super(trigger);
        this.trigger = trigger;
        this.heroPosition = heroPosition;
    }

    @Override
    public String describeForSelfBuff() {
        boolean plural = this.heroPosition.getRawPosition().length > 1;
        String end = this.trigger.describeForSelfBuff();
        if (!plural) {
            end = end.replaceAll("start", "starts");
        }
        return this.heroPosition.describe() + ":[n]" + end;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return DipPanel.makeSidePanelGroup(big, this.heroPosition.makeActor(), this.trigger, Colours.green);
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if (!entState.getEnt().isPlayer()) {
            return super.getLinkedTrigger(entState);
        }
        Snapshot s = entState.getSnapshot();
        if (s == null || !this.heroPosition.getFromPosition(entState.getSnapshot().getEntities(entState.isPlayer(), null)).contains(entState.getEnt())) {
            return super.getLinkedTrigger(entState);
        }
        return this.trigger;
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.trigger.getCollisionBits(true) | this.heroPosition.getCollisionBit();
    }

    @Override
    public String hyphenTag() {
        return ModifierUtils.hyphenTag(this.trigger.hyphenTag(), "" + this.heroPosition.getRawPosition().length);
    }
}

