/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.eff;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.Buff;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.targetable.SimpleTargetable;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.event.snapshot.SnapshotEvent;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.trigger.global.eff.GlobalEffContainer;
import com.tann.dice.screens.dungeon.panels.hourglass.HourglassTime;
import com.tann.dice.util.Pixl;

public class GlobalStartTurnEff
extends GlobalEffContainer {
    final Eff[] effs;
    final SnapshotEvent event;

    public GlobalStartTurnEff(Eff ... effs) {
        this((SnapshotEvent)null, effs);
    }

    public GlobalStartTurnEff(SnapshotEvent event, Eff ... effs) {
        super(effs);
        this.effs = effs;
        this.event = event;
    }

    @Override
    public String describeForSelfBuff() {
        String end = this.effDesc().replace(" this turn", "");
        String start = this.lastsOneTurn(this.effs) ? "During each turn" : "At the start of each turn";
        return start + ", " + end;
    }

    private String effDesc() {
        return Eff.describe(this.effs).toLowerCase();
    }

    private boolean lastsOneTurn(Eff[] effs) {
        Eff e = effs[0];
        Buff b = e.getBuff();
        return b != null && b.turns == 1;
    }

    @Override
    public void startOfTurnGeneral(Snapshot snapshot, int turn) {
        for (Eff eff : this.effs) {
            snapshot.target(null, new SimpleTargetable(null, eff), false);
        }
        if (this.event != null) {
            snapshot.addEvent(this.event);
        }
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Pixl p = new Pixl(0);
        for (Eff e : this.effs) {
            Actor a;
            int v = e.getValue();
            String s = "";
            if (v != -999) {
                s = v + "";
            }
            if (e.getRestrictions().size() > 0) {
                s = s + "!";
            }
            if ((a = e.getBasicImage(s)) == null) continue;
            p.actor(a);
        }
        return p.pix();
    }

    @Override
    public long getCollisionBits(Boolean player) {
        long bit = 0L;
        for (Eff e : this.effs) {
            bit |= e.getCollisionBits(player);
        }
        return bit;
    }

    @Override
    public String describeForHourglass() {
        return this.effDesc();
    }

    @Override
    public HourglassTime getHourglassTime() {
        if (this.effs[0].getType() == EffType.Summon) {
            return HourglassTime.START;
        }
        return super.getHourglassTime();
    }

    @Override
    public String hyphenTag() {
        return ModifierUtils.hyphenTag(this.effs[0]);
    }

    @Override
    public Eff getSingleEffOrNull() {
        if (this.effs.length == 1) {
            return this.effs[0];
        }
        return super.getSingleEffOrNull();
    }
}

