/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger;

import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.util.Tann;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Collision {
    public static final long REROLLS = Collision.bit(12);
    public static final long SPELL = Collision.bit(13);
    public static final long ENEMY_SHIELD = Collision.bit(14);
    public static final long INCOMING_BONUS = Collision.bit(15);
    public static final long PLAYER_HP = Collision.bit(16);
    public static final long MONSTER_HP = Collision.bit(17);
    public static final long PLAYER_KEYWORD = Collision.bit(18);
    public static final long MONSTER_KEYWORD = Collision.bit(19);
    public static final long NUM_HEROES = Collision.bit(20);
    public static final long TRIGGER_PIP = Collision.bit(21);
    public static final long POISON = Collision.bit(22);
    public static final long ITEM_REWARD = Collision.bit(23);
    public static final long LEVELUP_REWARD = Collision.bit(24);
    public static final long RANGED = Collision.bit(25);
    public static final long ITEM = Collision.bit(26);
    public static final long HERO_POSITION = Collision.bit(27);
    public static final long SPECIFIC_LEVEL = Collision.bit(28);
    public static final long SPECIFIC_TURN = Collision.bit(29);
    public static final long PHYSICAL_DAMAGE = Collision.bit(30);
    public static final long MAX_VALUE = Collision.bit(31);
    public static final long UNDYING = Collision.bit(32);
    public static final long TACTIC = Collision.bit(33);
    public static final long VERY_BAD_ITEM = Collision.bit(34);
    public static final long HEAL = Collision.bit(35);
    public static final long SHIELD = Collision.bit(36);
    public static final long MODIFIER = Collision.bit(37);
    public static final long BLANK_SIDE = Collision.bit(38);
    public static final long DEBUFF = Collision.bit(39);
    public static final long GENERIC_ALL_SIDES_HERO = Collision.bit(40);
    public static final long ALL_SIDES_MONSTER = Collision.bit(41);
    public static final long MONSTER_DEATH = Collision.bit(42);
    public static final long PLAYER_DEATH = Collision.bit(43);
    public static final long COL_RED = Collision.bit(44);
    public static final long COL_BLUE = Collision.bit(45);
    public static final long COL_GREY = Collision.bit(46);
    public static final long COL_YELLOW = Collision.bit(47);
    public static final long COL_ORANGE = Collision.bit(48);
    public static final long COL_GREEN = Collision.bit(49);
    public static final long COL_PINK = Collision.bit(50);
    public static final long LARGE_VALUES = Collision.bit(51);
    public static final long PHASE = Collision.bit(52);
    public static long ALL_SIDES_HERO_COMPOSITE = Collision.sideIndexBit(true, 0) + Collision.sideIndexBit(true, 1) + Collision.sideIndexBit(true, 2) + Collision.sideIndexBit(true, 3) + Collision.sideIndexBit(true, 4) + Collision.sideIndexBit(true, 5);
    public static final int NUM_BITS = 51;

    private static long bit(int shift) {
        return 1L << shift;
    }

    public static long sideIndexBit(boolean player, int index) {
        return Collision.bit((player ? 0 : 6) + index);
    }

    public static long allSides(Boolean player) {
        if (player == null) {
            return ALL_SIDES_MONSTER | GENERIC_ALL_SIDES_HERO;
        }
        return player != false ? GENERIC_ALL_SIDES_HERO : ALL_SIDES_MONSTER;
    }

    public static List<Modifier> getAllModifiersCollidingWith(long bit) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (Modifier m : ModifierLib.getAll()) {
            if (!ChoosableUtils.collides((Choosable)m, bit)) continue;
            result.add(m);
        }
        return result;
    }

    public static String nameFor(long chk) {
        if (chk == 0L) {
            return "none";
        }
        ArrayList<String> name = new ArrayList<String>();
        for (Field f : Collision.class.getFields()) {
            if (f.getType() != Long.TYPE) continue;
            try {
                String fieldName;
                long l = (Long)f.get(null);
                if ((l & chk) == 0L || (fieldName = f.getName()).equalsIgnoreCase("ALL_SIDES_HERO_COMPOSITE")) continue;
                name.add(f.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        int ch = 12;
        for (int i = 0; i < 12; ++i) {
            if ((chk & 1L << i) == 0L) continue;
            name.add(Collision.firstSideBitsName(i));
        }
        if (name.isEmpty()) {
            return "unknown";
        }
        return Tann.commaList(name);
    }

    private static String firstSideBitsName(int i) {
        if (i < 0 || i > 11) {
            return "hmm??" + i + "?";
        }
        if (i <= 5) {
            return "PLAYER_SIDE_" + i;
        }
        return "MONSTER_SIDE_" + (i - 6);
    }

    public static long keyword(Boolean player) {
        if (player == null) {
            return MONSTER_KEYWORD | PLAYER_KEYWORD;
        }
        if (player.booleanValue()) {
            return PLAYER_KEYWORD;
        }
        return MONSTER_KEYWORD;
    }

    public static long hpFor(Boolean player) {
        if (player == null) {
            return PLAYER_HP | MONSTER_HP;
        }
        return player != false ? PLAYER_HP : MONSTER_HP;
    }

    public static long death(Boolean player) {
        if (player == null) {
            return MONSTER_DEATH | PLAYER_DEATH;
        }
        return player != false ? PLAYER_DEATH : MONSTER_DEATH;
    }

    public static long ignored(long bit, long toIgnore) {
        return bit - (bit & toIgnore);
    }

    public static boolean collides(long a, long b) {
        return (a & b) != 0L;
    }
}

