/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.runEnd;

import com.tann.dice.Main;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.runEnd.RunEndAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.runEnd.RunEndCondition;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.endRound.DamageTakenStat;
import com.tann.dice.gameplay.progress.stats.stat.endRound.TurnsTakenStat;
import com.tann.dice.gameplay.progress.stats.stat.miscStat.UndoCountStat;
import java.util.Arrays;
import java.util.List;

public class RunEndStatAchievement
extends RunEndAchievement {
    final transient String statName;
    final transient int target;
    final transient Boolean below;

    public RunEndStatAchievement(String statName, int target, Boolean below, Unlockable ... unlockables) {
        this(statName, target, below, new RunEndCondition(Mode.CLASSIC, null), unlockables);
    }

    public RunEndStatAchievement(String statName, int target, Boolean below, RunEndCondition runEndCondition, Unlockable ... unlockables) {
        super(runEndCondition, RunEndStatAchievement.TITLE_FOR(statName, target, below), RunEndStatAchievement.DESC_FOR(statName, target, below, runEndCondition), unlockables);
        this.target = target;
        this.below = below;
        this.statName = statName;
        Stat s = Main.self().masterStats.getStat(statName);
        if (s == null) {
            throw new RuntimeException("Invalid stat achievement: " + statName);
        }
        this.diff(9.0f);
    }

    private static String tag(Boolean below, boolean concise) {
        if (below == null) {
            return "";
        }
        if (concise) {
            return below != false ? "<= " : ">= ";
        }
        return below != false ? "or fewer " : "or more ";
    }

    private static String TITLE_FOR(String statName, int target, Boolean below) {
        return statName + " " + RunEndStatAchievement.tag(below, true) + target;
    }

    private static String DESC_FOR(String statName, int target, Boolean below, RunEndCondition runEndCondition) {
        return "with " + target + " " + RunEndStatAchievement.tag(below, false) + statName;
    }

    @Override
    protected boolean aRunEndCheck(DungeonContext context, ContextConfig contextConfig) {
        Stat s = context.getStatsManager().getStatsMap().get(this.statName);
        if (s == null) {
            return false;
        }
        if (this.below == null) {
            return s.getValue() == this.target;
        }
        if (this.below.booleanValue()) {
            return s.getValue() <= this.target;
        }
        return s.getValue() >= this.target;
    }

    public static List<Achievement> make() {
        return Arrays.asList(new RunEndStatAchievement(TurnsTakenStat.NAME, 40, (Boolean)true, new Unlockable[0]).diff(9.0f), new RunEndStatAchievement(TurnsTakenStat.NAME, 30, (Boolean)true, new Unlockable[0]), new RunEndStatAchievement(TurnsTakenStat.NAME, 20, (Boolean)true, new Unlockable[0]), new RunEndStatAchievement("total-deaths", 0, null, new Unlockable[0]), new RunEndStatAchievement(UndoCountStat.NAME, 0, null, new Unlockable[0]), new RunEndStatAchievement("crosses-rolled", 0, null, new Unlockable[0]), new RunEndStatAchievement("total-kills", 0, null, new Unlockable[0]), new RunEndStatAchievement(DamageTakenStat.NAME, 0, null, new Unlockable[0]), new RunEndStatAchievement("total-blocked", 0, null, new Unlockable[0]));
    }
}

