/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress;

import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.context.config.difficultyConfig.DifficultyConfig;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.MasterStatsData;
import com.tann.dice.gameplay.progress.StatSnapshot;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.AchievementCompletionListener;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.statAchievement.StatAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.afterRoll.AfterRollAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.equip.EquipAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.fightEnd.FightEndAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.runEnd.RunEndAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.timing.snapshot.SnapshotAchievement;
import com.tann.dice.gameplay.progress.chievo.achievementTypes.weird.MetaAchievement;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.bsRandom.Checker;
import com.tann.dice.util.bsRandom.RandomCheck;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.ClipboardUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnlockManager {
    final List<Achievement> allAchievements;
    private List<Achievement> completedAchievements = new ArrayList<Achievement>();
    Set<Unlockable> lockedUnlockables = new HashSet<Unlockable>();
    private final List<SnapshotAchievement> snapshotAchievements = new ArrayList<SnapshotAchievement>();
    private final List<StatAchievement> statAchievements = new ArrayList<StatAchievement>();
    private final List<MetaAchievement> metaAchievements = new ArrayList<MetaAchievement>();
    private final List<RunEndAchievement> runEndAchievements = new ArrayList<RunEndAchievement>();
    private final List<FightEndAchievement> fightEndAchievements = new ArrayList<FightEndAchievement>();
    private final List<EquipAchievement> equipAchievements = new ArrayList<EquipAchievement>();
    private final List<AfterRollAchievement> afterRollAchievements = new ArrayList<AfterRollAchievement>();
    List<AchievementCompletionListener> listeners = new ArrayList<AchievementCompletionListener>();

    public UnlockManager(List<Achievement> allAchievements) {
        this.allAchievements = allAchievements;
        for (Achievement a : allAchievements) {
            if (a.isAchieved()) continue;
            if (a instanceof SnapshotAchievement) {
                this.snapshotAchievements.add((SnapshotAchievement)a);
                continue;
            }
            if (a instanceof StatAchievement) {
                this.statAchievements.add((StatAchievement)a);
                continue;
            }
            if (a instanceof MetaAchievement) {
                this.metaAchievements.add((MetaAchievement)a);
                continue;
            }
            if (a instanceof RunEndAchievement) {
                this.runEndAchievements.add((RunEndAchievement)a);
                continue;
            }
            if (a instanceof FightEndAchievement) {
                this.fightEndAchievements.add((FightEndAchievement)a);
                continue;
            }
            if (a instanceof EquipAchievement) {
                this.equipAchievements.add((EquipAchievement)a);
                continue;
            }
            if (!(a instanceof AfterRollAchievement)) continue;
            this.afterRollAchievements.add((AfterRollAchievement)a);
        }
    }

    public void resetUnlocks() {
        this.lockedUnlockables.clear();
        if (Main.getSettings().isBypass()) {
            return;
        }
        for (Achievement a : this.allAchievements) {
            if (a.isAchieved()) continue;
            this.lockedUnlockables.addAll(Arrays.asList(a.getUnlockables()));
        }
    }

    public List<Achievement> getCompletedAchievements(Boolean secret) {
        if (secret == null) {
            return this.completedAchievements;
        }
        ArrayList<Achievement> result = new ArrayList<Achievement>();
        for (Achievement a : this.completedAchievements) {
            if (a.isChallenge() == secret.booleanValue()) continue;
            result.add(a);
        }
        return result;
    }

    public List<Achievement> getCompletedAchievements() {
        return this.getCompletedAchievements(null);
    }

    public List<Achievement> getIncompleteAchievements() {
        ArrayList<Achievement> incomplete = new ArrayList<Achievement>(this.allAchievements);
        incomplete.removeAll(this.getCompletedAchievements());
        return incomplete;
    }

    public void unlockAllModeAchievements() {
        block0: for (Achievement a : this.allAchievements) {
            if (a.isAchieved() || a.getUnlockables().length <= 0) continue;
            for (Unlockable unlockable : a.getUnlockables()) {
                if (!(unlockable instanceof Mode)) continue;
                this.achieveAchievement(a, false);
                continue block0;
            }
        }
        this.saveAll();
    }

    public void unlockAllChallenges() {
        for (Achievement a : this.allAchievements) {
            if (a.isAchieved() || a.getUnlockables().length <= 0) continue;
            this.achieveAchievement(a, false);
        }
        this.saveAll();
    }

    public void saveAll() {
        Main.self().masterStats.saveAll();
    }

    void achieveAchievement(Achievement a) {
        this.achieveAchievement(a, true);
    }

    void achieveAchievement(Achievement a, boolean save) {
        if (a.isAchieved()) {
            return;
        }
        this.completedAchievements.add(a);
        a.setAchievedStateInternal(true);
        for (AchievementCompletionListener acl : this.listeners) {
            acl.onUnlock(a);
        }
        this.lockedUnlockables.removeAll(Arrays.asList(a.getUnlockables()));
        if (save) {
            this.updateAfterAchieve();
            this.saveAll();
            Main.getSettings().setLastAlmanacPage("ledger-unlock");
        }
    }

    void resetAchievements() {
        for (Achievement a : this.allAchievements) {
            a.setAchievedStateInternal(false);
        }
        this.completedAchievements.clear();
        this.resetUnlocks();
    }

    public void unlockAll() {
        this.unlockAll(1.0f);
    }

    public void unlockAll(float chance) {
        this.resetAchievements();
        for (Achievement a : this.allAchievements) {
            if (!(Math.random() < (double)chance)) continue;
            this.achieveAchievement(a, false);
        }
        this.saveAll();
    }

    public List<Achievement> getAllAchievements() {
        return this.allAchievements;
    }

    public List<Achievement> getAllTypedAchievements() {
        ArrayList<Achievement> result = new ArrayList<Achievement>();
        result.addAll(this.snapshotAchievements);
        result.addAll(this.statAchievements);
        result.addAll(this.metaAchievements);
        result.addAll(this.runEndAchievements);
        result.addAll(this.fightEndAchievements);
        result.addAll(this.equipAchievements);
        result.addAll(this.afterRollAchievements);
        return result;
    }

    public List<Achievement> getShownChallenges() {
        ArrayList<Achievement> incompleteChallenges = new ArrayList<Achievement>();
        for (Achievement incomplete : this.getIncompleteAchievements()) {
            if (!incomplete.isChallenge() || !incomplete.isCompletable()) continue;
            incompleteChallenges.add(incomplete);
        }
        Collections.sort(incompleteChallenges, new Comparator<Achievement>(){

            @Override
            public int compare(Achievement o1, Achievement o2) {
                return (int)Math.signum(o1.getDifficulty() - o2.getDifficulty());
            }
        });
        if (incompleteChallenges.size() == 0) {
            return incompleteChallenges;
        }
        return incompleteChallenges.subList(0, Math.min(5, incompleteChallenges.size()));
    }

    public Map<String, Achievement> getAchievementMap() {
        HashMap<String, Achievement> result = new HashMap<String, Achievement>();
        for (Achievement a : this.getAllAchievements()) {
            result.put(a.getName(), a);
        }
        return result;
    }

    public void registerAchievementListener(AchievementCompletionListener listener) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            if (this.listeners.get(i).getClass() != listener.getClass()) continue;
            this.listeners.remove(i);
        }
        this.listeners.add(listener);
    }

    public void load(List<String> completedAchievementStrings) {
        String s;
        if (completedAchievementStrings.size() > 10 && !completedAchievementStrings.contains(s = "First Boss")) {
            completedAchievementStrings.add(s);
        }
        Map<String, Achievement> map = this.getAchievementMap();
        for (String s2 : completedAchievementStrings) {
            Achievement a = map.get(s2);
            if (a == null) {
                TannLog.log("Failed to load unlocked chievo: " + s2);
                continue;
            }
            this.achieveAchievement(a, false);
        }
    }

    public void updateAfterAchieve() {
        for (MetaAchievement a : this.metaAchievements) {
            if (a.isAchieved() || !a.onAchieveOther(this.completedAchievements)) continue;
            this.achieveAchievement(a);
        }
    }

    public void updateAfterCommand(StatSnapshot ss, Map<String, Stat> statMap) {
        for (SnapshotAchievement snapshotAchievement : this.snapshotAchievements) {
            if (snapshotAchievement.isAchieved() || !snapshotAchievement.snapshotCheck(ss)) continue;
            this.achieveAchievement(snapshotAchievement);
        }
        for (StatAchievement statAchievement : this.statAchievements) {
            if (statAchievement.isAchieved() || !statAchievement.statCheck(statMap)) continue;
            this.achieveAchievement(statAchievement);
        }
    }

    public void updateEndOfRound(StatSnapshot ss) {
        for (SnapshotAchievement a : this.snapshotAchievements) {
            if (a.isAchieved() || !a.snapshotCheck(ss)) continue;
            this.achieveAchievement(a);
        }
    }

    public void updateAfterSaveForStats(Map<String, Stat> mergedStats) {
        for (StatAchievement a : this.statAchievements) {
            if (a.isAchieved() || !a.statCheck(mergedStats)) continue;
            this.achieveAchievement(a);
        }
    }

    public void endOfFight(StatSnapshot ss, boolean victory) {
        for (FightEndAchievement a : this.fightEndAchievements) {
            if (a.isAchieved() || !a.endOfFightCheck(ss, victory)) continue;
            this.achieveAchievement(a);
        }
    }

    public void endOfRun(DungeonContext context, boolean victory, boolean background) {
        ContextConfig contextConfig = context.getContextConfig();
        Difficulty difficulty = null;
        if (contextConfig instanceof DifficultyConfig) {
            difficulty = ((DifficultyConfig)contextConfig).getDifficulty();
        }
        if (!background) {
            for (RunEndAchievement a : this.runEndAchievements) {
                if (a.isAchieved() || !a.runEndCheck(context, contextConfig, difficulty, victory)) continue;
                this.achieveAchievement(a);
            }
        }
    }

    public void afterEquip(Party party) {
        for (EquipAchievement a : this.equipAchievements) {
            if (a.isAchieved() || !a.onEquip(party)) continue;
            this.achieveAchievement(a);
        }
    }

    public void allDiceLanded(List<EntSideState> states) {
        for (AfterRollAchievement a : this.afterRollAchievements) {
            if (a.isAchieved() || !a.allDiceLandedCheck(states)) continue;
            this.achieveAchievement(a);
        }
    }

    public void loadAchievementsFromStrings(List<String> completedAchievementStrings) throws Exception {
        if (completedAchievementStrings.size() == 0) {
            throw new Exception("[purple]Found 0 achievements, cancelling load");
        }
        int previousAchievements = this.getCompletedAchievements().size();
        int achievementsInPaste = completedAchievementStrings.size();
        this.load(completedAchievementStrings);
        int newAchievements = this.getCompletedAchievements().size();
        int numNew = newAchievements - previousAchievements;
        String explanation = "[text]Found [yellow]" + achievementsInPaste + " achievements[cu].[n]" + (numNew == 0 ? "[purple]but none of them were new..." : "Successfully-merged, added [green]" + numNew + "[cu] new " + Words.plural("achievement", numNew));
        Main.self().setScreen(new TitleScreen());
        Main.getCurrentScreen().showDialog(explanation);
        this.updateAfterAchieve();
    }

    public void saveAchievementsToClipboard() {
        MasterStatsData msd = new MasterStatsData(new ArrayList<Stat>(), this.getCompletedAchievements());
        String json = Main.getJson().toJson(msd);
        int hashcode = json.hashCode();
        ClipboardUtils.copyWithSoundAndToast(json + "xxxxxxxxxxxxxxx" + hashcode);
    }

    public boolean isLocked(Unlockable u) {
        return this.lockedUnlockables.contains(u);
    }

    public void achieveRandom() {
        Achievement a = RandomCheck.checkedRandom(this.allAchievements, new Checker<Achievement>(){

            @Override
            public boolean check(Achievement achievement) {
                return !UnlockManager.this.completedAchievements.contains(achievement);
            }
        }, null);
        if (a != null) {
            this.achieveAchievement(a, true);
        }
    }
}

