/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.misc;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.MessagePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.reveal.RandomRevealPhase;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HeroChangePhase
extends Phase {
    final HeroRerollType type;
    final int index;
    ChoiceDialog cd;

    public HeroChangePhase(int index, HeroRerollType type) {
        if (type == null) {
            type = HeroRerollType.random();
        }
        this.index = index;
        this.type = type;
    }

    public HeroChangePhase(String s) {
        this(HeroChangePhase.getIndex(s), HeroChangePhase.getSwapType(s));
    }

    private static HeroRerollType getSwapType(String s) {
        return HeroRerollType.values()[Integer.parseInt("" + s.charAt(1))];
    }

    private static int getIndex(String s) {
        return Integer.parseInt("" + s.charAt(0));
    }

    @Override
    public String serialise() {
        return "5" + this.index + "" + Tann.indexOf(HeroRerollType.values(), this.type);
    }

    @Override
    public void activate() {
        Sounds.playSound(Sounds.pip);
        List<Hero> heroList = this.getFightLog().getSnapshot(FightLog.Temporality.Present).getAliveHeroEntities();
        if (this.index >= heroList.size()) {
            this.stop();
        }
        final Hero a = heroList.get(this.index);
        Pixl choicePix = new Pixl(3);
        String text = this.type.desc.replaceAll("Z", a.getName(true)) + "[p]?";
        choicePix.text(text).row(5);
        choicePix.actor(new DiePanel(a)).text("->").image(Images.qmark);
        Group choiceActor = choicePix.pix();
        this.cd = new ChoiceDialog(Arrays.asList(choiceActor), ChoiceDialog.ChoiceNames.YesNo, new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.magic);
                try {
                    HeroType newType = HeroChangePhase.this.type.findNewTypeForHero(a);
                    if (newType != null && !newType.isMissingno()) {
                        String oldName = a.getName(true);
                        a.levelUpTo(newType, HeroChangePhase.this.getContext());
                        LevelEndPhase.unequipHero(HeroChangePhase.this.getContext().getParty(), a, oldName);
                        PhaseManager.get().pushPhaseNext(new RandomRevealPhase(newType));
                        HeroChangePhase.this.stop();
                    }
                }
                catch (Exception e) {
                    TannLog.error(e);
                    HeroChangePhase.this.errorAndStop(a);
                    return;
                }
                HeroChangePhase.this.stop();
            }
        }, new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pop);
                HeroChangePhase.this.stop();
            }
        });
        DungeonScreen.get().addActor(this.cd);
        Tann.center(this.cd);
        this.cd.setY(ChoicePhase.getShowY(this.cd));
    }

    private void errorAndStop(Hero a) {
        PhaseManager.get().pushPhaseNext(new MessagePhase("Error changing " + a.getName(true)));
        this.stop();
    }

    private void stop() {
        if (this.cd != null) {
            this.cd.remove();
        }
        PhaseManager.get().popPhase(HeroChangePhase.class);
        DungeonScreen.get().save();
    }

    @Override
    public boolean showCornerInventory() {
        return true;
    }

    @Override
    public void deactivate() {
        if (this.cd != null) {
            this.cd.remove();
        }
    }

    @Override
    public StandardButton getLevelEndButtonInternal() {
        return new StandardButton(Images.phaseRerollIcon, Colours.blue, 53, 20);
    }

    @Override
    public Color getLevelEndColour() {
        return Colours.blue;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    public static enum HeroRerollType {
        BASIC("Reroll the class of Z"),
        GENERATED("Replace Z with a [red]generated[cu] hero");

        final String desc;

        private HeroRerollType(String desc) {
            this.desc = desc;
        }

        private static HeroRerollType random() {
            HeroRerollType val = Tann.pick(HeroRerollType.values());
            if (val == GENERATED && UnUtil.isLocked(Mode.GENERATE_HEROES)) {
                return HeroRerollType.random();
            }
            return val;
        }

        private HeroType findNewTypeForHero(Hero a) {
            HeroCol col;
            switch (this) {
                case GENERATED: {
                    return PipeHeroGenerated.generate(a.getHeroCol(), a.getLevel());
                }
                case BASIC: {
                    col = a.getHeroCol();
                    break;
                }
                default: {
                    TannLog.error("Unimplemented herochangephase");
                    return PipeHeroGenerated.generate(a.getHeroCol(), a.getLevel());
                }
            }
            List<HeroType> options = Tann.getSelectiveRandom(HeroTypeUtils.getFilteredTypes(col, a.getLevel(), false), 1, PipeHero.getMissingno(), new ArrayList(), Arrays.asList(a.getHeroType()));
            if (options.size() > 0) {
                return options.get(0);
            }
            HeroType gen = PipeHeroGenerated.generate(a.getHeroCol(), a.getLevel() + 1);
            if (gen != null) {
                return gen;
            }
            return null;
        }
    }
}

