/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.reveal.RandomRevealPhase;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import java.util.Map;

public class LevelupHeroChoosable
implements Choosable {
    final HeroType ht;
    public static final String lucs = "levelup choosable";

    public LevelupHeroChoosable(HeroType ht) {
        this.ht = ht;
    }

    @Override
    public boolean isPositive() {
        return true;
    }

    @Override
    public Color getColour() {
        return this.ht.getColour();
    }

    @Override
    public String getSaveString() {
        return this.ht.getSaveString();
    }

    @Override
    public ChoosableType getType() {
        return ChoosableType.Levelup;
    }

    @Override
    public void onChoose(DungeonContext dc, int index) {
        dc.levelupFromLevelupPhaseChoice(this.ht, index);
        if (!this.ht.isGenerated()) {
            dc.getStatsManager().pickDelta(this, true);
        }
    }

    @Override
    public void onReject(DungeonContext dc) {
        if (this.ht.isGenerated()) {
            return;
        }
        dc.getStatsManager().pickDelta(this, false);
    }

    @Override
    public Actor makeChoosableActor(boolean big, int index) {
        DungeonScreen ds = DungeonScreen.get();
        final Hero target = ds.getDungeonContext().getParty().getHeroFor(this.ht, index);
        final Hero choice = this.ht.makeEnt();
        choice.setRealFightLog(DungeonScreen.get().getFightLog());
        choice.setLevelupOption(target);
        final DiePanel dp = new DiePanel(choice, false);
        if (!Main.getSettings().hasAttemptedLevel()) {
            dp.addPortraitFlasher();
        }
        if (PhaseManager.get().getPhase() instanceof RandomRevealPhase) {
            return dp;
        }
        Group g = new Group(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                if (!Main.isPortrait() && target != null && !Tann.hasParent(this, ChoiceDialog.class) && !Tann.hasParent(this, ScrollPane.class) && Math.abs((float)Main.width / 2.0f - Tann.getAbsoluteCoordinates((Actor)dp).x - dp.getWidth() / 2.0f) < 5.0f && TannStageUtils.getActorsWithName(LevelupHeroChoosable.lucs, Main.getCurrentScreen()).size() <= 2) {
                    EntPanel fromPanel = target.getEntPanel();
                    Vector2 fromVector = Tann.getAbsoluteCoordinates(fromPanel, Tann.TannPosition.Right).cpy();
                    Vector2 toVector = Tann.getAbsoluteCoordinates(dp, Tann.TannPosition.Left).cpy();
                    batch.setColor(choice.getColour());
                    float fx = fromVector.x;
                    float tx = toVector.x;
                    float fy = fromVector.y;
                    float ty = toVector.y;
                    Draw.drawDottedLine(batch, fx - 3.0f, fy, tx + 3.0f, ty, 5.0f, 10.0f, 5.0f, 1.0f);
                }
                super.draw(batch, parentAlpha);
            }
        };
        g.setName(lucs);
        g.setSize(dp.getWidth(), dp.getHeight());
        g.addActor(dp);
        g.setTransform(false);
        return g;
    }

    @Override
    public int getTier() {
        return this.ht.getTier();
    }

    @Override
    public float getModTier() {
        return TierUtils.levelupHeroChoosable(this.ht.getTier());
    }

    @Override
    public String describe() {
        return "level-up";
    }

    @Override
    public float chance() {
        return 1.0f;
    }

    @Override
    public String getTierString() {
        return this.ht.getTierString();
    }

    @Override
    public String getName() {
        return this.ht.getName();
    }

    @Override
    public boolean encountered(Map<String, Stat> allMergedStats) {
        return false;
    }

    @Override
    public int getPicks(Map<String, Stat> allMergedStats, boolean reject) {
        return 0;
    }

    @Override
    public long getCollisionBits() {
        return 0L;
    }

    public HeroType getHeroType() {
        return this.ht;
    }

    public String toString() {
        return "Levelup to " + this.ht.getName();
    }
}

