/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;

public class MessagePhase
extends Phase {
    final String msg;
    final String conf;
    Actor messageActor;

    public MessagePhase(String msg) {
        String[] parts = msg.split(";");
        this.msg = parts[0].replace(",", "");
        this.conf = parts.length > 1 ? parts[1] : "ok";
    }

    public MessagePhase(Exception e, String ctx) {
        this(MessagePhase.getMsg(e, ctx));
    }

    public static String getMsg(Exception e, String ctx) {
        if (e == null) {
            return "null exception";
        }
        return e.getClass().getSimpleName() + ":" + e.getMessage() + ": " + ctx;
    }

    @Override
    public Color getLevelEndColour() {
        return Colours.grey;
    }

    @Override
    public String serialise() {
        return '4' + this.msg + (this.conf == null ? "" : ";" + this.conf);
    }

    @Override
    public void activate() {
        Sounds.playSound(Sounds.paper);
        Pixl p = new Pixl(4, 4);
        StandardButton sb = new StandardButton(this.conf);
        sb.setRunnable(new Runnable(){

            @Override
            public void run() {
                MessagePhase.this.clickOk();
            }
        });
        p.border(Colours.grey).actor(this.makeSmallestMessageBox("[text]" + this.msg)).row().actor(sb);
        this.messageActor = p.pix();
        DungeonScreen.get().addActor(this.messageActor);
        Tann.center(this.messageActor);
        Tann.slideIn(this.messageActor, Tann.TannPosition.Bot, (int)((float)(Main.height / 2) - this.messageActor.getHeight() / 2.0f));
    }

    private void clickOk() {
        PhaseManager.get().popPhase(this.getClass());
    }

    private Actor makeSmallestMessageBox(String s) {
        int MIN_WITH = 90;
        int MAX_WIDTH = (int)((float)Main.width * 0.8f);
        int INCREMENT = 5;
        TextWriter best = new TextWriter("??");
        int minArea = 50000;
        for (int width = 90; width <= MAX_WIDTH; width += 5) {
            TextWriter a = new TextWriter(s, width);
            int area = (int)(a.getWidth() + a.getHeight() * 0.8f);
            if (area >= minArea) continue;
            minArea = area;
            best = a;
        }
        return best;
    }

    @Override
    public void deactivate() {
        Sounds.playSound(Sounds.pop);
        Tann.slideAway(this.messageActor, Tann.TannPosition.Bot, true);
        DungeonScreen.get().save();
    }

    @Override
    public StandardButton getLevelEndButtonInternal() {
        return new StandardButton(Images.phaseMessageIcon, Colours.grey, 53, 20);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public boolean keyPress(int keycode) {
        switch (keycode) {
            case 62: 
            case 66: 
            case 67: 
            case 160: {
                this.clickOk();
                return true;
            }
        }
        return false;
    }
}

