/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.gameplay;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.gameplay.EnemyRollingPhase;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.choice.CDChoice;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import java.util.ArrayList;
import java.util.List;

public class SurrenderPhase
extends Phase {
    ChoiceDialog cd;

    @Override
    public void activate() {
        Sounds.playSound(Sounds.surr, 1.0f, Tann.random(0.8f, 1.2f));
        DungeonScreen ds = DungeonScreen.get();
        List<EntState> states = ds.getFightLog().getSnapshot(FightLog.Temporality.Present).getStates(false, false);
        this.cd = new ChoiceDialog(SurrenderPhase.getFleeString(states), new ArrayList<Actor>(), new CDChoice(ChoiceDialog.ChoiceNames.YesNo.decline, new Runnable(){

            @Override
            public void run() {
                SurrenderPhase.this.decline();
            }
        }), new CDChoice("[purple]?", new Runnable(){

            @Override
            public void run() {
                SurrenderPhase.this.showExpl();
            }
        }), new CDChoice(ChoiceDialog.ChoiceNames.YesNo.accept, new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.flee);
                SurrenderPhase.this.accept();
            }
        }));
        ds.push(this.cd, true, false, false, 0.7f);
        Tann.center(this.cd);
    }

    private void showExpl() {
        Sounds.playSound(Sounds.paper);
        Group a = new Pixl(3, 3).border(Colours.purple).text("[text]Enemies will try to flee if they think the fight is hopeless. There is no gameplay benefit either way.", 120).row(4).actor(OptionLib.AUTO_FLEE.makeCogActor()).pix();
        Main.getCurrentScreen().push(a, 0.5f);
        Tann.center(a);
    }

    public void accept() {
        this.popit();
        DungeonScreen ds = DungeonScreen.get();
        ds.getDungeonContext().getStatsManager().surrenderLog(true);
        FightLog f = ds.getFightLog();
        f.enemiesSurrendered();
    }

    private void popit() {
        if (this.cd != null) {
            Main.getCurrentScreen().popAllLight();
            Main.getCurrentScreen().pop(this.cd);
        }
    }

    private void decline() {
        this.popit();
        DungeonScreen ds = DungeonScreen.get();
        ds.getDungeonContext().getStatsManager().surrenderLog(false);
        ds.getFightLog().getSnapshot(FightLog.Temporality.Present).refusedSurrender();
        PhaseManager p = PhaseManager.get();
        p.forceNext(new EnemyRollingPhase());
        p.popPhase(SurrenderPhase.class);
    }

    @Override
    public void deactivate() {
    }

    @Override
    public boolean isDuringCombat() {
        return true;
    }

    @Override
    public boolean requiresSerialisation() {
        return false;
    }

    private static String getFleeString(List<EntState> states) {
        return SurrenderPhase.describeGroupOfEnemies(states) + " " + Words.plural("is", states.size() > 1) + " trying to " + SurrenderPhase.getFleeAction(states) + "[n][text]Will you let them escape?";
    }

    private static String getFleeAction(List<EntState> states) {
        boolean allRoll = true;
        for (EntState es : states) {
            EntType et = es.getEnt().entType;
            boolean eggy = et.getName(false).contains(" Egg");
            boolean barrelsome = et == MonsterTypeLib.byName("barrel");
            allRoll &= eggy || barrelsome;
        }
        return allRoll ? "roll away" : "flee";
    }

    public static String describeGroupOfEnemies(List<EntState> states) {
        if (states.size() == 0) {
            return "[sin]bug????[sin]";
        }
        if (states.size() > 1) {
            return "The monsters";
        }
        MonsterType m = (MonsterType)states.get((int)0).getEnt().entType;
        if (m.isUnique()) {
            return states.get(0).getEnt().getName(true);
        }
        return "The " + states.get(0).getEnt().getName(true).toLowerCase();
    }

    private static boolean allSameType(List<EntState> states) {
        EntType prev = null;
        for (EntState es : states) {
            if (prev != null && es.getEnt().entType != prev) {
                return false;
            }
            prev = es.getEnt().entType;
        }
        return true;
    }

    @Override
    public boolean canSave() {
        return false;
    }
}

