/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.endPhase;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.List;

public class RunEndPanel
extends Group {
    final ImageActor image;
    final ImageActor template;
    final String[] sound;
    final List<Actor> rightButtons;
    final float delay;
    private Group left;
    private Group right;

    public RunEndPanel(TextureRegion mainImage, TextureRegion templateImage, String[] sound, List<Actor> leftStuff, List<Actor> rightButtons, float delay) {
        this.image = new ImageActor(mainImage);
        this.template = new ImageActor(templateImage);
        this.sound = sound;
        this.rightButtons = rightButtons;
        this.delay = delay;
        this.setSize(Main.width + 2, 60.0f);
        if (Main.isPortrait()) {
            int PORT_EXTRA_HEIGHT = 60;
            this.setWidth(100.0f);
            this.setHeight(this.image.getHeight() + (float)(PORT_EXTRA_HEIGHT * 2));
        }
        this.addActor(this.template);
        Tann.center(this.template);
        this.template.setVisible(false);
        this.template.setColor(Colours.dark);
        this.addActor(this.image);
        this.image.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        Tann.center(this.image);
        Pixl l = new Pixl(2);
        for (Actor actor : leftStuff) {
            l.actor(actor).row();
        }
        this.left = l.pix();
        Pixl r = new Pixl(3);
        for (Actor a : rightButtons) {
            r.actor(a, 80.0f);
        }
        this.right = r.pix();
        this.addActor(this.left);
        this.addActor(this.right);
        Tann.center(this.left);
        Tann.center(this.right);
        if (Main.isPortrait()) {
            Pixl pixl = new Pixl(4, 5).actor(this.left).row().actor(mainImage).row().actor(this.right);
            Tann.become(this, pixl.pix());
        } else {
            this.left.setVisible(false);
            this.right.setVisible(false);
            this.left.setX((int)(this.getWidth() / 5.0f - this.left.getWidth() / 2.0f));
            this.right.setX((int)(this.getWidth() / 5.0f * 4.0f - this.right.getWidth() / 2.0f));
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        int border = 1;
        Draw.fillActor(batch, this, Colours.dark, Colours.purple, border);
        super.draw(batch, parentAlpha);
    }

    public void slideIn(final boolean fromSave) {
        Tann.center(this);
        this.setX(Main.width);
        float durMul = fromSave ? 0.0f : 1.0f;
        this.addAction(Actions.sequence((Action)Actions.delay(this.delay * durMul), (Action)Actions.moveTo(Main.isPortrait() ? (float)((int)((float)(Main.width / 2) - this.getWidth() / 2.0f)) : -1.0f, this.getY(), 0.5f * durMul, Interpolation.pow2Out), (Action)Actions.parallel(Actions.targeting(this.image, Actions.fadeIn(1.5f * durMul)), (Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                RunEndPanel.this.template.setVisible(true);
                if (!fromSave) {
                    Sounds.playSound(RunEndPanel.this.sound);
                }
            }
        })), (Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                RunEndPanel.this.left.setVisible(true);
                RunEndPanel.this.right.setVisible(true);
            }
        })));
    }
}

