/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier.bless;

import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.VisualEffectType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.TargetingRestriction;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellBill;
import com.tann.dice.gameplay.fightLog.event.snapshot.ManaGainEvent;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierPickContext;
import com.tann.dice.gameplay.modifier.generation.CurseDistribution;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge.ChallengePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.GlobalMaxMana;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.gameplay.trigger.global.eff.GlobalEndTurnEff;
import com.tann.dice.gameplay.trigger.global.eff.GlobalStartOfCombat;
import com.tann.dice.gameplay.trigger.global.eff.GlobalStartTurnEff;
import com.tann.dice.gameplay.trigger.global.item.GlobalItemQuality;
import com.tann.dice.gameplay.trigger.global.linked.GlobalAllEntitiesRestricted;
import com.tann.dice.gameplay.trigger.global.linked.GlobalHeroTier;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinkedGeneric;
import com.tann.dice.gameplay.trigger.global.linked.GlobalMulti;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalHeroes;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalMonsters;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.GlobalAddPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorChallenge;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorLevelup;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorLootSpecificTier;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorModifierPick;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorStandardLoot;
import com.tann.dice.gameplay.trigger.global.roll.GlobalBonusRerolls;
import com.tann.dice.gameplay.trigger.global.roll.GlobalKeepRerolls;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.GlobalLevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementAllButFirst;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementBoss;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementMod;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementRange;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementAll;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementEveryN;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementFirst;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementFirstN;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementN;
import com.tann.dice.gameplay.trigger.global.spell.GlobalLearnSpell;
import com.tann.dice.gameplay.trigger.global.spell.GlobalSpellCostChange;
import com.tann.dice.gameplay.trigger.personal.AvoidDeathPenalty;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.TypeCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ChangeToMyPosition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.FlatBonus;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.MultiplyEffect;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWithBlank;
import com.tann.dice.gameplay.trigger.personal.death.DamageAdjacentsOnDeath;
import com.tann.dice.gameplay.trigger.personal.death.OnDeathEffect;
import com.tann.dice.gameplay.trigger.personal.hp.MaxHP;
import com.tann.dice.gameplay.trigger.personal.hp.StartDamagedPer;
import com.tann.dice.gameplay.trigger.personal.immunity.DamageImmunity;
import com.tann.dice.gameplay.trigger.personal.item.ItemSlots;
import com.tann.dice.gameplay.trigger.personal.item.copyItem.CopyInvItems;
import com.tann.dice.gameplay.trigger.personal.linked.perN.PersonalPerN;
import com.tann.dice.gameplay.trigger.personal.linked.perN.ns.PerN;
import com.tann.dice.gameplay.trigger.personal.linked.perN.ns.PerNHeroLevel;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartPoisoned;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartRegenned;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BlessingSingles {
    private static Modifier addBlessAfter(int level, int blessValue) {
        float tier = CurseDistribution.getMultLevelAndAfter(level, blessValue);
        String name = "L" + level + " Blessing";
        if (blessValue != 4) {
            name = name + "^" + blessValue;
        }
        return new Modifier(tier, name, new GlobalLevelRequirement(new LevelRequirementRange(level), new GlobalAddPhase(new PhaseGeneratorModifierPick(3, 1, blessValue, true, ModifierPickContext.Difficulty_But_Midgame))));
    }

    public static List<Modifier> makeSingles() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.addAll(Arrays.asList(new Modifier(1.0f, "Latent", new GlobalHeroes(new StartRegenned(3)), new GlobalHeroes(new StartPoisoned(3))), new Modifier(TierUtils.doubleXp(), "Double XP", new GlobalLevelRequirement(new LevelRequirementMod(2, 1), new GlobalAddPhase(new PhaseGeneratorLevelup()))), new Modifier(TierUtils.doubleLoot(), "Double Loot", new GlobalLevelRequirement(new LevelRequirementMod(2, 0), new GlobalAddPhase(new PhaseGeneratorStandardLoot()))), new Modifier(4.0f, "Monster Right Pain", new GlobalMonsters(new AffectSides(SpecificSidesType.Right, new AddKeyword(Keyword.pain)))), new Modifier(10.0f, "Monster Left Pain", new GlobalMonsters(new AffectSides(SpecificSidesType.Left, new AddKeyword(Keyword.pain)))), new Modifier(25.0f, "MonsterMidDeath", new GlobalMonsters(new AffectSides(SpecificSidesType.Middle, new AddKeyword(Keyword.death))))));
        result.add(BlessingSingles.addBlessAfter(9, 4));
        result.add(BlessingSingles.addBlessAfter(9, 10));
        result.add(BlessingSingles.addBlessAfter(19, 4));
        result.add(new Modifier(5.0f, "Nicknack Knapsack", new GlobalLevelRequirement(new LevelRequirementAllButFirst(), new GlobalAddPhase(new PhaseGeneratorLootSpecificTier(1))), new GlobalHeroes(new ItemSlots(1))));
        result.add(new Modifier(ModTierUtils.bonusAllHeroHp(1.9f), "Gym", new GlobalHeroes(new PersonalPerN(new MaxHP(1), (PerN)new PerNHeroLevel()))));
        result.add(new Modifier(3.0f, "Unsummon", new GlobalMonsters(new AffectSides((AffectSideCondition)new TypeCondition(EffType.Summon), new FlatBonus(-1)))));
        result.add(new Modifier(ModTierUtils.extraMonsterHP(-0.2f), "Damaged Monsters", new GlobalMonsters(new StartDamagedPer(1, 4))));
        result.add(new Modifier(7.0f, "Free Turn", new GlobalTurnRequirement(new TurnRequirementFirst(), (Global)new GlobalMonsters(new AffectSides(new FlatBonus(-1))))));
        result.add(new Modifier(ModTierUtils.startWithMana(0.8f), "Mana Spring", new GlobalSpellCostChange(-2, (Integer)6)));
        result.add(new Modifier(ModTierUtils.bonusAllHeroHp(2.0f), "2 hero hp", new GlobalHeroes(new MaxHP(2))));
        result.add(new Modifier(ModTierUtils.bonusAllHeroHp(4.0f), "4 hero hp", new GlobalMulti(new GlobalHeroes(new MaxHP(2)), 2)).rarity(Rarity.HUNDREDTH));
        result.add(new Modifier(1.0f, "Rest", new GlobalLevelRequirement(new LevelRequirementRange(19), new GlobalHeroes(new AffectSides(new FlatBonus(5))))).rarity(Rarity.FIFTH));
        result.add(new Modifier(1.0f, "5 max mana", new GlobalMaxMana(5)));
        result.add(new Modifier(3.0f, "Essence Thief", new GlobalMonsters(new OnDeathEffect(new EffBill().mana(1).bEff(), new ManaGainEvent(1, "Essence Thief"), false))));
        result.add(new Modifier(3.0f, "Healest", new GlobalHeroes(new AffectSides((AffectSideCondition)new TypeCondition(EffType.Heal), new FlatBonus(1)))).rarity(Rarity.TENTH));
        result.add(new Modifier(2.0f, "Keep Rolls", new GlobalKeepRerolls()));
        result.add(new Modifier(6.0f, "Reliable", new GlobalHeroes(new AffectSides((AffectSideCondition)new TypeCondition(EffType.Blank), new ChangeToMyPosition(SpecificSidesType.Middle)))));
        result.add(new Modifier(4.0f, "Shield Plus", new GlobalHeroes(new AffectSides((AffectSideCondition)new TypeCondition(EffType.Shield), new FlatBonus(1)))).rarity(Rarity.TENTH));
        result.add(new Modifier(4.0f, "Treasure Seeker", new GlobalHeroes(new ItemSlots(1)), new GlobalItemQuality(1)));
        result.add(new Modifier(6.0f, "Monster Blank", new GlobalMonsters(new AffectSides(SpecificSidesType.Left, new ReplaceWithBlank(ChoosableType.Item)))));
        result.add(new Modifier(3.0f, "Poison Immunity", new GlobalHeroes(new DamageImmunity(true, false, false))));
        result.add(new Modifier(3.0f, "Turn 3 Heal", new GlobalTurnRequirement(3, (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().group().healAndShield(3).bEff()}))));
        result.add(new Modifier(3.0f, "Greased Dice", new GlobalTurnRequirement(new TurnRequirementN(1), (Global)new GlobalBonusRerolls(1)), new GlobalLevelRequirement(new LevelRequirementBoss(), new GlobalBonusRerolls(1))));
        result.add(new Modifier(ModTierUtils.doubleSides(5.0f), "Double Pips", new GlobalHeroes(new AffectSides(new MultiplyEffect(2)))));
        result.add(new Modifier(ModTierUtils.doubleSides(10.0f), "Triple Pips", new GlobalHeroes(new AffectSides(new MultiplyEffect(3)))));
        result.add(new Modifier(3.0f, "Lucky Start", new GlobalTurnRequirement(new TurnRequirementN(1), (Global)new GlobalBonusRerolls(2))));
        result.add(new Modifier(7.0f, "Great Start", new GlobalTurnRequirement(new TurnRequirementN(1), (Global)new GlobalHeroes(new AffectSides(new FlatBonus(1)).buffPriority()))));
        result.add(new Modifier(ModTierUtils.startWithMana(2.0f), "Fizzing", new GlobalTurnRequirement(new TurnRequirementFirst(), (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().mana(2).bEff()}))));
        result.add(new Modifier(ModTierUtils.startWithMana(4.0f), "Crackling", new GlobalTurnRequirement(new TurnRequirementFirst(), (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().mana(4).bEff()}))));
        result.add(new Modifier(3.0f, "Preparation", new GlobalStartOfCombat(new EffBill().shield(2).group().bEff())));
        result.add(new Modifier(3.0f, "Save Spell", new GlobalLearnSpell(new SpellBill().cost(1).title("Save").eff(new EffBill().friendly().keywords(Keyword.cleanse, Keyword.singleCast).healAndShield(5).visual(VisualEffectType.Undying)))));
        result.add(new Modifier(4.0f, "Bolt Spell", new GlobalLearnSpell(new SpellBill().cost(3).title("bolt").eff(new EffBill().damage(5).visual(VisualEffectType.Lightning)))));
        result.add(new Modifier(ModTierUtils.startWithMana(2.0f), "Jewelled Chalice", new GlobalTurnRequirement(new TurnRequirementFirstN(4), (Global)new GlobalStartTurnEff(new ManaGainEvent(1, "Jewelled Chalice"), new EffBill().mana(1).bEff()))));
        result.add(new Modifier(ModTierUtils.startWithMana(4.0f), "Infinite Chalice", new GlobalTurnRequirement(new TurnRequirementAll(), (Global)new GlobalStartTurnEff(new ManaGainEvent(1, "Infinite Chalice"), new EffBill().mana(1).bEff())), new GlobalTurnRequirement(new TurnRequirementEveryN(4), (Global)new GlobalStartTurnEff(new ManaGainEvent(2, "Infinite Chalice"), new EffBill().mana(2).bEff()))));
        result.add(new Modifier(5.0f, "Fumes", new GlobalAllEntitiesRestricted(false, TargetingRestriction.MostHealth, (Personal)new StartPoisoned(2))));
        result.add(new Modifier(3.0f, "Youth", new GlobalHeroTier(1, new MaxHP(4)), new GlobalHeroTier(2, new MaxHP(2))));
        result.add(new Modifier(2.0f, "Underworld Deal", new GlobalHeroes(new AvoidDeathPenalty())));
        result.add(new Modifier(6.0f, "Hamstring", new GlobalMonsters(new AffectSides(SpecificSidesType.RightTwo, new FlatBonus(-1, -1)))));
        result.add(new Modifier(3.0f, "Cataclysm", new GlobalTurnRequirement(new TurnRequirementN(7), (Global)new GlobalEndTurnEff(new EffBill().kill().group().bEff()))));
        result.add(new Modifier(2.0f, "Deep Pockets", new GlobalHeroes(new ItemSlots(1))));
        result.add(ItemLib.makeBlessingMulti("Stun Specialist", ItemLib.byName("Fearless"), ItemLib.byName("Wand of Stun")));
        result.add(ItemLib.makeBlessingMulti("Growth Fan", ItemLib.byName("Seedling"), ItemLib.byName("Glowing Egg")));
        result.add(new Modifier(3.0f, "Middle Shield", new GlobalHeroes(new AffectSides(SpecificSidesType.Middle, new AddKeyword(Keyword.selfShield)))));
        result.add(new Modifier(ModTierUtils.heroBonusAllSides(1.0f) * 5.0f, "Favour of Horus", new GlobalHeroes(new AffectSides(new FlatBonus(1)))));
        result.add(new Modifier(2.0f, "Challenge Each Fight", new GlobalAddPhase(new PhaseGeneratorChallenge(ChallengePhase.ChallengeDifficulty.Standard))));
        result.add(new Modifier(ModTierUtils.startWithMana(1.8f), "Threee", new GlobalTurnRequirement(new TurnRequirementEveryN(3), (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().mana(3).bEff()}))));
        result.add(new Modifier(20.0f, "Barrel Time", new GlobalMonsters(new DamageAdjacentsOnDeath(5))));
        result.add(new Modifier(5.0f, "Bone Math", new GlobalMonsters(new DamageAdjacentsOnDeath(1))));
        result.add(new Modifier(5.0f, "Display Case", new GlobalLinkedGeneric(new GlobalHeroes(new CopyInvItems()), new GlobalLinkedGeneric.GenCon(){

            @Override
            public String describe() {
                return "there is exactly one item in the inventory";
            }

            @Override
            public boolean holdsFor(DungeonContext context, int turn) {
                return context.getParty().getItems(false).size() == 1;
            }
        })));
        result.add(new Modifier(200.0f, "Peace", new GlobalMonsters(new AffectSides(new FlatBonus(-5)))));
        return result;
    }
}

