/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.leaderboard;

import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.endOfFight.FurthestReachedStat;

public class CursedLeaderboard
extends Leaderboard {
    final Mode mode;

    public CursedLeaderboard(Mode mode) {
        super(mode.getName(), "Highest fight reached in " + mode.getTextButtonName(), mode.getColour(), CursedLeaderboard.makeUrl(mode), "level", 9, true);
        this.mode = mode;
    }

    private static String makeUrl(Mode mode) {
        String pref = mode == Mode.BLURSED ? "blursed" : (mode == Mode.BLURTRA ? "blurtra" : mode.getName().replaceAll(" ", "_"));
        return pref + "_highest";
    }

    @Override
    public String getScoreString(int value) {
        return "" + value;
    }

    @Override
    public int getScore() {
        Stat s = Main.self().masterStats.getStat(FurthestReachedStat.getName(this.mode.getConfigs().get(0)));
        if (s == null) {
            return 0;
        }
        return s.getValue();
    }

    @Override
    public boolean internalValid(Mode m, Difficulty d) {
        return m == this.mode;
    }

    @Override
    public boolean isUnavailable() {
        return UnUtil.isLocked(this.mode);
    }

    @Override
    public String getSuperName() {
        return "[purple]Cursed";
    }
}

