/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.effect.targetable.ability.spell.ManaActor;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityHolder;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;

public class ManaHolder
extends Group {
    private static final String NUMBERED = "numbered";
    private static final int gap = 2;
    private static final int border = 3;
    private static final int MAX_CHARGE_ACTORS = 5;
    List<Actor> allActors = new ArrayList<Actor>();
    Actor inputGrabber = new Actor();

    public ManaHolder(Snapshot visual) {
        this.setTransform(false);
        this.update(0, visual.getMaxMana());
        this.setTouchable(Touchable.childrenOnly);
    }

    /*
     * WARNING - void declaration
     */
    public void update(final int newMana, final int maxMana) {
        int i;
        for (Actor allActor : this.allActors) {
            if (!NUMBERED.equals(allActor.getName())) continue;
            allActor.remove();
        }
        if (newMana == 0 && this.allActors.size() == 0) {
            this.setSize(0.0f, 0.0f);
            return;
        }
        ArrayList<Actor> newActors = new ArrayList<Actor>();
        int newChargeActors = newMana > 5 ? 1 : newMana;
        for (i = 0; i < newChargeActors && i < this.allActors.size(); ++i) {
            Actor actor = this.allActors.get(i);
            if (!(actor instanceof ManaActor)) continue;
            newActors.add(actor);
        }
        this.allActors.removeAll(newActors);
        if (Main.isPortrait() && newMana > 1 && this.getY() > 34.800003f && Main.width < 188 + Math.min(5, newMana) * 8) {
            for (i = 0; i < newActors.size(); ++i) {
                ((Actor)newActors.get(i)).remove();
            }
            newActors.clear();
            Actor a2 = Tann.imageWithText(Images.mana, "" + newMana, Colours.dark);
            a2.setName(NUMBERED);
            newActors.add(a2);
        } else {
            for (i = newActors.size(); i < newChargeActors; ++i) {
                newActors.add(new ManaActor());
            }
            for (i = 0; i < newActors.size(); ++i) {
                Actor actor = (Actor)newActors.get(i);
                if (!(actor instanceof ManaActor)) continue;
                ((ManaActor)actor).setStruck(i >= maxMana);
            }
            if (newMana > 5) {
                void var6_18;
                void var6_15;
                TextWriter tw = null;
                boolean bl = false;
                while (var6_15 < this.allActors.size()) {
                    Actor a3 = this.allActors.get((int)var6_15);
                    if (a3 instanceof TextWriter) {
                        tw = (TextWriter)a3;
                        this.allActors.remove(a3);
                        break;
                    }
                    ++var6_15;
                }
                String string = "[blue]x" + newMana;
                if (newMana > maxMana) {
                    String string2 = string + " (" + maxMana + ")[h][blank]";
                }
                if (tw == null) {
                    tw = new TextWriter((String)var6_18);
                } else {
                    tw.setText((String)var6_18);
                }
                newActors.add(tw);
            }
        }
        for (Actor actor : this.allActors) {
            if (actor instanceof TextWriter) {
                actor.remove();
                continue;
            }
            actor.addAction(Actions.parallel((Action)Actions.moveTo(-actor.getWidth() / 2.0f, actor.getY(), 0.3f, Chrono.i), (Action)Actions.sequence((Action)Actions.fadeOut(0.3f), (Action)Actions.removeActor())));
        }
        int totalWidth = 0;
        for (Actor a : newActors) {
            totalWidth = (int)((float)totalWidth + a.getWidth());
        }
        totalWidth += 2 * (newActors.size() - 1);
        int n = 16;
        this.setHeight(n);
        float spd = DungeonScreen.get().isLoading() ? 0.0f : 0.3f;
        this.addAction(Actions.sizeTo(totalWidth += 6, n, spd, Chrono.i));
        this.addAction(Actions.alpha(Math.signum(newMana), spd));
        for (Actor a5 : newActors) {
            if (a5.hasParent()) continue;
            this.addActor(a5);
            a5.setPosition((int)(-a5.getWidth() / 2.0f), (int)((float)n / 2.0f - a5.getHeight() / 2.0f));
        }
        int currentX = (int)((float)(-totalWidth) / 2.0f + 3.0f);
        for (int i3 = 0; i3 < newActors.size(); ++i3) {
            Actor a6 = (Actor)newActors.get(i3);
            a6.addAction(Actions.moveTo(currentX, (int)((float)n / 2.0f - a6.getHeight() / 2.0f), spd, Chrono.i));
            currentX = (int)((float)currentX + (2.0f + a6.getWidth()));
        }
        this.allActors = newActors;
        this.inputGrabber.clearListeners();
        if (newMana > 0) {
            this.addActor(this.inputGrabber);
            this.inputGrabber.toFront();
            this.inputGrabber.setSize(totalWidth, n);
            this.inputGrabber.setX(-totalWidth / 2);
            this.inputGrabber.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    AbilityHolder.showInfo("[blue]" + newMana + "/" + maxMana + " " + Words.manaString() + " stored", Colours.blue);
                    return true;
                }
            });
        } else {
            this.removeActor(this.inputGrabber);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.getWidth() == 0.0f) {
            return;
        }
        batch.setColor(this.getColor());
        Images.manaPatch.draw(batch, (int)(this.getX() - this.getWidth() / 2.0f), this.getY(), this.getWidth(), this.getHeight());
        super.draw(batch, parentAlpha);
    }
}

