/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.command.AbilityCommand;
import com.tann.dice.gameplay.fightLog.command.DieCommand;
import com.tann.dice.gameplay.fightLog.command.TargetableCommand;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum EnumConditionalRequirement implements ConditionalRequirement
{
    Always(true),
    Bigger(false),
    TargetTargetingMe(false),
    SelfTarget(false),
    PreviousDiceIdentical(true),
    PreviousAbilitySharesKeyword(true),
    PreviousAbilitySame(true),
    PreviousTwoAbilitiesSame(true),
    PreviousFourAbilitiesSame(true),
    PreviousSixAbilitiesSame(true),
    PreviousAbilityHigher(true),
    PreviousAbilitySameTarget(false),
    SixthDiceUsed(true),
    RunOfTwo(true),
    RunOfThree(true),
    RunOfFive(true),
    NoOtherDice(true),
    JustCastASpell(true),
    MorePipsThanTarget,
    FewerPipsThanTarget,
    SameFirstLetterAsTarget,
    MoreHpThanTarget,
    SameHpAsTarget,
    CoprimeWithTarget,
    LessHpThanTarget,
    UnusedLastTurn(true),
    Top;

    public final boolean preCalculate;

    private EnumConditionalRequirement() {
        this(false);
    }

    private EnumConditionalRequirement(boolean preCalculate) {
        this.preCalculate = preCalculate;
    }

    public static EnumConditionalRequirement previousNSame(int n) {
        switch (n) {
            case 1: {
                return PreviousAbilitySame;
            }
            case 2: {
                return PreviousTwoAbilitiesSame;
            }
            case 4: {
                return PreviousFourAbilitiesSame;
            }
            case 6: {
                return PreviousSixAbilitiesSame;
            }
        }
        throw new RuntimeException("Invalid N same:" + n);
    }

    @Override
    public boolean isValid(Snapshot s, EntState sourceState, EntState targetState, Eff eff) {
        switch (this) {
            case TargetTargetingMe: {
                if (targetState == null) {
                    return false;
                }
                List<Ent> targeters = s.getAllTargeters(sourceState.getEnt(), true);
                return targeters.contains(targetState.getEnt());
            }
            case Top: {
                return s.getStates(targetState.isPlayer(), false).indexOf(targetState) == 0;
            }
            case Bigger: {
                return targetState.getEnt().getSize().getPixels() > sourceState.getEnt().getSize().getPixels();
            }
            case MoreHpThanTarget: {
                return sourceState.getHp() > targetState.getHp();
            }
            case SameHpAsTarget: {
                return sourceState.getHp() == targetState.getHp();
            }
            case CoprimeWithTarget: {
                return Tann.gcd(sourceState.getHp(), targetState.getHp()) == 1;
            }
            case LessHpThanTarget: {
                return sourceState.getHp() < targetState.getHp();
            }
            case Always: {
                return true;
            }
            case SelfTarget: {
                return sourceState == targetState;
            }
            case PreviousDiceIdentical: 
            case NoOtherDice: 
            case PreviousAbilitySharesKeyword: 
            case PreviousAbilityHigher: 
            case PreviousAbilitySameTarget: {
                FightLog f = s.getFightLog();
                DieCommand lastDieCommand = f.getDieCommandFromAtOrBeforeSnapshot(s);
                if (lastDieCommand == null) {
                    return this == NoOtherDice;
                }
                Eff contempEffect = f.getContemporaneousEffect(lastDieCommand);
                if (contempEffect == null) {
                    return false;
                }
                if (this == PreviousAbilityHigher) {
                    return contempEffect.getValue() > eff.getValue();
                }
                if (this == PreviousAbilitySharesKeyword) {
                    return Tann.anySharedItems(contempEffect.getKeywords(), eff.getKeywords());
                }
                if (this == PreviousAbilitySameTarget) {
                    return targetState != null && (targetState.getEnt() == lastDieCommand.target || contempEffect.getTargetingType() == TargetingType.Self && targetState.getEnt() == lastDieCommand.getSource());
                }
                if (this == PreviousDiceIdentical) {
                    return contempEffect.sameAs(eff);
                }
                return false;
            }
            case PreviousAbilitySame: {
                return EnumConditionalRequirement.lastNDiceValue(eff.getValue(), 1, s, sourceState.getEnt());
            }
            case PreviousTwoAbilitiesSame: {
                return EnumConditionalRequirement.lastNDiceValue(eff.getValue(), 2, s, sourceState.getEnt());
            }
            case PreviousFourAbilitiesSame: {
                return EnumConditionalRequirement.lastNDiceValue(eff.getValue(), 4, s, sourceState.getEnt());
            }
            case PreviousSixAbilitiesSame: {
                return EnumConditionalRequirement.lastNDiceValue(eff.getValue(), 6, s, sourceState.getEnt());
            }
            case RunOfTwo: {
                return this.lastNDiceStraight(eff.getValue(), 2, s);
            }
            case RunOfThree: {
                return this.lastNDiceStraight(eff.getValue(), 3, s);
            }
            case RunOfFive: {
                return this.lastNDiceStraight(eff.getValue(), 5, s);
            }
            case SixthDiceUsed: {
                return EnumConditionalRequirement.getNumDiceUsed(s) == 5;
            }
            case JustCastASpell: {
                TargetableCommand lastTargetableCommand = s.getPreviousCommandOfType(TargetableCommand.class);
                return lastTargetableCommand instanceof AbilityCommand;
            }
            case UnusedLastTurn: {
                return sourceState.getSnapshot().getTurn() > 1 && sourceState.getSnapshot().getSideIndicesFromTurnsAgoAndEnt(1, sourceState.getEnt()).isEmpty();
            }
            case MorePipsThanTarget: 
            case FewerPipsThanTarget: {
                if (sourceState == null || targetState == null) {
                    return false;
                }
                EntSide mySide = sourceState.getEnt().getDie().getCurrentSide();
                EntSide theirSide = targetState.getEnt().getDie().getCurrentSide();
                if (mySide == null || theirSide == null) {
                    return false;
                }
                boolean more = this == MorePipsThanTarget;
                int myVal = sourceState.getSideState(mySide).getCalculatedEffect().getValue();
                int theirVal = targetState.getSideState(theirSide).getCalculatedEffect().getValue();
                if (more) {
                    return myVal > theirVal;
                }
                return theirVal > myVal;
            }
            case SameFirstLetterAsTarget: {
                if (sourceState == null || targetState == null) {
                    return false;
                }
                return sourceState.getEnt().getName(false).toLowerCase().startsWith(targetState.getEnt().name.substring(0, 1).toLowerCase());
            }
        }
        throw new RuntimeException(this + "(reqs)");
    }

    private static int getNumDiceUsed(Snapshot s) {
        return s.getNumDiceUsedThisTurn();
    }

    private static boolean lastNDiceValue(int value, int N, Snapshot s, Ent source) {
        for (int i = 0; i < N; ++i) {
            DieCommand lastButOne = (DieCommand)s.getPreviousCommandOfType(i, DieCommand.class);
            if (lastButOne == null) {
                return false;
            }
            Eff contempEffect = s.getFightLog().getContemporaneousEffect(lastButOne);
            if (contempEffect == null) {
                return false;
            }
            if (contempEffect.getValue() == value) continue;
            return false;
        }
        return true;
    }

    private boolean lastNDiceStraight(int value, int ln, Snapshot s) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        for (int i = 0; i < ln - 1; ++i) {
            DieCommand lastButOne = (DieCommand)s.getPreviousCommandOfType(i, DieCommand.class);
            if (lastButOne == null) {
                return false;
            }
            Eff contempEffect = s.getFightLog().getContemporaneousEffect(lastButOne);
            if (contempEffect == null) {
                return false;
            }
            vals.add(contempEffect.getValue());
        }
        if (vals.size() != ln - 1) {
            return false;
        }
        Collections.reverse(vals);
        vals.add(value);
        return Tann.formsStraight(vals);
    }

    @Override
    public boolean preCalculate() {
        return this.preCalculate;
    }

    @Override
    public String getInvalidString(Eff eff) {
        return "invalid target?";
    }

    @Override
    public String describe(Eff eff) {
        return null;
    }

    @Override
    public String getBasicString() {
        switch (this) {
            case Top: {
                return "top";
            }
        }
        return "?!" + this.name();
    }

    @Override
    public Actor getRestrictionActor() {
        return new Pixl().text(this.getBasicString()).pix();
    }

    @Override
    public boolean isPlural() {
        return false;
    }
}

