/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.eff;

import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffType;

public enum TargetingType {
    Single(true),
    Self(false),
    Top(false),
    Bot(false),
    Mid(false),
    TopAndBot(false),
    Group(false),
    ALL(false),
    SpellSource(false),
    Untargeted(false);

    public final boolean requiresTarget;

    private TargetingType(boolean requiresTarget) {
        this.requiresTarget = requiresTarget;
    }

    public float affectValue(Eff e, boolean player, float value) {
        switch (this) {
            case Group: {
                if (!player && !e.isFriendly()) {
                    return value * 4.2f;
                }
                if (e.isFriendly()) {
                    return value *= 2.9f;
                }
                if (e.getType() == EffType.Damage) {
                    return value * 2.75f;
                }
                return value *= 2.9f;
            }
            case TopAndBot: {
                if (e.isFriendly()) {
                    return value * 1.15f;
                }
                return value * 1.5f;
            }
        }
        return value;
    }
}

