/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.trigger.global.GlobalAddHero;
import com.tann.dice.util.Tann;

public class PipeModAddHero
extends PipeRegexNamed<Modifier> {
    private static final PRNPart PREF = new PRNPref("add");

    public PipeModAddHero() {
        super(PREF, HERO);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        HeroType ht = HeroTypeUtils.byName(groups[0]);
        if (ht.isMissingno()) {
            return null;
        }
        return PipeModAddHero.make(ht);
    }

    public static Modifier make(HeroType input) {
        String name = PREF + input.getName(false);
        float tier = (float)((double)(-ModTierUtils.missingHero(1.0f)) * Math.pow(HeroTypeUtils.getEffectTierFor(input.getTier()) / HeroTypeUtils.getEffectTierFor(1), 0.6f));
        return new Modifier(tier, name, new GlobalAddHero(input));
    }

    @Override
    public Modifier example() {
        return PipeModAddHero.make(HeroTypeUtils.random());
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return !wild;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        if (wild) {
            return PipeModAddHero.make(PipeHeroGenerated.generate(Tann.random(HeroCol.basics()), Tann.randomInt(5)));
        }
        return this.example();
    }

    @Override
    public float getRarity(boolean wild) {
        if (!wild) {
            return 0.3f;
        }
        return super.getRarity(wild);
    }

    @Override
    public boolean showHigher() {
        return true;
    }
}

