/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.RenameUtils;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.util.Tann;
import java.util.List;

public class PipeItemPart
extends PipeRegexNamed<Item> {
    private static final PRNPart sep = new PRNMid("part");

    public PipeItemPart() {
        super(ITEM, sep, PipeRegexNamed.DIGIT);
    }

    @Override
    public Item example() {
        return this.make(ItemLib.random(), Tann.randomInt(2));
    }

    @Override
    protected Item internalMake(String[] groups) {
        String itemS = groups[0];
        String digStr = groups[1];
        if (PipeItemPart.bad(itemS, digStr)) {
            return null;
        }
        return this.make(ItemLib.byName(itemS), Integer.parseInt(digStr));
    }

    private Item make(Item src, int index) {
        if (index < 0 || src.isMissingno()) {
            return null;
        }
        List<Personal> trigs = src.getPersonalTriggers();
        if (trigs.size() < 2 || trigs.size() <= index) {
            return null;
        }
        ItBill ib = RenameUtils.copy(src, src.getName(false) + sep + index);
        List<Personal> trigs2 = ib.getTriggers();
        Personal only = trigs2.get(index);
        trigs2.clear();
        trigs2.add(only);
        return ib.bItem();
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

