/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.group;

import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.group.PartyLayoutType;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroAdjust;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.levelEndPhase.LevelEndPhase;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.endOfFight.HeroDeath;
import com.tann.dice.gameplay.save.PartyData;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.heroLevelupAffect.HeroGenType;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.generalPanels.InventoryPanel;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.Flasher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Party {
    private List<Hero> heroes;
    private List<Item> itemList = new ArrayList<Item>();
    private PartyLayoutType plt;
    private boolean fid = false;

    public static Party generate(int rewardsGained) {
        return Party.generate(rewardsGained, HeroGenType.Normal, new ArrayList<HeroType>());
    }

    public static Party generate(int rewardsGained, HeroGenType hgt, List<HeroType> avoid) {
        return Party.generate(rewardsGained, hgt, Party.getDefaultPLT(), avoid);
    }

    private static PartyLayoutType getDefaultPLT() {
        return PartyLayoutType.Basic;
    }

    public static Party generate(int rewardsGained, HeroGenType hgt, PartyLayoutType partyLayoutType, List<HeroType> avoid) {
        return new Party(Party.generateHeroes(rewardsGained, hgt, partyLayoutType, avoid), partyLayoutType);
    }

    public Party(List<Hero> heroes) {
        this.heroes = heroes;
        this.itemList = new ArrayList<Item>();
    }

    public Party(List<Hero> heroes, PartyLayoutType plt) {
        this(heroes);
        this.plt = plt;
    }

    private static HeroType[] heroLevel(HeroGenType hgt, PartyLayoutType plt, List<HeroType> old, int ... levels) {
        HeroCol[] cols = plt.getColsInstance();
        HeroType[] result = new HeroType[cols.length];
        int i = 0;
        ArrayList<HeroType> oldCopy = new ArrayList<HeroType>(old);
        for (HeroCol col : cols) {
            int lvl = levels[i];
            switch (hgt) {
                case Alternate: {
                    result[i] = PipeHeroAdjust.makeHeroAlternate(col, lvl);
                    break;
                }
                case Generate: {
                    result[i] = PipeHeroGenerated.generate(col, lvl);
                    break;
                }
                case Normal: {
                    result[i] = Party.makeNormal(plt, col, lvl, oldCopy);
                    break;
                }
                default: {
                    throw new RuntimeException((Object)((Object)hgt) + "ppppp");
                }
            }
            oldCopy.add(result[i]);
            ++i;
        }
        return result;
    }

    private static HeroType makeNormal(PartyLayoutType plt, HeroCol col, int lvl, List<HeroType> oldCopy) {
        for (int i = 0; i < 500; ++i) {
            HeroType ht = Tann.getSelectiveRandom(HeroTypeUtils.getFilteredTypes(col, lvl, false), 1, PipeHero.getMissingno(), new ArrayList(), oldCopy).get(0);
            if (ht.isMissingno() || HeroTypeUtils.bannedHeroTypeByCollision(ht, plt.getBannedCollisionBits(false))) continue;
            return ht;
        }
        return PipeHeroGenerated.generate(col, lvl);
    }

    private static List<Hero> generateHeroes(int rewardsGained, HeroGenType hgt, PartyLayoutType partyLayoutType, List<HeroType> old) {
        int[] levels = new int[partyLayoutType.length()];
        Arrays.fill(levels, -1);
        int levelBudget = levels.length + Math.min(rewardsGained + 1, 20) / 2;
        for (int i = 0; i < levels.length; ++i) {
            int thisLevel;
            levels[i] = thisLevel = levelBudget / (levels.length - i);
            levelBudget -= thisLevel;
        }
        Tann.shuffle(levels);
        ArrayList<Hero> result = new ArrayList<Hero>();
        for (HeroType type : Party.heroLevel(hgt, partyLayoutType, old, levels)) {
            if (PipeHeroGenerated.shouldAddGenerate()) {
                type = PipeHeroGenerated.generate(type.heroCol, type.getTier());
            }
            result.add(type.makeEnt());
        }
        return result;
    }

    public void onFirstInit(DungeonContext context) {
        if (this.fid) {
            TannLog.error("multi init");
            return;
        }
        this.fid = true;
        this.addItems(Party.generateItems(context.getCurrentMod20LevelNumber(), context));
        for (int i = 0; i < this.heroes.size(); ++i) {
            this.heroOnChooseStuff(context, this.heroes.get(i));
        }
    }

    public void heroOnChooseStuff(DungeonContext context, Hero hero) {
        for (Trait trait : hero.traits) {
            Personal p = trait.personal;
            p.onChoose(context, hero.getHeroType());
        }
    }

    private static List<Item> generateItems(int rewardsGained, DungeonContext context) {
        Item single;
        List<Item> loot;
        int quality;
        int i;
        ArrayList<Item> result = new ArrayList<Item>();
        for (i = 3; i <= rewardsGained && i < 20; i += 2) {
            quality = ItemLib.getStandardItemQualityFor(i, 0);
            loot = ItemLib.randomWithExactQuality(2, quality, context, result);
            if (loot == null || loot.size() <= 0) continue;
            single = loot.get(0);
            result.add(single);
        }
        for (i = 20; i < rewardsGained; ++i) {
            quality = ItemLib.getStandardItemQualityFor(i, 0);
            loot = ItemLib.randomWithExactQuality(2, quality, context, result);
            if (loot == null || loot.size() <= 0) continue;
            single = loot.get(0);
            result.add(single);
        }
        return result;
    }

    public static Party deserialise(String data) {
        ArrayList<Hero> heroes = new ArrayList<Hero>();
        for (String s : data.split(",")) {
            heroes.add(HeroTypeUtils.byName(s).makeEnt());
        }
        return new Party(heroes);
    }

    public List<Item> getItems() {
        return this.getItems(null);
    }

    public List<Item> getItems(Boolean equipped) {
        ArrayList<Item> result = new ArrayList<Item>();
        if (equipped == null) {
            result.addAll(this.getItems(true));
            result.addAll(this.getItems(false));
        } else if (equipped.booleanValue()) {
            for (Hero h : this.heroes) {
                result.addAll(h.getItems());
            }
        } else {
            result.addAll(this.itemList);
        }
        return result;
    }

    public void addItems(List<Item> items) {
        for (Item e : items) {
            this.addItem(e);
        }
    }

    public void addItem(Item item) {
        this.addItem(item, this.itemList.size());
    }

    public void addItem(Item item, int index) {
        if (index == -1) {
            index = this.itemList.size();
        }
        index = Math.min(this.itemList.size(), Math.max(0, index));
        this.itemList.add(index, item);
        InventoryPanel.get().reset();
        for (Hero h : this.getHeroes()) {
            h.updateOutOfCombat();
        }
    }

    public void removeItem(Item item) {
        if (!this.itemList.contains(item)) {
            return;
        }
        this.itemList.remove(item);
        InventoryPanel.get().reset();
    }

    public boolean unequip(Item selectedItem) {
        Ent equippee = this.getEquippee(selectedItem);
        if (equippee != null) {
            equippee.removeItem(selectedItem);
            this.refreshAllSlots();
            return true;
        }
        return false;
    }

    public void refreshAllSlots() {
        for (Ent ent : this.heroes) {
            List<Item> dropped = ent.refreshItemSlots();
            if (dropped == null) continue;
            this.itemList.addAll(dropped);
        }
        Tann.uniquify(this.itemList);
    }

    public void unequipAll() {
        for (Hero hero : this.heroes) {
            this.unequip(hero);
        }
    }

    public boolean unequip(Hero h) {
        boolean some = false;
        for (Item e : h.getItems()) {
            if (e == null || !this.unequip(e)) continue;
            this.itemList.add(e);
            e.setNew(true);
            some = true;
        }
        return some;
    }

    public Ent getEquippee(Item e) {
        for (Ent ent : this.heroes) {
            if (ent.getItemIndex(e) == null) continue;
            return ent;
        }
        return null;
    }

    public List<Hero> getHeroes() {
        return this.heroes;
    }

    public PartyData toSave() {
        int i;
        ArrayList<String> heroData = new ArrayList<String>();
        ArrayList<String> items = new ArrayList<String>();
        for (i = 0; i < this.heroes.size(); ++i) {
            heroData.add(this.heroes.get(i).fullSaveString());
        }
        for (i = 0; i < this.itemList.size(); ++i) {
            items.add(this.itemList.get(i).getSaveString());
        }
        return new PartyData(heroData, items, this.plt);
    }

    public Party(PartyData partyData) {
        this.heroes = new ArrayList<Hero>();
        this.plt = partyData.plt;
        for (String hd : partyData.h) {
            this.heroes.add(HeroTypeUtils.makeHeroFromString(hd));
        }
        this.itemList.addAll(ItemLib.deserialise(partyData.e));
    }

    public boolean hasAnyItems() {
        if (this.itemList.size() > 0) {
            return true;
        }
        for (Hero h : this.heroes) {
            if (h.getItems().size() <= 0) continue;
            return true;
        }
        return DungeonScreen.get().partyManagementPanel.isDragging();
    }

    public List<Item> getForcedItems() {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item e : this.getItems(false)) {
            if (!e.isForceEquip()) continue;
            result.add(e);
        }
        return result;
    }

    public int getProbableLevel() {
        int result = 1;
        for (Hero h : this.getHeroes()) {
            result += h.getHeroType().level - 1;
        }
        return result += this.itemList.size();
    }

    public void discardItem(Item discarded) {
        for (Hero h : this.heroes) {
            boolean lost = h.removeItem(discarded) >= 0;
            if (!lost) continue;
            this.refreshAllSlots();
        }
        this.itemList.remove(discarded);
    }

    public TP<int[], int[]> getWholePartyHash() {
        int[] hps = new int[this.getHeroes().size() * 2];
        int[] sideHashes = new int[this.getHeroes().size() * 6];
        for (int heroIndex = 0; heroIndex < this.getHeroes().size(); ++heroIndex) {
            Hero h = this.getHeroes().get(heroIndex);
            EntState es = h.getState(FightLog.Temporality.Present);
            hps[heroIndex * 2] = es.getHp();
            hps[heroIndex * 2 + 1] = es.getMaxHp();
            int[] hashes = h.getSideHashes();
            System.arraycopy(hashes, 0, sideHashes, heroIndex * 6, 6);
        }
        return new TP<int[], int[]>(hps, sideHashes);
    }

    public Hero getHeroFor(HeroType type, int index) {
        boolean takeFirst;
        if (type.isMissingno()) {
            return this.getLowestHero();
        }
        ArrayList<Hero> options = null;
        boolean bl = takeFirst = index == 0;
        if (!takeFirst) {
            options = new ArrayList<Hero>();
        }
        for (Hero h : this.getHeroes()) {
            HeroType current = h.getHeroType();
            if (current.heroCol != type.heroCol || current.level != type.level - 1 || !h.canLevelUp()) continue;
            if (takeFirst) {
                return h;
            }
            options.add(h);
        }
        if (takeFirst || options.size() == 0) {
            return this.getLowestHero();
        }
        return (Hero)options.get(index % options.size());
    }

    private Hero getLowestHero() {
        int lowestLevel = 5000;
        Hero current = null;
        for (Hero h : this.getHeroes()) {
            if (h.getLevel() >= lowestLevel) continue;
            lowestLevel = h.getLevel();
            current = h;
        }
        return current;
    }

    public void levelUpTo(HeroType heroType, int index) {
        Hero h = this.getHeroFor(heroType, index);
        if (h != null) {
            String oldHeroName = h.getName(true);
            h.levelUpTo(heroType, DungeonScreen.getCurrentContextIfInGame());
            h.getEntPanel().addActor(new Flasher(h.getEntPanel(), Colours.light, 0.5f));
            LevelEndPhase.unequipHero(this, h, oldHeroName);
            this.onHeroMakeupChange();
        } else {
            TannLog.log("Can't find hero for " + heroType, TannLog.Severity.error);
        }
    }

    public void addHero(Hero extraHero, HeroType underMe, DungeonContext dc) {
        int index = this.heroes.size();
        for (Hero h : this.heroes) {
            if (h.getHeroType() != underMe) continue;
            index = this.heroes.indexOf(h) + 1;
        }
        this.heroes.add(index, extraHero);
        this.updateStatsAfterAdded(extraHero, index, dc);
        this.heroOnChooseStuff(dc, extraHero);
    }

    public void kill(Hero h, DungeonContext dc) {
        int index = this.heroes.indexOf(h);
        this.heroes.remove(h);
        this.addItems(h.getItems());
        this.updateStatsAfterKilled(h, index, dc);
    }

    private void updateStatsAfterKilled(Hero removed, int oldIndex, DungeonContext context) {
        if (context.getContextConfig().mode.skipStats()) {
            return;
        }
        Map<String, Stat> stats = context.getStatsManager().getStatsMap();
        for (int i = oldIndex; i < this.heroes.size(); ++i) {
            Stat iStat = stats.get(HeroDeath.getNameFromIndex(i));
            Stat iPlusStat = stats.get(HeroDeath.getNameFromIndex(i + 1));
            iStat.setValue(iPlusStat.getValue());
        }
        Stat s = stats.get(HeroDeath.getNameFromIndex(this.heroes.size()));
        if (s == null) {
            TannLog.log("Something failed trying to update stats after killed hero: " + removed);
        } else {
            context.getStatsManager().removeStat(s);
        }
    }

    private void updateStatsAfterAdded(Hero added, int atIndex, DungeonContext context) {
        if (context.getContextConfig().mode.skipStats()) {
            return;
        }
        HeroDeath heroDeath = new HeroDeath(this.heroes.size() - 1);
        context.getStatsManager().addStat(heroDeath);
        Map<String, Stat> stats = context.getStatsManager().getStatsMap();
        for (int i = this.heroes.size() - 1; i > atIndex; --i) {
            Stat iStat = stats.get(HeroDeath.getNameFromIndex(i));
            Stat iMinusStat = stats.get(HeroDeath.getNameFromIndex(i - 1));
            iStat.setValue(iMinusStat.getValue());
        }
        stats.get(HeroDeath.getNameFromIndex(atIndex)).setValue(0);
    }

    private void updateStatsAfterSwapped(DungeonContext context, int swapA, int swapB) {
        Map<String, Stat> stats = context.getStatsManager().getStatsMap();
        Stat statA = stats.get(HeroDeath.getNameFromIndex(swapA));
        Stat statB = stats.get(HeroDeath.getNameFromIndex(swapB));
        if (statA == null || statB == null) {
            TannLog.log("stat swap error " + swapA + "/" + swapB, TannLog.Severity.error);
            return;
        }
        int aVal = statA.getValue();
        statA.setValue(statB.getValue());
        statB.setValue(aVal);
    }

    public void swapHeroes(DungeonContext dc, int swapA, int swapB) {
        if (swapA == swapB || swapA >= this.heroes.size() || swapB >= this.heroes.size()) {
            TannLog.log("error swapping " + swapA + " and " + swapB, TannLog.Severity.error);
            return;
        }
        Hero a = this.heroes.get(swapA);
        Hero b = this.heroes.get(swapB);
        this.heroes.set(swapA, b);
        this.heroes.set(swapB, a);
        this.updateStatsAfterSwapped(dc, swapA, swapB);
    }

    public void onHeroMakeupChange() {
        this.refreshAllSlots();
    }

    public Hero getByType(HeroType type) {
        for (int i = 0; i < this.heroes.size(); ++i) {
            Hero h = this.heroes.get(i);
            if (h.entType != type) continue;
            return h;
        }
        return null;
    }

    public void afterEquip() {
        Main.self().masterStats.getUnlockManager().afterEquip(this);
    }

    public boolean anyNewItems() {
        for (Item t : this.getItems()) {
            if (!t.isNew()) continue;
            return true;
        }
        return false;
    }

    public void clearBagItems() {
        this.itemList.clear();
    }

    public long getBannedCollisionBits() {
        return this.getBannedCollisionBits(true);
    }

    public long getBannedCollisionBits(boolean spellRequiresTwo) {
        ArrayList<HeroCol> cols = new ArrayList<HeroCol>();
        for (int i = 0; i < this.heroes.size(); ++i) {
            HeroCol hc = this.heroes.get(i).getHeroCol();
            cols.add(hc);
        }
        return Party.getBannedCollisionBits(cols, spellRequiresTwo);
    }

    public static long getBannedCollisionBits(List<HeroCol> cols, boolean spellRequiresTwo) {
        boolean hasOrange = false;
        boolean hasYellow = false;
        boolean hasGrey = false;
        boolean hasRed = false;
        boolean hasBlue = false;
        boolean hasGreen = false;
        int numSpells = 0;
        float numPhysical = 0.0f;
        block12: for (int i = 0; i < cols.size(); ++i) {
            HeroCol hc = cols.get(i);
            if (hc != null && hc.isSpelly()) {
                ++numSpells;
            }
            if (hc == null) continue;
            switch (hc) {
                case orange: {
                    hasOrange = true;
                    break;
                }
                case yellow: {
                    hasYellow = true;
                    break;
                }
                case grey: {
                    hasGrey = true;
                    break;
                }
                case red: {
                    hasRed = true;
                    break;
                }
                case blue: {
                    hasBlue = true;
                    break;
                }
                case green: {
                    hasGreen = true;
                }
            }
            switch (hc) {
                case orange: 
                case yellow: {
                    numPhysical += 1.0f;
                    continue block12;
                }
                case green: {
                    numPhysical += 0.5f;
                }
            }
        }
        long result = 0L;
        if (numSpells < 1 + (spellRequiresTwo ? 1 : 0)) {
            result |= Collision.SPELL;
        }
        int n = spellRequiresTwo ? 1 : 0;
        if (numPhysical < (float)(1 + n)) {
            result |= Collision.PHYSICAL_DAMAGE;
        }
        if (!hasOrange) {
            result |= Collision.COL_ORANGE;
        }
        if (!hasYellow) {
            result |= Collision.COL_YELLOW;
        }
        if (!hasGrey) {
            result |= Collision.COL_GREY;
        }
        if (!hasRed) {
            result |= Collision.COL_RED;
        }
        if (!hasBlue) {
            result |= Collision.COL_BLUE;
        }
        if (!hasGreen) {
            result |= Collision.COL_GREEN;
        }
        if (!hasGrey) {
            result |= Collision.SHIELD;
        }
        if (!hasRed) {
            result |= Collision.HEAL;
        }
        return result;
    }

    public int colIndex(HeroCol heroCol) {
        for (int i = 0; i < this.heroes.size(); ++i) {
            if (this.heroes.get(i).getHeroCol() != heroCol) continue;
            return i;
        }
        return -1;
    }

    public boolean allowBurst() {
        return (this.getBannedCollisionBits(false) & Collision.SPELL) == 0L || this.anyHeroesWithBaseMana();
    }

    private boolean anyHeroesWithBaseMana() {
        for (int i = 0; i < this.heroes.size(); ++i) {
            Hero h = this.heroes.get(i);
            EntSide[] sides = h.getSides();
            for (int j = 0; j < sides.length; ++j) {
                if ((sides[j].getBaseEffect().getCollisionBits(true) & Collision.SPELL) == 0L) continue;
                return true;
            }
        }
        return false;
    }

    public boolean anyDuplicateCols() {
        ArrayList<HeroCol> cols = new ArrayList<HeroCol>();
        for (Hero hero : this.heroes) {
            cols.add(hero.getHeroCol());
        }
        Tann.clearDupes(cols);
        return cols.size() != this.heroes.size();
    }

    public boolean randomiseEquipment() {
        this.unequipAll();
        if (this.itemList.isEmpty()) {
            return false;
        }
        Collections.shuffle(this.itemList);
        ArrayList<Hero> heroes = new ArrayList<Hero>(this.getHeroes());
        block0: for (Item item : new ArrayList<Item>(this.itemList)) {
            Collections.shuffle(heroes);
            for (Hero hero : heroes) {
                if (!item.canEquip(hero) || hero.getNumberItemSlots() <= hero.getItems().size()) continue;
                hero.addItem(item);
                this.removeItem(item);
                continue block0;
            }
        }
        return true;
    }

    public void curseReset(DungeonContext dc) {
        if (this.plt == null) {
            this.plt = PartyLayoutType.Basic;
        }
        this.fid = false;
        this.clearBagItems();
        this.heroes = Party.generateHeroes(0, HeroGenType.Normal, this.plt, new ArrayList<HeroType>());
        this.onFirstInit(dc);
        for (Hero h : this.getHeroes()) {
            h.updateOutOfCombat();
        }
    }

    public PartyLayoutType getPLT() {
        return this.plt;
    }
}

