/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.die.side;

import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.EnSiBi;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobBig;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobHuge;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobSmall;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class EntSidesLib {
    private static List<EntSide> valueOne;
    private static final List<Object> STATIC_SIDES_REG;
    private static final List<Object> STATIC_SIDES_BIG;
    private static final List<Object> STATIC_SIDES_SMALL;
    private static final List<Object> STATIC_SIDES_HUGE;

    public static EntSide getSide(EffType type, boolean basicOnly) {
        switch (type) {
            case Damage: {
                return basicOnly ? ESB.dmg.val(1) : ESB.genericSword;
            }
            case Heal: {
                return basicOnly ? ESB.heal.val(1) : ESB.genericHeal;
            }
            case Shield: {
                return basicOnly ? ESB.shield.val(1) : ESB.genericShield;
            }
            case Mana: {
                return basicOnly ? ESB.mana.val(1) : ESB.genericMana;
            }
            case Summon: {
                return ESB.genericSummon;
            }
            case Blank: {
                return ESB.blank;
            }
            case Recharge: {
                if (basicOnly) break;
                return ESB.recharge;
            }
        }
        throw new RuntimeException("No side for " + (Object)((Object)type) + "/" + basicOnly);
    }

    public static EntSide getBlank(ChoosableType cht) {
        if (cht == null) {
            return ESB.blank;
        }
        switch (cht) {
            case Item: {
                return ESB.blankItem;
            }
            case Modifier: {
                return ESB.blankCurse;
            }
        }
        return ESB.blank;
    }

    public static void clearStatics() {
        valueOne = null;
    }

    public static EntSide withValue(Object side, int val) {
        if (side instanceof EntSide) {
            return (EntSide)side;
        }
        if (side instanceof EnSiBi) {
            return ((EnSiBi)side).val(val);
        }
        TannLog.error("errside: " + side);
        return ESB.blankBug;
    }

    public static List<EntSide> getAllSidesWithValue() {
        if (valueOne == null) {
            ArrayList<EntSide> sides = new ArrayList<EntSide>();
            for (Object side : STATIC_SIDES_REG) {
                sides.add(EntSidesLib.withValue(side, 1));
            }
            valueOne = sides;
        }
        return valueOne;
    }

    public static List<EntSide> getBasicSides() {
        ArrayList<EntSide> result = new ArrayList<EntSide>();
        for (EntSide es : EntSidesLib.getAllSidesWithValue()) {
            if (!es.getBaseEffect().isBasic()) continue;
            result.add(es);
        }
        return result;
    }

    public static List<EntSide> exampleKeywordSides(Keyword keyword) {
        ArrayList<EntSide> result = new ArrayList<EntSide>();
        for (EntSide es : Arrays.asList(ESB.dmg.val(1), ESB.heal.val(1), ESB.mana.val(1), ESB.dmgAll.val(1), ESB.blank, ESB.stun, ESB.undying)) {
            if (!KUtils.allowAddingKeyword(keyword, es.getBaseEffect())) continue;
            result.add(es);
        }
        return result;
    }

    public static EntSide random(Random r, boolean crazy) {
        return EntSidesLib.random(r, crazy, EntSize.reg);
    }

    private static EntSide random(Random r, boolean crazy, EntSize size) {
        if (size == EntSize.reg && !crazy) {
            return HeroTypeUtils.random((Random)r).sides[r.nextInt(6)];
        }
        return EntSidesLib.withValue(Tann.randomElement(EntSidesLib.getSizedSides(size), r), r.nextInt(10) - 2);
    }

    public static List<Object> getSizedSides(EntSize size) {
        switch (size) {
            default: {
                return STATIC_SIDES_SMALL;
            }
            case reg: {
                return STATIC_SIDES_REG;
            }
            case big: {
                return STATIC_SIDES_BIG;
            }
            case huge: 
        }
        return STATIC_SIDES_HUGE;
    }

    public static EntSide random(Random r) {
        return EntSidesLib.random(r, EntSize.reg);
    }

    public static EntSide random(Random r, EntSize size) {
        return EntSidesLib.random(r, false, size);
    }

    static {
        STATIC_SIDES_REG = ESB.makeAllSidesReg();
        STATIC_SIDES_BIG = EntSidesBlobBig.makeAll();
        STATIC_SIDES_SMALL = EntSidesBlobSmall.makeAll();
        STATIC_SIDES_HUGE = EntSidesBlobHuge.makeAll();
    }
}

