/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.die.side;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.Side;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.trigger.personal.Dodge;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.Stunned;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.bullet.DieShader;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EntSide
extends Side {
    private final TextureRegion tr;
    private final Eff baseEffect;
    public EntSize size = EntSize.reg;
    static final Color MULT_COL = Colours.orange;
    List<Keyword> tmp = new ArrayList<Keyword>();
    static final Color pipCol = Colours.light;
    private boolean generic;

    public EntSide(TextureRegion tr, Eff effect, EntSize size) {
        if (tr == null) {
            tr = ImageUtils.loadExt3d(size.name() + "/face/placeholder");
        }
        this.tr = tr;
        this.baseEffect = effect.copy();
        this.size = size;
    }

    public EntSide copy() {
        return new EntSide(this.tr, this.baseEffect, this.size);
    }

    public static EntSide[] copy(EntSide[] sides) {
        EntSide[] result = new EntSide[sides.length];
        for (int i = 0; i < sides.length; ++i) {
            result[i] = sides[i].copy();
        }
        return result;
    }

    private void drawTexture(Batch batch, float x, float y) {
        batch.setColor(Colours.z_white);
        batch.draw(this.getTexture2D(), x, y);
    }

    public void drawWithMultiplier(Batch batch, float x, float y, Color col, int multipler) {
        super.draw(batch, null, x, y, col, null);
        this.drawTexture(batch, x, y);
        batch.setColor(MULT_COL);
        for (int i = 0; i < multipler; ++i) {
            batch.draw(Images.multiplier, x + (float)this.getTexture2D().getRegionWidth() - 5.0f, y + 2.0f + (float)(i * 4));
        }
        if (Math.abs(multipler) == 1) {
            batch.setColor(MULT_COL);
            batch.draw(Images.keepKeywords, x + (float)this.getTexture2D().getRegionWidth() - 4.0f, y + 2.0f);
        }
    }

    public void drawWithBonus(Batch batch, float x, float y, Color col, int add) {
        super.draw(batch, null, x, y, col, null);
        this.drawTexture(batch, x, y);
        batch.setColor(Colours.light);
        for (int i = 0; i < add; ++i) {
            batch.draw(Images.plus, x + (float)this.getTexture2D().getRegionWidth() - 5.0f, y + 2.0f + (float)(i * 4));
        }
    }

    public static void drawBonusKeyword(Batch batch, float x, float y, Keyword keyword, int index) {
        EntSide.drawBonusKeyword(batch, x, y, keyword, index, EntSize.reg);
    }

    public static void drawBonusKeyword(Batch batch, float x, float y, Keyword keyword, int index, EntSize size) {
        TextureRegion image = ImageUtils.get2DIfPossible(keyword.getImage(size));
        int diffW = size.getPixels() - image.getRegionWidth();
        int diffH = size.getPixels() - image.getRegionHeight();
        int xFlip = index > 1 ? 1 : 0;
        int yFlip = index == 1 || index == 2 ? 1 : 0;
        batch.setColor(Colours.z_white);
        Draw.drawFlipped(batch, image, x + 1.0f + (float)(xFlip * (diffW - 2)), y + 1.0f + (float)(yFlip * (diffH - 2)), xFlip == 1 && keyword.isFlipCorner(), yFlip == 1 && keyword.isFlipCorner());
    }

    @Override
    public void draw(Batch batch, Ent source, float x, float y, Color colour, TextureRegion lapel2D) {
        int px;
        EntSize fromPx;
        super.draw(batch, source, x, y, colour, lapel2D);
        Eff e = this.getBaseEffect();
        TextureRegion tex = this.getTexture2D();
        int bonus = 0;
        Color bc = Colours.purple;
        this.tmp.clear();
        List<Keyword> bonusKeywords = this.tmp;
        if (source != null) {
            EntSideState ss = this.findState(FightLog.Temporality.Visual, source);
            bonus = ss.getTotalBonus();
            bc = DieShader.bonusColDisplay(ss.getBonusColIndex());
            if (bc == Colours.dark) {
                bc = Colours.light;
            }
            e = ss.getCalculatedEffect();
            bonusKeywords.addAll(ss.getBonusKeywords());
            tex = ss.getCalculatedTexture();
            tex = ImageUtils.get2DIfPossible(tex);
        } else {
            bonusKeywords.addAll(this.getBaseEffect().getBonusKeywords());
        }
        Tann.clearDupes(bonusKeywords);
        batch.setColor(Colours.z_white);
        batch.draw(tex, x, y);
        EntSize size = source != null ? source.getSize() : ((fromPx = EntSize.getFromPx(px = tex.getRegionWidth())) != null ? fromPx : EntSize.reg);
        if (bonusKeywords != null) {
            for (int i = 0; i < bonusKeywords.size() && i < 4; ++i) {
                Keyword k = bonusKeywords.get(i);
                EntSide.drawBonusKeyword(batch, x, y, k, i, size);
            }
        }
        if (e.hasValue()) {
            EntSide.drawPipsSinglePixelSquish(batch, size, e.getValue(), bonus, bc, (int)x, (int)y);
        }
        if (lapel2D != null) {
            batch.setColor(Colours.z_white);
            batch.draw(lapel2D, x, y);
        }
    }

    public static void drawPipsSinglePixelSquish(Batch batch, EntSize size, int value, int bonus, Color bc, int x, int y) {
        int PIP_WIDTH = size.getPipWidth();
        if (value <= 0) {
            batch.setColor(Colours.red);
            Draw.fillRectangle(batch, x + size.getPixels() - 2 - PIP_WIDTH, y + 2, 1.0f, 1.0f);
            Draw.fillRectangle(batch, x + size.getPixels() - 2 - PIP_WIDTH + 1, y + 3, 1.0f, 1.0f);
        }
        if (value > EntSide.getMaxPips(size.getPixels() - 4)) {
            if (bonus == 0) {
                batch.setColor(Colours.light);
            } else if (bc == Colours.light) {
                batch.setColor(DieShader.getWhiteFlash());
            } else {
                batch.setColor(bc);
            }
            Draw.fillRectangle(batch, x + size.getPixels() - 2 - PIP_WIDTH, y + 2, PIP_WIDTH, size.getPixels() - 4);
            return;
        }
        Color bonusCol = bc;
        int groupSize = 5;
        boolean pixSize = true;
        int blockSize = 3;
        int finalFive = value / 5 * 5;
        int pipY = y + 2;
        for (int i = 0; i < value; ++i) {
            boolean partOfSingle;
            boolean bl = partOfSingle = i >= finalFive - 1;
            if (partOfSingle) {
                batch.setColor(i >= value - bonus ? bonusCol : pipCol);
                Draw.fillRectangle(batch, x + size.getPixels() - 2 - PIP_WIDTH, pipY, PIP_WIDTH, 1.0f);
                pipY += 2;
                continue;
            }
            batch.setColor(i >= value - bonus ? bonusCol : pipCol);
            Draw.fillRectangle(batch, x + size.getPixels() - 2 - PIP_WIDTH, pipY, 1.0f, 3.0f);
            batch.setColor(i + 5 - 1 >= value - bonus ? bonusCol : pipCol);
            Draw.fillRectangle(batch, x + 1 + size.getPixels() - 2 - PIP_WIDTH, pipY, PIP_WIDTH - 1, 3.0f);
            pipY += 4;
            i += 4;
        }
    }

    public static int getMaxPips(int availableSpace) {
        return (availableSpace - 3) / 4 * 5 + (availableSpace - 3) % 4 / 2 + 2;
    }

    @Override
    public TextureRegion getTexture() {
        return this.tr;
    }

    public TextureRegion getTexture2D() {
        return ImageUtils.get2DIfPossible(this.tr);
    }

    public Eff getBaseEffect() {
        return this.baseEffect;
    }

    public String toString(Ent source) {
        if (source == null) {
            return this.getBaseEffect().describe();
        }
        return this.findState(FightLog.Temporality.Visual, source).describe();
    }

    public EntSideState findState(FightLog.Temporality temporality, Ent source) {
        return source.getState(temporality).getSideState(this);
    }

    public static int badHash(Eff e) {
        return EntSide.badHash(e, 7);
    }

    public static int badHash(Eff e, int base) {
        int hash = base;
        if (e.getRestrictions().size() > 0) {
            return -1;
        }
        if (e.getBuff() != null) {
            return -1;
        }
        if (e.getSummonType() != null) {
            return -1;
        }
        if (e.getType() == EffType.Or) {
            return -1;
        }
        hash += 31 * hash * e.getType().hashCode();
        hash += 33 * hash * e.getTargetingType().hashCode();
        int keywords = 1;
        for (Keyword k : e.getKeywords()) {
            keywords += k.hashCode() * k.hashCode() * 3;
        }
        hash += 41 * hash * keywords;
        return hash;
    }

    public Actor makeBasicSideActor(final int bonus, final boolean multiplier, final Keyword keyword) {
        Actor a = new Actor(){
            {
                this.setSize(EntSide.this.size.getPixels(), EntSide.this.size.getPixels());
            }

            @Override
            public void draw(Batch batch, float parentAlpha) {
                Color col = Colours.AS_BORDER;
                if (keyword != null) {
                    EntSide.drawBonusKeyword(batch, this.getX(), this.getY(), keyword, 0);
                }
                if (bonus != 0) {
                    if (multiplier) {
                        EntSide.this.drawWithMultiplier(batch, this.getX(), this.getY(), col, bonus);
                    } else {
                        EntSide.this.drawWithBonus(batch, this.getX(), this.getY(), col, bonus);
                    }
                }
                if (bonus == 0 && keyword == null) {
                    EntSide.this.draw(batch, null, this.getX(), this.getY(), col, null);
                }
                super.draw(batch, parentAlpha);
            }
        };
        return a;
    }

    public float getEffectTier(EntType type) {
        boolean player = type instanceof HeroType;
        int tier = player ? ((HeroType)type).level : 1;
        return EntSide.getValueFromEffect(this.getBaseEffect(), tier, type, player);
    }

    public static float getValueFromEffect(Eff e, int tier, EntType type, boolean player) {
        Float hackyOverride = EntSide.checkForHackyOverride(e, tier, type, player);
        if (hackyOverride != null) {
            return hackyOverride.floatValue();
        }
        float effectivePips = e.getValue();
        for (Keyword k : e.getKeywords()) {
            effectivePips = KUtils.affectBaseValue(k, e, tier, effectivePips, player);
        }
        float effValue = e.getType().getEffectTier(tier, effectivePips, player, e);
        effValue = e.getTargetingType().affectValue(e, player, effValue);
        for (Keyword k : e.getKeywords()) {
            float mult = KUtils.getValueMultiplier(k, e, player, tier);
            if (mult == -1.0f) {
                return -1.0f;
            }
            effValue *= mult;
        }
        if (!e.hasKeyword(Keyword.mandatory)) {
            effValue = Math.max(0.0f, effValue);
        }
        for (Keyword k : e.getKeywords()) {
            effValue = KUtils.getFinalEffectTierAdjustment(k, e, effValue, tier, type);
        }
        return effValue;
    }

    private static Float checkForHackyOverride(Eff e, int tier, EntType type, boolean player) {
        List<Keyword> keywords;
        Personal p;
        if (e.getType() == EffType.Blank && e.hasKeyword(Keyword.stasis)) {
            return Float.valueOf(-HeroTypeUtils.getEffectTierFor(tier) * 0.75f);
        }
        if (e.getType() == EffType.RedirectIncoming) {
            return Float.valueOf(0.1f + EffType.Shield.getEffectTier(tier, e.getValue(), player, new EffBill().shield(e.getValue()).bEff()));
        }
        if (e.getType() == EffType.Buff && e.getBuff().trigger instanceof Stunned) {
            if (e.getRestrictions().size() > 0) {
                return Float.valueOf((float)Math.pow(type.hp, 1.3) * 0.12f);
            }
            if (e.hasKeyword(Keyword.singleUse)) {
                return Float.valueOf(1.5f + (float)tier * 2.0f);
            }
        }
        if (e.hasKeyword(Keyword.death) && e.getType() == EffType.Summon) {
            MonsterType mt = MonsterTypeLib.byName(e.getSummonType());
            return Float.valueOf((float)e.getValue() * mt.getSummonValue() * 0.85f);
        }
        if (e.getType() == EffType.Buff && (p = e.getBuff().trigger) instanceof AffectSides && (keywords = p.getReferencedKeywords()).contains((Object)Keyword.cantrip) && keywords.contains((Object)Keyword.death)) {
            return Float.valueOf(5.0f);
        }
        if (e.getType() == EffType.Kill && e.getTargetingType() == TargetingType.Top) {
            return Float.valueOf(HeroTypeUtils.getHpFor(3) * 3.0f);
        }
        return null;
    }

    public float getApproxTotalEffectTier(EntType type) {
        return this.getEffectTier(type) + this.getExtraFlatEffectTier(type) * 4.0f;
    }

    public float getExtraFlatEffectTier(EntType type) {
        int tier = type instanceof HeroType ? ((HeroType)type).level : 1;
        Eff e = this.getBaseEffect();
        if (e.getType() == EffType.Blank) {
            return 0.0f;
        }
        if (e.hasKeyword(Keyword.death)) {
            if (e.hasKeyword(Keyword.enduring)) {
                return -HeroTypeUtils.getEffectTierFor(tier) * 0.025f;
            }
            float basePower = this.getEffectTier(type);
            if (basePower < 0.0f) {
                return basePower / 3.0f;
            }
        }
        if (e.hasKeyword(Keyword.cantrip)) {
            float baseValue = this.withKeyword(Keyword.mandatory).getEffectTier(type);
            float alreadyTakenMultiplier = KUtils.cantripTreatAsSingle(e, tier) ? 0.5f : 1.0f;
            float rollLikelinessMultiplier = 0.5f;
            float cantripMultiplier = e.getType().getCantripMultiplier();
            float multiMulti = rollLikelinessMultiplier * cantripMultiplier * alreadyTakenMultiplier;
            switch (e.getType()) {
                case Reroll: {
                    return ((float)tier * 0.35f + 0.35f) * (float)e.getValue() * rollLikelinessMultiplier;
                }
                case Heal: 
                case Damage: 
                case Shield: {
                    return baseValue * multiMulti * 0.7f;
                }
                case Mana: {
                    return baseValue * multiMulti;
                }
                case Buff: {
                    if (e.getBuff().trigger instanceof Dodge) {
                        return e.getBuff().getEffectTier(e.getValue(), tier) * multiMulti * 0.7f;
                    }
                    return Float.NaN;
                }
            }
            return Float.NaN;
        }
        return 0.0f;
    }

    public EntSide withKeyword(Keyword k) {
        EntSide copy = this.copy();
        copy.getBaseEffect().addKeyword(k);
        return copy;
    }

    public EntSide withKeyword(Keyword ... ks) {
        EntSide copy = this.copy();
        copy.getBaseEffect().addKeywords(Arrays.asList(ks));
        return copy;
    }

    public EntSide withValue(int value) {
        EntSide copy = this.copy();
        copy.getBaseEffect().setValue(value);
        return copy;
    }

    public String toString() {
        String sideName = ((TextureAtlas.AtlasRegion)this.getTexture()).name;
        while (sideName.contains("/")) {
            sideName = sideName.substring(sideName.indexOf("/") + 1);
        }
        String val = this.baseEffect.hasValue() ? " " + this.baseEffect.getValue() : "";
        return sideName + val;
    }

    public EntSide generic() {
        this.generic = true;
        return this;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public boolean isProbablyFromPlayer() {
        if (this.size != EntSize.reg) {
            return false;
        }
        for (EntType entType : HeroTypeLib.getMasterCopy()) {
            for (EntSide es : entType.sides) {
                if (es.getTexture() != this.getTexture()) continue;
                return true;
            }
        }
        for (EntType entType : MonsterTypeLib.getMasterCopy()) {
            for (EntSide es : entType.sides) {
                if (es.getTexture() != this.getTexture()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sameTexture(EntSide es) {
        return this.getTexture() == es.getTexture();
    }

    public boolean same(EntSide es) {
        return this.sameTexture(es) && this.getBaseEffect().getValue() == es.getBaseEffect().getValue() && this.getBaseEffect().getBonusKeywords().equals(es.getBaseEffect().getBonusKeywords());
    }
}

