/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.collision.RayResultCallback;
import com.badlogic.gdx.physics.bullet.collision.btAABB;
import com.badlogic.gdx.physics.bullet.collision.btCollisionShape;
import com.badlogic.gdx.physics.bullet.collision.btConcaveShape;
import com.badlogic.gdx.physics.bullet.collision.btGImpactQuantizedBvh;
import com.badlogic.gdx.physics.bullet.collision.btPrimitiveManagerBase;
import com.badlogic.gdx.physics.bullet.collision.btPrimitiveTriangle;
import com.badlogic.gdx.physics.bullet.collision.btTetrahedronShapeEx;
import com.badlogic.gdx.physics.bullet.collision.btTriangleCallback;
import com.badlogic.gdx.physics.bullet.collision.btTriangleShapeEx;

public class btGImpactShapeInterface
extends btConcaveShape {
    private long swigCPtr;

    protected btGImpactShapeInterface(String className, long cPtr, boolean cMemoryOwn) {
        super(className, CollisionJNI.btGImpactShapeInterface_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btGImpactShapeInterface(long cPtr, boolean cMemoryOwn) {
        this("btGImpactShapeInterface", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(CollisionJNI.btGImpactShapeInterface_SWIGUpcast(this.swigCPtr), cMemoryOwn);
    }

    public static long getCPtr(btGImpactShapeInterface obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_btGImpactShapeInterface(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void updateBound() {
        CollisionJNI.btGImpactShapeInterface_updateBound(this.swigCPtr, this);
    }

    public void postUpdate() {
        CollisionJNI.btGImpactShapeInterface_postUpdate(this.swigCPtr, this);
    }

    public btAABB getLocalBox() {
        return new btAABB(CollisionJNI.btGImpactShapeInterface_getLocalBox(this.swigCPtr, this), false);
    }

    @Override
    public int getShapeType() {
        return CollisionJNI.btGImpactShapeInterface_getShapeType(this.swigCPtr, this);
    }

    public int getGImpactShapeType() {
        return CollisionJNI.btGImpactShapeInterface_getGImpactShapeType(this.swigCPtr, this);
    }

    public btGImpactQuantizedBvh getBoxSet() {
        long cPtr = CollisionJNI.btGImpactShapeInterface_getBoxSet(this.swigCPtr, this);
        return cPtr == 0L ? null : new btGImpactQuantizedBvh(cPtr, false);
    }

    public boolean hasBoxSet() {
        return CollisionJNI.btGImpactShapeInterface_hasBoxSet(this.swigCPtr, this);
    }

    public btPrimitiveManagerBase getPrimitiveManager() {
        long cPtr = CollisionJNI.btGImpactShapeInterface_getPrimitiveManager(this.swigCPtr, this);
        return cPtr == 0L ? null : new btPrimitiveManagerBase(cPtr, false);
    }

    public int getNumChildShapes() {
        return CollisionJNI.btGImpactShapeInterface_getNumChildShapes(this.swigCPtr, this);
    }

    public boolean childrenHasTransform() {
        return CollisionJNI.btGImpactShapeInterface_childrenHasTransform(this.swigCPtr, this);
    }

    public boolean needsRetrieveTriangles() {
        return CollisionJNI.btGImpactShapeInterface_needsRetrieveTriangles(this.swigCPtr, this);
    }

    public boolean needsRetrieveTetrahedrons() {
        return CollisionJNI.btGImpactShapeInterface_needsRetrieveTetrahedrons(this.swigCPtr, this);
    }

    public void getBulletTriangle(int prim_index, btTriangleShapeEx triangle) {
        CollisionJNI.btGImpactShapeInterface_getBulletTriangle(this.swigCPtr, this, prim_index, btTriangleShapeEx.getCPtr(triangle), triangle);
    }

    public void getBulletTetrahedron(int prim_index, btTetrahedronShapeEx tetrahedron) {
        CollisionJNI.btGImpactShapeInterface_getBulletTetrahedron(this.swigCPtr, this, prim_index, btTetrahedronShapeEx.getCPtr(tetrahedron), tetrahedron);
    }

    public void lockChildShapes() {
        CollisionJNI.btGImpactShapeInterface_lockChildShapes(this.swigCPtr, this);
    }

    public void unlockChildShapes() {
        CollisionJNI.btGImpactShapeInterface_unlockChildShapes(this.swigCPtr, this);
    }

    public void getPrimitiveTriangle(int index, btPrimitiveTriangle triangle) {
        CollisionJNI.btGImpactShapeInterface_getPrimitiveTriangle(this.swigCPtr, this, index, btPrimitiveTriangle.getCPtr(triangle), triangle);
    }

    public void getChildAabb(int child_index, Matrix4 t, Vector3 aabbMin, Vector3 aabbMax) {
        CollisionJNI.btGImpactShapeInterface_getChildAabb(this.swigCPtr, this, child_index, t, aabbMin, aabbMax);
    }

    public btCollisionShape getChildShape(int index) {
        long cPtr = CollisionJNI.btGImpactShapeInterface_getChildShape(this.swigCPtr, this, index);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public btCollisionShape getChildShapeConst(int index) {
        long cPtr = CollisionJNI.btGImpactShapeInterface_getChildShapeConst(this.swigCPtr, this, index);
        return cPtr == 0L ? null : btCollisionShape.newDerivedObject(cPtr, false);
    }

    public Matrix4 getChildTransform(int index) {
        return CollisionJNI.btGImpactShapeInterface_getChildTransform(this.swigCPtr, this, index);
    }

    public void setChildTransform(int index, Matrix4 transform) {
        CollisionJNI.btGImpactShapeInterface_setChildTransform(this.swigCPtr, this, index, transform);
    }

    public void rayTest(Vector3 rayFrom, Vector3 rayTo, RayResultCallback resultCallback) {
        CollisionJNI.btGImpactShapeInterface_rayTest(this.swigCPtr, this, rayFrom, rayTo, RayResultCallback.getCPtr(resultCallback), resultCallback);
    }

    public void processAllTrianglesRay(btTriangleCallback arg0, Vector3 arg1, Vector3 arg2) {
        CollisionJNI.btGImpactShapeInterface_processAllTrianglesRay(this.swigCPtr, this, btTriangleCallback.getCPtr(arg0), arg0, arg1, arg2);
    }
}

